/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.compiler.model;

import org.eclipse.imp.prefspecs.compiler.codegen.FieldCodeGenerator;
import org.eclipse.imp.prefspecs.compiler.model.BooleanFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.IPageMember;
import org.eclipse.imp.prefspecs.compiler.model.IPageMemberContainer;
import org.eclipse.ui.console.MessageConsoleStream;

public abstract class FieldInfo
implements IPageMember {
    protected IPageMemberContainer fParent = null;
    protected String fName = null;
    protected String fToolTipText = null;
    protected boolean fHasRemovableSpec = false;
    protected boolean fIsRemovable = false;
    protected String fOptLabel = null;
    protected boolean fIsConditional = false;
    protected boolean fConditionalWith = true;
    protected BooleanFieldInfo fConditionField = null;

    public FieldInfo(IPageMemberContainer parent, String name) {
        if (parent == null) {
            throw new IllegalArgumentException("FieldInfo(..): parent is null; not allowed");
        }
        if (name == null) {
            throw new IllegalArgumentException("FieldInfo(..): name is null; not allowed");
        }
        this.fParent = parent;
        this.fName = name;
        this.fParent.addChild(this);
    }

    public abstract FieldCodeGenerator getCodeGenerator();

    public IPageMemberContainer getParent() {
        return this.fParent;
    }

    public String getName() {
        return this.fName;
    }

    public boolean hasRemovableSpec() {
        return this.fHasRemovableSpec;
    }

    public boolean getIsRemovable() {
        return this.fIsRemovable;
    }

    public void setIsRemovable(boolean isRemovable) {
        this.fIsRemovable = isRemovable;
        this.fHasRemovableSpec = true;
    }

    public String getLabel() {
        return this.fOptLabel;
    }

    public void setLabel(String newLabel) {
        this.fOptLabel = newLabel;
    }

    public String getToolTipText() {
        return this.fToolTipText;
    }

    public void setToolTipText(String toolTipText) {
        this.fToolTipText = toolTipText;
    }

    public boolean getIsConditional() {
        return this.fIsConditional;
    }

    public void setIsConditional(boolean b) {
        this.fIsConditional = b;
    }

    public boolean getConditionalWith() {
        return this.fConditionalWith;
    }

    public void setConditionalWith(boolean b) {
        this.fConditionalWith = b;
    }

    public BooleanFieldInfo getConditionField() {
        return this.fConditionField;
    }

    public void setConditionField(BooleanFieldInfo vbf) {
        this.fConditionField = vbf;
    }

    public void dump(String prefix, MessageConsoleStream out) {
        String indent = prefix + "  ";
        out.println(prefix + "Field '" + this.getName() + "'");
        out.println(indent + "parent = " + this.getParent().getName());
        out.println(indent + "isRemovable = " + this.fIsRemovable);
        if (this.fIsConditional) {
            out.println(indent + "isConditional " + (this.fConditionalWith ? "with" : "against") + " " + (this.fConditionField != null ? this.fConditionField.getName() : "<unknown>"));
        } else {
            out.println(indent + "isConditional  = false");
        }
    }

    public String toString() {
        return "field " + this.getName();
    }
}

