/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class MakeLeftRecursiveRefactoring
extends Refactoring {
    private final IFile fGrammarFile;
    private final LPGParser.ASTNode fNode;

    public MakeLeftRecursiveRefactoring(UniversalEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this.fGrammarFile = fileInput.getFile();
            this.fNode = this.findNode(editor);
        } else {
            this.fGrammarFile = null;
            this.fNode = null;
        }
    }

    private LPGParser.ASTNode findNode(UniversalEditor editor) {
        Point sel = editor.getSelection();
        IParseController parseController = editor.getParseController();
        LPGParser.ASTNode root = (LPGParser.ASTNode)parseController.getCurrentAst();
        ISourcePositionLocator locator = parseController.getSourcePositionLocator();
        return (LPGParser.ASTNode)locator.findNode((Object)root, sel.x);
    }

    public String getName() {
        return "Make Left Recursive";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!(this.fNode instanceof LPGParser.nonTerm) && !(this.fNode instanceof LPGParser.rule)) {
            return RefactoringStatus.createFatalErrorStatus((String)"Make Left Recursive is only valid for non-terminals and recursive productions");
        }
        if (this.fNode instanceof LPGParser.nonTerm) {
            LPGParser.nonTerm nt = (LPGParser.nonTerm)this.fNode;
            LPGParser.ruleList rhSides = nt.getruleList();
            for (int i = 0; i < rhSides.size(); ++i) {
                this.checkProduction((LPGParser.rule)rhSides.getElementAt(i), nt);
            }
        } else {
            LPGParser.rule prod = (LPGParser.rule)this.fNode;
            this.checkProduction(prod, (LPGParser.nonTerm)prod.getParent());
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkProduction(LPGParser.rule prod, LPGParser.nonTerm nt) {
        LPGParser.symWithAttrsList rhsSyms = prod.getsymWithAttrsList();
        int N = rhsSyms.size();
        for (int i = 0; i < N; ++i) {
            if (!rhsSyms.getElementAt(i).toString().equals(nt.getruleNameWithAttributes().getSYMBOL().toString())) continue;
            return RefactoringStatus.createFatalErrorStatus((String)"Non-terminal must have the form 'a ::= b c ... a'");
        }
        if (!rhsSyms.getElementAt(N - 1).toString().equals(nt.getruleNameWithAttributes().getSYMBOL().toString())) {
            return RefactoringStatus.createFatalErrorStatus((String)"Non-terminal must have the form 'a ::= b c ... a'");
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    private void rewriteProduction(LPGParser.rule prod, LPGParser.nonTerm nt, TextFileChange tfc) {
        String ntSym = nt.getruleNameWithAttributes().getSYMBOL().toString();
        LPGParser.symWithAttrsList syms = prod.getsymWithAttrsList();
        int N = syms.size();
        LPGParser.ASTNode symToDelete = syms.getElementAt(N - 1);
        int deleteStart = symToDelete.getLeftIToken().getStartOffset();
        int deleteEnd = symToDelete.getRightIToken().getEndOffset();
        if (!symToDelete.getLeftIToken().toString().equals(ntSym.toString())) {
            return;
        }
        tfc.addEdit((TextEdit)new DeleteEdit(deleteStart, deleteEnd - deleteStart + 1));
        tfc.addEdit((TextEdit)new InsertEdit(syms.getElementAt(0).getLeftIToken().getStartOffset(), ntSym + " "));
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        TextFileChange tfc = new TextFileChange("Make Left Recursive", this.fGrammarFile);
        tfc.setEdit((TextEdit)new MultiTextEdit());
        if (this.fNode instanceof LPGParser.nonTerm) {
            LPGParser.nonTerm nt = (LPGParser.nonTerm)this.fNode;
            LPGParser.ruleList rhSides = nt.getruleList();
            for (int i = 0; i < rhSides.size(); ++i) {
                this.rewriteProduction((LPGParser.rule)rhSides.getElementAt(i), nt, tfc);
            }
        } else {
            LPGParser.rule prod = (LPGParser.rule)this.fNode;
            LPGParser.nonTerm nt = (LPGParser.nonTerm)prod.getParent();
            this.rewriteProduction(prod, nt, tfc);
        }
        return tfc;
    }
}

