/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class ConditionalBranchInstruction
extends Instruction {
    private final int label;

    protected ConditionalBranchInstruction(short opcode, int label) {
        super(opcode);
        this.label = label;
    }

    public static ConditionalBranchInstruction make(String type, Operator operator, int label) throws IllegalArgumentException {
        short opcode;
        int t = Util.getTypeIndex(type);
        switch (t) {
            case 0: {
                opcode = (short)(159 + (operator.ordinal() - Operator.EQ.ordinal()));
                break;
            }
            case 4: {
                if (operator != Operator.EQ && operator != Operator.NE) {
                    throw new IllegalArgumentException("Cannot test for condition " + operator + " on a reference");
                }
                opcode = (short)(165 + (operator.ordinal() - Operator.EQ.ordinal()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot conditionally branch on a value of type " + type);
            }
        }
        return ConditionalBranchInstruction.make(opcode, label);
    }

    public static ConditionalBranchInstruction make(short opcode, int label) throws IllegalArgumentException {
        if (opcode < 153 || opcode > 166) {
            throw new IllegalArgumentException("Illegal opcode: " + opcode);
        }
        return new ConditionalBranchInstruction(opcode, label);
    }

    public boolean equals(Object o) {
        if (o instanceof ConditionalBranchInstruction) {
            ConditionalBranchInstruction i = (ConditionalBranchInstruction)o;
            return i.opcode == this.opcode && i.label == this.label;
        }
        return false;
    }

    public String toString() {
        return "ConditionalBranch(" + this.getType() + "," + this.getOperator() + "," + this.label + ")";
    }

    public int[] getBranchTargets() {
        int[] r = new int[]{this.label};
        return r;
    }

    public int getTarget() {
        return this.label;
    }

    public Instruction redirectTargets(int[] targetMap) throws IllegalArgumentException {
        if (targetMap == null) {
            throw new IllegalArgumentException("targetMap is null");
        }
        try {
            return ConditionalBranchInstruction.make(this.opcode, targetMap[this.label]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("bad target map", e);
        }
    }

    public Operator getOperator() {
        if (this.opcode < 165) {
            return Operator.values()[this.opcode - 159];
        }
        return Operator.values()[this.opcode - 165];
    }

    public String getType() {
        return this.opcode < 165 ? "I" : "Ljava/lang/Object;";
    }

    public int hashCode() {
        return 30190 * this.opcode + 384101 * this.label;
    }

    public int getPoppedCount() {
        if (this.opcode >= 153 && this.opcode <= 158) {
            return 1;
        }
        return 2;
    }

    public void visit(Instruction.Visitor v) throws NullPointerException {
        v.visitConditionalBranch(this);
    }

    public boolean isPEI() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator implements IOperator
    {
        EQ,
        NE,
        LT,
        GE,
        GT,
        LE;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static interface IOperator {
    }
}

