/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.imp.editor.IProblemChangedListener;
import org.eclipse.imp.editor.ImageImageDescriptor;
import org.eclipse.imp.editor.internal.ImageDecoratorController;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.model.ISourceEntity;
import org.eclipse.imp.runtime.ImageDescriptorRegistry;
import org.eclipse.imp.runtime.PluginImages;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ProblemsLabelDecorator
implements ILabelDecorator {
    private static final int ERRORTICK_WARNING = 0;
    private static final int ERRORTICK_ERROR = 1;
    private ImageDescriptorRegistry fRegistry = null;
    private ImageDecoratorController fDecoratorController;
    private boolean fUseNewRegistry = true;
    private IProblemChangedListener fProblemChangedListener = null;
    private ListenerList fListeners;

    public ProblemsLabelDecorator(Language lang) {
        this.fDecoratorController = new ImageDecoratorController(lang);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : RuntimePlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object obj) {
        int adornmentFlags = this.computeAdornmentFlags(obj);
        if (adornmentFlags != 0) {
            ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            Point ptBounds = new Point(bounds.width, bounds.height);
            return this.getRegistry().get((ImageDescriptor)this.fDecoratorController.getImageDescriptor(baseImage, obj, ptBounds));
        }
        return image;
    }

    protected int computeAdornmentFlags(Object obj) {
        try {
            if (obj instanceof ISourceEntity) {
                ISourceEntity element = (ISourceEntity)obj;
                IResource res = element.getResource();
                int depth = 2;
                if (element instanceof ICompilationUnit) {
                    depth = 1;
                }
                return this.getErrorTicksFromMarkers(res, depth);
            }
            if (obj instanceof IResource) {
                return this.getErrorTicksFromMarkers((IResource)obj, 2);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 376) {
                return 0;
            }
            RuntimePlugin.getInstance().logException("", e);
        }
        return 0;
    }

    private int getErrorTicksFromMarkers(IResource res, int depth) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return 0;
        }
        int info = 0;
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        if (markers != null) {
            for (int i = 0; i < markers.length && info != 1; ++i) {
                IMarker curr = markers[i];
                int priority = curr.getAttribute("severity", -1);
                if (priority == 1) {
                    info = 0;
                    continue;
                }
                if (priority != 2) continue;
                info = 1;
            }
        }
        return info;
    }

    private int getErrorTicksFromAnnotationModel(IAnnotationModel model) throws CoreException {
        int info = 0;
        Iterator iter = model.getAnnotationIterator();
        while (info != 1 && iter.hasNext()) {
            Annotation annot = (Annotation)iter.next();
            IMarker marker = this.isAnnotationInRange(model, annot);
            if (marker == null) continue;
            int priority = marker.getAttribute("severity", -1);
            if (priority == 1) {
                info = 0;
                continue;
            }
            if (priority != 2) continue;
            info = 1;
        }
        return info;
    }

    private IMarker isAnnotationInRange(IAnnotationModel model, Annotation annot) throws CoreException {
        IMarker marker;
        if (annot instanceof MarkerAnnotation && (marker = ((MarkerAnnotation)annot).getMarker()).exists() && marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
            return marker;
        }
        return null;
    }

    public void dispose() {
        if (this.fProblemChangedListener != null) {
            this.fProblemChangedListener = null;
        }
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
        if (this.fProblemChangedListener == null) {
            this.fProblemChangedListener = new IProblemChangedListener(){

                public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
                    ProblemsLabelDecorator.this.fireProblemsChanged(changedResources, isMarkerChange);
                }
            };
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
            if (this.fListeners.isEmpty() && this.fProblemChangedListener != null) {
                this.fProblemChangedListener = null;
            }
        }
    }

    private void fireProblemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            ProblemsLabelChangedEvent event = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, changedResources, isMarkerChange);
            Object[] listeners = this.fListeners.getListeners();
            for (int i = 0; i < listeners.length; ++i) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged((LabelProviderChangedEvent)event);
            }
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags == 1) {
            decoration.addOverlay(PluginImages.DESC_OVR_ERROR);
        } else if (adornmentFlags == 0) {
            decoration.addOverlay(PluginImages.DESC_OVR_WARNING);
        }
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private static final long serialVersionUID = 1L;
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider eventSource, IResource[] changedResource, boolean isMarkerChange) {
            super(eventSource, (Object[])changedResource);
            this.fMarkerChange = isMarkerChange;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

