/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import org.eclipse.imp.editor.IMPOutlinePage;
import org.eclipse.imp.editor.IRegionSelectionService;
import org.eclipse.imp.editor.LanguageServiceManager;
import org.eclipse.imp.editor.ParserScheduler;
import org.eclipse.imp.editor.internal.CompletionProcessor;
import org.eclipse.imp.editor.internal.FormattingController;
import org.eclipse.imp.editor.internal.HoverHelpController;
import org.eclipse.imp.editor.internal.OutlineController;
import org.eclipse.imp.editor.internal.PresentationController;
import org.eclipse.imp.editor.internal.SourceHyperlinkController;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.ITextEditor;

public class ServiceControllerManager {
    private LanguageServiceManager fLanguageServiceManager;
    private SourceHyperlinkController fHyperLinkController;
    private HoverHelpController fHoverHelpController;
    private FormattingController fFormattingController;
    private IModelListener fOutlineController;
    private PresentationController fPresentationController;
    private CompletionProcessor fCompletionProcessor;
    private final ITextEditor fTextEditor;
    private ISourceViewer fSourceViewer;

    public ServiceControllerManager(ITextEditor textEditor, LanguageServiceManager serviceMgr) {
        this.fTextEditor = textEditor;
        this.fLanguageServiceManager = serviceMgr;
        if (this.fLanguageServiceManager.getHyperLinkDetector() != null) {
            this.fHyperLinkController = new SourceHyperlinkController(this.fLanguageServiceManager.getHyperLinkDetector(), this.fTextEditor);
        }
    }

    public void initialize() {
        IRegionSelectionService regionSelector = (IRegionSelectionService)this.fTextEditor.getAdapter(IRegionSelectionService.class);
        this.fHoverHelpController = new HoverHelpController(this.fLanguageServiceManager.getLanguage());
        this.fFormattingController = new FormattingController(this.fLanguageServiceManager.getFormattingStrategy());
        this.fFormattingController.setParseController(this.fLanguageServiceManager.getParseController());
        this.fOutlineController = this.fLanguageServiceManager.getModelBuilder() != null ? new IMPOutlinePage(this.fLanguageServiceManager.getParseController(), this.fLanguageServiceManager.getModelBuilder(), this.fLanguageServiceManager.getLabelProvider(), this.fLanguageServiceManager.getImageProvider(), this.fLanguageServiceManager.getEntityNameLocator(), regionSelector) : new OutlineController(this.fTextEditor, this.fLanguageServiceManager.getLanguage());
        this.fCompletionProcessor = new CompletionProcessor(this.fLanguageServiceManager.getLanguage());
    }

    public void setSourceViewer(ISourceViewer sourceViewer) {
        this.fSourceViewer = sourceViewer;
        if (this.fLanguageServiceManager.getTokenColorer() != null) {
            this.fPresentationController = new PresentationController(this.fSourceViewer, this.fLanguageServiceManager);
        }
    }

    public void setupModelListeners(ParserScheduler parserScheduler) {
        if (this.fOutlineController != null) {
            parserScheduler.addModelListener(this.fOutlineController);
        }
        if (this.fPresentationController != null) {
            parserScheduler.addModelListener(this.fPresentationController);
        }
        if (this.fHoverHelpController != null) {
            parserScheduler.addModelListener(this.fHoverHelpController);
        }
        if (this.fHyperLinkController != null) {
            parserScheduler.addModelListener(this.fHyperLinkController);
        }
        if (this.fCompletionProcessor != null) {
            parserScheduler.addModelListener(this.fCompletionProcessor);
        }
    }

    public SourceHyperlinkController getHyperLinkController() {
        return this.fHyperLinkController;
    }

    public HoverHelpController getHoverHelpController() {
        return this.fHoverHelpController;
    }

    public FormattingController getFormattingController() {
        return this.fFormattingController;
    }

    public IModelListener getOutlineController() {
        return this.fOutlineController;
    }

    public PresentationController getPresentationController() {
        return this.fPresentationController;
    }

    public ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    public ISourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    public CompletionProcessor getCompletionProcessor() {
        return this.fCompletionProcessor;
    }
}

