/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.editor.LanguageServiceManager;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.preferences.PreferenceCache;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.ITokenColorer;
import org.eclipse.imp.utils.ConsoleUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationController
implements IModelListener {
    public static final String CONSOLE_NAME = "Source Tokens";
    private final ISourceViewer fSourceViewer;
    private final ITokenColorer fColorer;
    private final IParseController fParseCtlr;
    private final Stack<IRegion> fWorkItems = new Stack();

    public PresentationController(ISourceViewer sourceViewer, LanguageServiceManager langServiceMgr) {
        this.fSourceViewer = sourceViewer;
        this.fParseCtlr = langServiceMgr.getParseController();
        this.fColorer = langServiceMgr.getTokenColorer();
    }

    @Override
    public IModelListener.AnalysisRequired getAnalysisRequired() {
        return IModelListener.AnalysisRequired.LEXICAL_ANALYSIS;
    }

    private void dumpToken(Object token, ISourcePositionLocator locator, PrintStream ps) {
        if (locator != null) {
            try {
                IDocument document = this.fSourceViewer.getDocument();
                int startOffset = locator.getStartOffset(token);
                ps.print(" \t" + startOffset);
                ps.print(" \t" + locator.getLength(token));
                int line = document.getLineOfOffset(startOffset);
                ps.print(" \t" + line);
                ps.print(" \t" + (startOffset - document.getLineOffset(line)));
            }
            catch (BadLocationException e) {
                RuntimePlugin.getInstance().logException("Error computing position of token", e);
            }
        }
        ps.print(" \t" + token);
        ps.println();
    }

    private void dumpTokens(Iterator<Object> tokenIter, PrintStream ps) {
        ISourcePositionLocator locator = this.fParseCtlr.getSourcePositionLocator();
        if (locator != null) {
            ps.println(" Offset \tLen \tLine \tCol \tText");
        } else {
            ps.println(" Text");
        }
        while (tokenIter.hasNext()) {
            this.dumpToken(tokenIter.next(), locator, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void damage(IRegion region) {
        if (this.fColorer == null) {
            return;
        }
        IRegion bigRegion = this.fColorer.calculateDamageExtent(region, this.fParseCtlr);
        if (bigRegion != null) {
            Stack<IRegion> stack = this.fWorkItems;
            synchronized (stack) {
                boolean redundant = false;
                for (IRegion dr : this.fWorkItems) {
                    if (!this.contains(bigRegion, dr)) continue;
                    redundant = true;
                }
                if (!redundant) {
                    this.fWorkItems.push(bigRegion);
                }
            }
        }
    }

    private boolean contains(IRegion r1, IRegion r2) {
        return r2.getOffset() <= r1.getOffset() && r2.getOffset() + r2.getLength() >= r1.getOffset() + r1.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(IParseController controller, IProgressMonitor monitor) {
        if (!monitor.isCanceled()) {
            Stack<IRegion> stack = this.fWorkItems;
            synchronized (stack) {
                if (this.fWorkItems.size() == 0) {
                    this.fWorkItems.add((IRegion)new Region(0, this.fSourceViewer.getDocument().getLength()));
                }
                for (int n = this.fWorkItems.size() - 1; !monitor.isCanceled() && n >= 0; --n) {
                    Region damage = (Region)this.fWorkItems.get(n);
                    this.changeTextPresentationForRegion(controller, monitor, (IRegion)damage);
                }
                if (!monitor.isCanceled()) {
                    this.fWorkItems.removeAllElements();
                }
            }
        }
    }

    private void changeTextPresentationForRegion(IParseController parseController, IProgressMonitor monitor, IRegion damage) {
        if (parseController == null) {
            return;
        }
        if (PreferenceCache.dumpTokens) {
            PrintStream ps = ConsoleUtil.findConsoleStream(CONSOLE_NAME);
            this.dumpTokens(parseController.getTokenIterator(damage), ps);
        }
        TextPresentation presentation = new TextPresentation();
        ISourcePositionLocator locator = parseController.getSourcePositionLocator();
        this.aggregateTextPresentation(parseController, monitor, damage, presentation, locator);
        if (monitor.isCanceled()) {
            System.err.println("Ignored cancelled presentation update");
        } else if (presentation.isEmpty()) {
            System.err.println("Ignored empty presentation update");
        } else {
            this.submitTextPresentation(presentation);
        }
    }

    private void aggregateTextPresentation(IParseController parseController, IProgressMonitor monitor, IRegion damage, TextPresentation presentation, ISourcePositionLocator locator) {
        int prevOffset = -1;
        int prevEnd = -1;
        Iterator tokenIterator = parseController.getTokenIterator(damage);
        if (tokenIterator == null) {
            return;
        }
        Iterator iter = tokenIterator;
        while (iter.hasNext() && !monitor.isCanceled()) {
            Object token = iter.next();
            int offset = locator.getStartOffset(token);
            int end = locator.getEndOffset(token);
            if (offset <= prevEnd && end >= prevOffset) continue;
            this.changeTokenPresentation(parseController, presentation, token, locator);
            prevOffset = offset;
            prevEnd = end;
        }
    }

    private void changeTokenPresentation(IParseController controller, TextPresentation presentation, Object token, ISourcePositionLocator locator) {
        TextAttribute attribute = this.fColorer.getColoring(controller, token);
        StyleRange styleRange = new StyleRange(locator.getStartOffset(token), locator.getEndOffset(token) - locator.getStartOffset(token) + 1, attribute == null ? null : attribute.getForeground(), attribute == null ? null : attribute.getBackground(), attribute == null ? 0 : attribute.getStyle());
        if (styleRange.length > 0 && styleRange.start + styleRange.length <= this.fSourceViewer.getDocument().getLength()) {
            presentation.addStyleRange(styleRange);
        }
    }

    private void submitTextPresentation(final TextPresentation presentation) {
        if (this.fSourceViewer == null) {
            return;
        }
        int docLength = this.fSourceViewer.getDocument() != null ? this.fSourceViewer.getDocument().getLength() : 0;
        final TextPresentation newPresentation = this.fixPresentation(presentation, docLength, false);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    if (PresentationController.this.fSourceViewer != null) {
                        int newDocLength = PresentationController.this.fSourceViewer.getDocument() != null ? PresentationController.this.fSourceViewer.getDocument().getLength() : 0;
                        IRegion presExtent = newPresentation.getExtent();
                        if (presExtent.getOffset() + presExtent.getLength() > newDocLength) {
                            newPresentation.setResultWindow((IRegion)new Region(presExtent.getOffset(), newDocLength - presExtent.getOffset()));
                        }
                        PresentationController.this.fSourceViewer.changeTextPresentation(newPresentation, true);
                    }
                }
                catch (IllegalArgumentException e) {
                    int curDocLength = PresentationController.this.fSourceViewer.getDocument() != null ? PresentationController.this.fSourceViewer.getDocument().getLength() : 0;
                    PresentationController.this.diagnoseStyleRangeError(presentation, curDocLength, e);
                }
            }
        });
    }

    private TextPresentation fixPresentation(TextPresentation presentation, int docLen, boolean sort) {
        if (this.checkPresentation(presentation, docLen)) {
            return presentation;
        }
        int lastStart = presentation.getLastStyleRange().start;
        int lastLength = presentation.getLastStyleRange().length;
        int end = lastStart + lastLength;
        ArrayList<StyleRange> newRanges = new ArrayList<StyleRange>(presentation.getDenumerableRanges());
        Iterator presIt = presentation.getAllStyleRangeIterator();
        while (presIt.hasNext()) {
            StyleRange nextRange = (StyleRange)presIt.next();
            if (nextRange.start >= docLen) continue;
            if (nextRange.start + nextRange.length > docLen) {
                nextRange.length = docLen - nextRange.start;
            }
            newRanges.add(nextRange);
        }
        Collections.sort(newRanges, new Comparator<StyleRange>(){

            @Override
            public int compare(StyleRange o1, StyleRange o2) {
                return o1.start - o2.start;
            }
        });
        StyleRange prevRange = (StyleRange)newRanges.get(0);
        for (int i = 1; i < newRanges.size(); ++i) {
            StyleRange currRange = (StyleRange)newRanges.get(i);
            if (currRange.start < prevRange.start + prevRange.length) {
                prevRange.length = currRange.start - prevRange.start;
            }
            prevRange = currRange;
        }
        Iterator ri = newRanges.iterator();
        while (ri.hasNext()) {
            StyleRange r = (StyleRange)ri.next();
            if (r.length > 0) continue;
            ri.remove();
        }
        TextPresentation newPresentation = new TextPresentation();
        for (StyleRange r : newRanges) {
            newPresentation.addStyleRange(r);
        }
        return newPresentation;
    }

    private boolean checkPresentation(TextPresentation presentation, int docLen) {
        Iterator presIt = presentation.getAllStyleRangeIterator();
        int end = -1;
        while (presIt.hasNext()) {
            StyleRange r = (StyleRange)presIt.next();
            int rangeStart = r.start;
            int rangeLen = r.length;
            if (rangeStart < end) {
                return false;
            }
            if (rangeLen < 1) {
                return false;
            }
            if (rangeStart + rangeLen > docLen) {
                return false;
            }
            end = Math.max(end, rangeStart + rangeLen);
        }
        return true;
    }

    private void diagnoseStyleRangeError(TextPresentation presentation, int charCount, IllegalArgumentException e) {
        Iterator ranges = presentation.getAllStyleRangeIterator();
        ArrayList<StyleRange> rangesList = new ArrayList<StyleRange>();
        while (ranges.hasNext()) {
            rangesList.add((StyleRange)ranges.next());
        }
        StringBuilder explanation = new StringBuilder();
        if (rangesList.size() > 0) {
            int finalLength;
            int finalStart;
            int finalEnd;
            StyleRange firstRange = (StyleRange)rangesList.get(0);
            if (firstRange.length < 0) {
                explanation.append("Style range with start = " + firstRange.start + " has negative length = " + firstRange.length);
            }
            StyleRange prevRange = firstRange;
            for (int i = 1; i < rangesList.size(); ++i) {
                StyleRange currRange = (StyleRange)rangesList.get(i);
                int currStart = currRange.start;
                int currLength = currRange.length;
                if (currLength < 0) {
                    explanation.append("Style range with start = " + currStart + " has negative length = " + currLength);
                    break;
                }
                int prevStart = prevRange.start;
                int prevLength = prevRange.length;
                if (prevStart + prevLength - 1 >= currStart) {
                    explanation.append("Style range with start = " + prevStart + " and length = " + prevLength + " overlaps style range with start = " + currStart);
                    break;
                }
                prevRange = currRange;
            }
            if ((finalEnd = (finalStart = presentation.getLastStyleRange().start) + (finalLength = presentation.getLastStyleRange().length)) >= charCount) {
                explanation.append("Final style range with start = " + finalStart + " and length = " + finalLength + " extends beyond last character (character count = " + charCount + ")");
            }
            if (explanation.length() == 0) {
                explanation.append("Cause not identified");
            }
        }
        ErrorHandler.logError("Malformed TextPresentation:" + explanation, e);
    }
}

