/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.smapi;

import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ClassWriter;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.SourceDebugExtensionWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.imp.smapi.LineMapBuilder;
import org.eclipse.imp.smapi.SMAPCreator;

public class Main {
    public static boolean debug = false;

    public static void main(String[] args) {
        String MAIN_CLASS = args[0];
        Main.smapify(MAIN_CLASS, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void smapify(String filename, String relPathPrefix, String outputfile) {
        String prefix = Main.removeExt(filename);
        String origExten = filename.substring(filename.lastIndexOf(46) + 1);
        if (debug) {
            System.out.println("origExten=" + origExten);
            System.out.println("smapify filename: " + filename);
            System.out.println("with pathPrefix: " + relPathPrefix);
            System.out.println("and outputfile: " + outputfile);
        }
        LineMapBuilder lmb = new LineMapBuilder(prefix);
        String smap = SMAPCreator.get(prefix, relPathPrefix, lmb.get(), origExten);
        if (debug) {
            System.out.println(smap);
        }
        FileOutputStream fw = null;
        OfflineInstrumenter oi = null;
        try {
            String inputName = outputfile == null ? prefix + ".class" : outputfile;
            File input = new File(inputName);
            oi = new OfflineInstrumenter();
            oi.addInputClass(input);
            oi.beginTraversal();
            ClassInstrumenter ci = oi.nextClass();
            ClassReader cr = ci.getReader();
            ClassWriter w = new ClassWriter();
            Main.copyClassProperties(cr, w);
            Main.copyMembersAndAttributes(cr, w);
            Main.addSMAPAttribute(smap, w);
            fw = new FileOutputStream(new File(inputName));
            fw.write(w.makeBytes());
            fw.close();
            oi.close();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
                if (oi != null) {
                    oi.close();
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    private static void copyClassProperties(ClassReader cr, ClassWriter w) throws InvalidClassFileException {
        w.setRawCP(cr.getCP(), true);
        w.setMajorVersion(cr.getMajorVersion());
        w.setMinorVersion(cr.getMinorVersion());
        w.setAccessFlags(cr.getAccessFlags());
        w.setName(cr.getName());
        w.setSuperName(cr.getSuperName());
        w.setInterfaceNames(cr.getInterfaceNames());
    }

    private static void copyMembersAndAttributes(ClassReader cr, ClassWriter w) throws InvalidClassFileException, Exception {
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        int fieldCount = cr.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            cr.initFieldAttributeIterator(i, iter);
            w.addField(cr.getFieldAccessFlags(i), cr.getFieldName(i), cr.getFieldType(i), Main.collectAttributes(cr, iter));
        }
        int methodCount = cr.getMethodCount();
        for (int i = 0; i < methodCount; ++i) {
            cr.initMethodAttributeIterator(i, iter);
            w.addMethod(cr.getMethodAccessFlags(i), cr.getMethodName(i), cr.getMethodType(i), Main.collectAttributes(cr, iter));
        }
        cr.initClassAttributeIterator(iter);
        while (iter.isValid()) {
            w.addClassAttribute(Main.getRawAttribute(cr, iter));
            iter.advance();
        }
    }

    private static void addSMAPAttribute(String smap, ClassWriter w) {
        SourceDebugExtensionWriter sw = new SourceDebugExtensionWriter(w);
        sw.setDebugInfo(smap);
        w.addClassAttribute((ClassWriter.Element)sw);
    }

    private static String removeExt(String filename) {
        int i = filename.lastIndexOf(".");
        return filename.substring(0, i);
    }

    private static ClassWriter.Element[] collectAttributes(ClassReader cr, ClassReader.AttrIterator iter) throws Exception {
        ClassWriter.Element[] elems = new ClassWriter.Element[iter.getRemainingAttributesCount()];
        for (int i = 0; i < elems.length; ++i) {
            elems[i] = Main.getRawAttribute(cr, iter);
            iter.advance();
        }
        return elems;
    }

    private static ClassWriter.Element getRawAttribute(ClassReader cr, ClassReader.AttrIterator iter) {
        int offset = iter.getRawOffset();
        int end = offset + iter.getRawSize();
        return new ClassWriter.RawElement(cr.getBytes(), offset, end - offset);
    }
}

