/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.imp.builder.DependencyInfo;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesService;
import org.eclipse.imp.runtime.PluginBase;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.utils.UnimplementedError;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuilderBase
extends IncrementalProjectBuilder {
    public static final String IMP_BUILDER_CONSOLE = "IMP Builders";
    private final IResourceVisitor fResourceVisitor = new SourceCollectorVisitor();
    private final IResourceDeltaVisitor fDeltaVisitor = new SourceDeltaVisitor();
    private IPreferencesService fPrefService;
    protected DependencyInfo fDependencyInfo;
    private final Collection<IFile> fChangedSources = new HashSet<IFile>();
    private final Collection<IFile> fSourcesToCompile = new HashSet<IFile>();
    private final Collection<IFile> fSourcesForDeps = new HashSet<IFile>();

    protected abstract PluginBase getPlugin();

    public String getBuilderID() {
        throw new UnimplementedError("Not implemented for builder for plug-in " + this.getPlugin().getID());
    }

    protected abstract boolean isSourceFile(IFile var1);

    protected abstract boolean isNonRootSourceFile(IFile var1);

    protected abstract boolean isOutputFolder(IResource var1);

    protected abstract void compile(IFile var1, IProgressMonitor var2);

    protected abstract void collectDependencies(IFile var1);

    protected abstract String getErrorMarkerID();

    protected abstract String getWarningMarkerID();

    protected abstract String getInfoMarkerID();

    private boolean processResource(IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (file.exists() && (this.isSourceFile(file) || this.isNonRootSourceFile(file))) {
                this.fChangedSources.add(file);
            }
            return false;
        }
        return !this.isOutputFolder(resource);
    }

    protected DependencyInfo createDependencyInfo(IProject project) {
        return new DependencyInfo(project);
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) {
        if (this.getPreferencesService().getProject() == null) {
            this.getPreferencesService().setProject(this.getProject());
        }
        this.fChangedSources.clear();
        this.fSourcesForDeps.clear();
        this.fSourcesToCompile.clear();
        boolean partialDeps = true;
        ArrayList<IFile> allSources = new ArrayList<IFile>();
        if (this.fDependencyInfo == null || kind == 6 || kind == 15) {
            this.fDependencyInfo = this.createDependencyInfo(this.getProject());
            try {
                this.getProject().accept((IResourceVisitor)new AllSourcesVisitor(allSources));
            }
            catch (CoreException e) {
                this.getPlugin().getLog().log((IStatus)new Status(4, this.getPlugin().getID(), e.getLocalizedMessage(), (Throwable)e));
            }
            this.fSourcesForDeps.addAll(allSources);
            this.collectDependencies(monitor);
            partialDeps = false;
        }
        if (kind == 6 || kind == 15) {
            this.clearMarkersOn(allSources);
        }
        try {
            this.collectSourcesToCompile(monitor);
            this.clearDependencyInfoForChangedFiles();
            if (partialDeps) {
                this.fSourcesForDeps.addAll(this.fSourcesToCompile);
                this.fSourcesForDeps.addAll(this.fChangedSources);
                this.collectDependencies(monitor);
            }
            this.compileNecessarySources(monitor);
            if (this.getDiagPreference()) {
                this.getConsoleStream().print(this.fDependencyInfo.toString());
            }
        }
        catch (CoreException e) {
            this.getPlugin().writeErrorMsg("Build failed: " + e.getMessage());
        }
        return new IProject[0];
    }

    protected void compileNecessarySources(IProgressMonitor monitor) {
        for (IFile srcFile : this.fSourcesToCompile) {
            this.clearMarkersOn(srcFile);
            if (!this.isSourceFile(srcFile)) continue;
            this.compile(srcFile, monitor);
        }
    }

    protected void collectDependencies(IProgressMonitor monitor) {
        for (IFile srcFile : this.fSourcesForDeps) {
            this.collectDependencies(srcFile);
        }
    }

    protected void clearMarkersOn(IFile file) {
        try {
            file.deleteMarkers(this.getErrorMarkerID(), true, 2);
            file.deleteMarkers(this.getWarningMarkerID(), true, 2);
            file.deleteMarkers(this.getInfoMarkerID(), true, 2);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void clearMarkersOn(Collection<IFile> files) {
        for (IFile file : files) {
            this.clearMarkersOn(file);
        }
    }

    private void dumpSourceList(Collection<IFile> sourcesToCompile) {
        MessageConsoleStream consoleStream = this.getConsoleStream();
        for (IFile srcFile : sourcesToCompile) {
            consoleStream.println("  " + srcFile.getFullPath());
        }
    }

    private void clearDependencyInfoForChangedFiles() {
        for (IFile srcFile : this.fSourcesToCompile) {
            this.fDependencyInfo.clearDependenciesOf(srcFile.getFullPath().toString());
        }
    }

    protected IPreferencesService getPreferencesService() {
        if (this.fPrefService == null) {
            this.fPrefService = new PreferencesService(null, this.getPlugin().getLanguageID());
        }
        return this.fPrefService;
    }

    protected boolean getDiagPreference() {
        PreferencesService builderPrefSvc = this.getPlugin().getPreferencesService();
        PreferencesService impPrefSvc = RuntimePlugin.getInstance().getPreferencesService();
        boolean msgs = builderPrefSvc.isDefined("emitBuilderDiagnostics") ? builderPrefSvc.getBooleanPreference("emitBuilderDiagnostics") : impPrefSvc.getBooleanPreference("emitBuilderDiagnostics");
        return msgs;
    }

    private void collectSourcesToCompile(IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta = this.getDelta(this.getProject());
        boolean emitDiags = this.getDiagPreference();
        if (delta != null) {
            if (emitDiags) {
                this.getConsoleStream().println("==> Scanning resource delta for project '" + this.getProject().getName() + "'... <==");
            }
            delta.accept(this.fDeltaVisitor);
            if (emitDiags) {
                this.getConsoleStream().println("Delta scan completed for project '" + this.getProject().getName() + "'...");
            }
        } else {
            if (emitDiags) {
                this.getConsoleStream().println("==> Scanning for source files in project '" + this.getProject().getName() + "'... <==");
            }
            this.getProject().accept(this.fResourceVisitor);
            if (emitDiags) {
                this.getConsoleStream().println("Source file scan completed for project '" + this.getProject().getName() + "'...");
            }
        }
        this.collectChangeDependents();
        if (emitDiags) {
            this.getConsoleStream().println("All files to compile:");
            this.dumpSourceList(this.fSourcesToCompile);
        }
    }

    private void collectChangeDependents() {
        HashSet<IFile> additions;
        if (this.fChangedSources.size() == 0) {
            return;
        }
        HashSet<IFile> changeDependents = new HashSet<IFile>();
        boolean emitDiags = this.getDiagPreference();
        changeDependents.addAll(this.fChangedSources);
        if (emitDiags) {
            this.getConsoleStream().println("Changed files:");
            this.dumpSourceList(changeDependents);
        }
        boolean changed = false;
        do {
            additions = new HashSet<IFile>();
            this.scanSourceList(changeDependents, additions);
        } while (changed = changeDependents.addAll(additions));
        for (IFile f : changeDependents) {
            if (!this.isSourceFile(f)) continue;
            this.fSourcesToCompile.add(f);
        }
    }

    private boolean scanSourceList(Collection<IFile> srcList, Collection<IFile> changeDependents) {
        boolean result = false;
        for (IFile srcFile : srcList) {
            Set<String> fileDependents = this.fDependencyInfo.getDependentsOf(srcFile.getFullPath().toString());
            if (fileDependents == null) continue;
            for (String depPath : fileDependents) {
                IFile depFile = this.getProject().getWorkspace().getRoot().getFile((IPath)new Path(depPath));
                result = result || changeDependents.add(depFile);
            }
        }
        return result;
    }

    protected void doRefresh(final IResource resource) {
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                resource.getProject().refreshLocal(2, null);
            }
        };
        try {
            this.getProject().getWorkspace().run(r, (ISchedulingRule)resource.getProject(), 1, null);
        }
        catch (CoreException e) {
            this.getPlugin().logException("Error while refreshing after a build", e);
        }
    }

    protected String getMarkerIDFor(int severity) {
        switch (severity) {
            case 2: {
                return this.getErrorMarkerID();
            }
            case 1: {
                return this.getWarningMarkerID();
            }
            case 0: {
                return this.getInfoMarkerID();
            }
        }
        return this.getInfoMarkerID();
    }

    public IMarker createMarker(IResource errorResource, int startLine, int charStart, int charEnd, String message, int severity) {
        try {
            if (!errorResource.exists()) {
                return null;
            }
            IMarker m = errorResource.createMarker(this.getMarkerIDFor(severity));
            String[] attributeNames = new String[]{"lineNumber", "message", "priority", "severity"};
            Object[] values = new Object[]{startLine, message, 2, severity};
            m.setAttributes(attributeNames, values);
            if (charStart >= 0 && charEnd >= 0) {
                attributeNames = new String[]{"charStart", "charEnd"};
                values = new Object[]{charStart, charEnd};
                m.setAttributes(attributeNames, values);
            } else if (charStart >= 0) {
                m.setAttribute("charStart", charStart);
            } else if (charEnd >= 0) {
                m.setAttribute("charEnd", charEnd);
            }
            return m;
        }
        catch (CoreException e) {
            this.getPlugin().writeErrorMsg("Unable to create marker: " + e.getMessage());
            return null;
        }
    }

    protected void postMsgDialog(final String title, final String msg) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Shell shell = RuntimePlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
            }
        });
    }

    protected void postQuestionDialog(final String title, final String query, final Runnable runIfYes, final Runnable runIfNo) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Shell shell = RuntimePlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
                boolean response = MessageDialog.openQuestion((Shell)shell, (String)title, (String)query);
                if (response) {
                    runIfYes.run();
                } else if (runIfNo != null) {
                    runIfNo.run();
                }
            }
        });
    }

    protected String getConsoleName() {
        return IMP_BUILDER_CONSOLE;
    }

    protected MessageConsoleStream getConsoleStream() {
        return this.findConsole(this.getConsoleName()).newMessageStream();
    }

    protected MessageConsole findConsole(String consoleName) {
        if (consoleName == null) {
            RuntimePlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.imp.runtime", "BuilderBase.findConsole() called with a null console name; substituting default console"));
            consoleName = IMP_BUILDER_CONSOLE;
        }
        MessageConsole myConsole = null;
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = consoleManager.getConsoles();
        for (int i = 0; i < consoles.length; ++i) {
            IConsole console = consoles[i];
            if (!console.getName().equals(consoleName)) continue;
            myConsole = (MessageConsole)console;
        }
        if (myConsole == null) {
            myConsole = new MessageConsole(consoleName, null);
            consoleManager.addConsoles(new IConsole[]{myConsole});
        }
        return myConsole;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AllSourcesVisitor
    implements IResourceVisitor {
        private final Collection<IFile> fResult;

        public AllSourcesVisitor(Collection<IFile> result) {
            this.fResult = result;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (file.exists() && (BuilderBase.this.isSourceFile(file) || BuilderBase.this.isNonRootSourceFile(file))) {
                    this.fResult.add(file);
                }
                return false;
            }
            return !BuilderBase.this.isOutputFolder(resource);
        }
    }

    private class SourceCollectorVisitor
    implements IResourceVisitor {
        private SourceCollectorVisitor() {
        }

        public boolean visit(IResource res) throws CoreException {
            return BuilderBase.this.processResource(res);
        }
    }

    private final class SourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private SourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            return BuilderBase.this.processResource(delta.getResource());
        }
    }
}

