/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.runtime.IPluginLog;

public abstract class ProjectNatureBase
implements IProjectNature {
    private IProject fProject;

    public abstract String getNatureID();

    public abstract String getBuilderID();

    public abstract IPluginLog getLog();

    protected abstract void refreshPrefs();

    protected String getDownstreamBuilderID() {
        return null;
    }

    protected String getUpstreamBuilderID() {
        return null;
    }

    public void addToProject(IProject project) {
        String natureID = this.getNatureID();
        this.refreshPrefs();
        IPluginLog log = this.getLog();
        log.maybeWriteInfoMsg("Attempting to add nature " + natureID);
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = natureID;
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
            IProjectDescription newDesc = project.getDescription();
            ICommand[] builders = newDesc.getBuildSpec();
            String builderID = this.getBuilderID();
            for (int i = 0; i < builders.length; ++i) {
                if (!builders[i].getBuilderName().equals(builderID)) continue;
                builders[i].setArguments(this.getBuilderArguments());
            }
            newDesc.setBuildSpec(builders);
            project.setDescription(newDesc, null);
            this.getLog().maybeWriteInfoMsg("Added nature " + natureID);
        }
        catch (CoreException e) {
            this.getLog().writeErrorMsg("Failed to add nature " + natureID + ": " + e.getMessage());
        }
    }

    public void configure() throws CoreException {
        IProjectDescription desc = this.getProject().getDescription();
        String builderID = this.getBuilderID();
        ICommand[] cmds = desc.getBuildSpec();
        for (int i = 0; i < cmds.length; ++i) {
            if (!cmds[i].getBuilderName().equals(builderID)) continue;
            return;
        }
        int beforeWhere = cmds.length;
        String downstreamBuilderID = this.getDownstreamBuilderID();
        if (downstreamBuilderID != null) {
            --beforeWhere;
            while (beforeWhere >= 0 && !cmds[beforeWhere].getBuilderName().equals(downstreamBuilderID)) {
                --beforeWhere;
            }
            if (beforeWhere < 0) {
                this.getLog().writeErrorMsg("Unable to find downstream builder '" + downstreamBuilderID + "' for builder '" + builderID + "'.");
                beforeWhere = 0;
            }
        }
        int afterWhere = -1;
        String upstreamBuilderID = this.getUpstreamBuilderID();
        if (upstreamBuilderID != null) {
            for (afterWhere = 0; afterWhere < cmds.length && !cmds[afterWhere].getBuilderName().equals(upstreamBuilderID); ++afterWhere) {
            }
            if (afterWhere == cmds.length) {
                this.getLog().writeErrorMsg("Unable to find upstream builder '" + upstreamBuilderID + "' for builder '" + builderID + "'.");
                afterWhere = cmds.length - 1;
            }
        }
        if (beforeWhere <= afterWhere) {
            this.getLog().writeErrorMsg("Error: builder '" + builderID + "' needs to be before downstream builder '" + downstreamBuilderID + "' but after builder " + upstreamBuilderID + ", but " + downstreamBuilderID + " comes after " + upstreamBuilderID + "!");
        }
        if (beforeWhere == cmds.length && afterWhere >= 0) {
            beforeWhere = afterWhere + 1;
        }
        ICommand compilerCmd = desc.newCommand();
        compilerCmd.setBuilderName(builderID);
        ICommand[] newCmds = new ICommand[cmds.length + 1];
        System.arraycopy(cmds, 0, newCmds, 0, beforeWhere);
        newCmds[beforeWhere] = compilerCmd;
        System.arraycopy(cmds, beforeWhere, newCmds, beforeWhere + 1, cmds.length - beforeWhere);
        desc.setBuildSpec(newCmds);
        this.getProject().setDescription(desc, null);
    }

    protected Map getBuilderArguments() {
        return new HashMap();
    }

    public void deconfigure() throws CoreException {
        IProjectDescription desc = this.getProject().getDescription();
        String builderID = this.getBuilderID();
        ICommand[] cmds = desc.getBuildSpec();
        for (int i = 0; i < cmds.length; ++i) {
            if (!cmds[i].getBuilderName().equals(builderID)) continue;
            ICommand[] newCmds = new ICommand[cmds.length - 1];
            System.arraycopy(cmds, 0, newCmds, 0, i);
            System.arraycopy(cmds, i + 1, newCmds, i, cmds.length - i - 1);
            desc.setBuildSpec(newCmds);
            this.getProject().setDescription(desc, null);
            return;
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }
}

