/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IUpdate;

public class GenerateActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.imp.source.menu";
    public static final String GROUP_IMPORT = "importGroup";
    public static final String GROUP_GENERATE = "generateGroup";
    public static final String GROUP_CODE = "codeGroup";
    private static final String GROUP_EXTERNALIZE = "externalizeGroup";
    private static final String GROUP_COMMENT = "commentGroup";
    private static final String GROUP_EDIT = "editGroup";
    private UniversalEditor fEditor;
    private IWorkbenchSite fSite;
    private String fGroupName = "group.reorganize";
    private List fRegisteredSelectionListeners;
    private static final String QUICK_MENU_ID = "org.eclipse.imp.source.quickMenu";
    private IHandlerActivation fQuickAccessHandlerActivation;
    private IHandlerService fHandlerService;
    private final ISelectionProvider fSelectionProvider;

    public GenerateActionGroup(UniversalEditor editor, String groupName) {
        this.fSite = editor.getSite();
        this.fSelectionProvider = this.fSite.getSelectionProvider();
        this.fEditor = editor;
        this.fGroupName = groupName;
    }

    public GenerateActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite(), null);
    }

    public GenerateActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite(), null);
    }

    public GenerateActionGroup(IWorkbenchSite site, ISelectionProvider selectionProvider) {
        this.fSite = site;
        this.fSelectionProvider = selectionProvider == null ? this.fSite.getSelectionProvider() : selectionProvider;
        ISelection selection = this.fSelectionProvider.getSelection();
    }

    private void registerSelectionListener(ISelectionProvider provider, ISelectionChangedListener listener) {
        if (this.fRegisteredSelectionListeners == null) {
            this.fRegisteredSelectionListeners = new ArrayList(20);
        }
        provider.addSelectionChangedListener(listener);
        this.fRegisteredSelectionListeners.add(listener);
    }

    public void editorStateChanged() {
        Assert.isTrue((boolean)this.isEditorOwner());
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        MenuManager subMenu = new MenuManager("Source", MENU_ID);
        subMenu.setActionDefinitionId(QUICK_MENU_ID);
        int added = 0;
        added = this.isEditorOwner() ? this.fillEditorSubMenu((IMenuManager)subMenu) : this.fillViewSubMenu((IMenuManager)subMenu);
        if (added > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
        }
    }

    private int fillEditorSubMenu(IMenuManager source) {
        int added = 0;
        source.add((IContributionItem)new Separator(GROUP_COMMENT));
        added += this.addEditorAction(source, "org.eclipse.imp.runtime.editor.toggleComment");
        added += this.addEditorAction(source, "AddBlockComment");
        added += this.addEditorAction(source, "RemoveBlockComment");
        source.add((IContributionItem)new Separator(GROUP_EDIT));
        source.add((IContributionItem)new Separator(GROUP_IMPORT));
        source.add((IContributionItem)new Separator(GROUP_GENERATE));
        source.add((IContributionItem)new Separator(GROUP_CODE));
        source.add((IContributionItem)new Separator(GROUP_EXTERNALIZE));
        return added += this.addEditorAction(source, "org.eclipse.imp.runtime.editor.indentSelection");
    }

    private int fillViewSubMenu(IMenuManager source) {
        int added = 0;
        source.add((IContributionItem)new Separator(GROUP_COMMENT));
        source.add((IContributionItem)new Separator(GROUP_EDIT));
        source.add((IContributionItem)new Separator(GROUP_IMPORT));
        source.add((IContributionItem)new Separator(GROUP_GENERATE));
        source.add((IContributionItem)new Separator(GROUP_CODE));
        source.add((IContributionItem)new Separator(GROUP_EXTERNALIZE));
        return added;
    }

    public void dispose() {
        if (this.fRegisteredSelectionListeners != null) {
            ISelectionProvider provider = this.fSelectionProvider;
            for (ISelectionChangedListener listener : this.fRegisteredSelectionListeners) {
                provider.removeSelectionChangedListener(listener);
            }
        }
        if (this.fQuickAccessHandlerActivation != null && this.fHandlerService != null) {
            this.fHandlerService.deactivateHandler(this.fQuickAccessHandlerActivation);
        }
        this.fEditor = null;
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBar) {
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private int addEditorAction(IMenuManager menu, String actionID) {
        if (this.fEditor == null) {
            return 0;
        }
        IAction action = this.fEditor.getAction(actionID);
        if (action == null) {
            return 0;
        }
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if (action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean isEditorOwner() {
        return this.fEditor != null;
    }
}

