/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.List;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.IAutoEditStrategy;
import org.eclipse.imp.services.ILanguageSyntaxProperties;
import org.eclipse.imp.services.base.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class StructuredSourceViewer
extends ProjectionViewer {
    public static final int SHOW_OUTLINE = 51;
    public static final int OPEN_STRUCTURE = 52;
    public static final int SHOW_HIERARCHY = 53;
    public static final int TOGGLE_COMMENT = 54;
    public static final int MARK_OCCURRENCES = 55;
    public static final int INDENT_SELECTION = 60;
    private IInformationPresenter fOutlinePresenter;
    private IInformationPresenter fStructurePresenter;
    private IInformationPresenter fHierarchyPresenter;
    private IAutoEditStrategy fAutoEditStrategy;
    private IParseController fParseController;

    public StructuredSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
    }

    public boolean canDoOperation(int operation) {
        switch (operation) {
            case 51: {
                return this.fOutlinePresenter != null;
            }
            case 52: {
                return this.fStructurePresenter != null;
            }
            case 53: {
                return this.fHierarchyPresenter != null;
            }
            case 54: {
                return true;
            }
            case 60: {
                return this.fAutoEditStrategy != null;
            }
        }
        return super.canDoOperation(operation);
    }

    public void doOperation(int operation) {
        if (this.getTextWidget() == null) {
            return;
        }
        switch (operation) {
            case 51: {
                if (this.fOutlinePresenter != null) {
                    this.fOutlinePresenter.showInformation();
                }
                return;
            }
            case 52: {
                if (this.fStructurePresenter != null) {
                    this.fStructurePresenter.showInformation();
                }
                return;
            }
            case 53: {
                if (this.fHierarchyPresenter != null) {
                    this.fHierarchyPresenter.showInformation();
                }
                return;
            }
            case 54: {
                this.doToggleComment();
                return;
            }
            case 60: {
                this.doIndentLines();
                return;
            }
        }
        super.doOperation(operation);
    }

    public void setParseController(IParseController parseController) {
        this.fParseController = parseController;
    }

    public void setFormatter(IContentFormatter formatter) {
        this.fContentFormatter = formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doToggleComment() {
        ILanguageSyntaxProperties syntaxProps = this.fParseController.getSyntaxProperties();
        if (syntaxProps == null) {
            return;
        }
        IDocument doc = this.getDocument();
        DocumentRewriteSession rewriteSession = null;
        Point p = this.getSelectedRange();
        String lineCommentPrefix = syntaxProps.getSingleLineCommentPrefix();
        if (doc instanceof IDocumentExtension4) {
            IDocumentExtension4 extension = (IDocumentExtension4)doc;
            rewriteSession = extension.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        }
        try {
            int selStart = p.x;
            int selLen = p.y;
            int selEnd = selStart + selLen;
            int startLine = doc.getLineOfOffset(selStart);
            int endLine = doc.getLineOfOffset(selEnd);
            if (selLen > 0 && this.lookingAtLineEnd(doc, selEnd)) {
                --endLine;
            }
            boolean linesAllHaveCommentPrefix = this.linesHaveCommentPrefix(doc, lineCommentPrefix, startLine, endLine);
            boolean useCommonLeadingSpace = true;
            int leadingSpaceToUse = useCommonLeadingSpace ? this.calculateLeadingSpace(doc, startLine, endLine) : 0;
            for (int line = startLine; line <= endLine; ++line) {
                int offset;
                int lineStart = doc.getLineOffset(line);
                int lineEnd = lineStart + doc.getLineLength(line) - 1;
                if (linesAllHaveCommentPrefix) {
                    for (offset = lineStart; Character.isWhitespace(doc.getChar(offset)) && offset < lineEnd; ++offset) {
                    }
                    doc.replace(offset, lineCommentPrefix.length(), "");
                    continue;
                }
                offset = lineStart + leadingSpaceToUse;
                doc.replace(offset, 0, lineCommentPrefix + " ");
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        finally {
            if (doc instanceof IDocumentExtension4) {
                IDocumentExtension4 extension = (IDocumentExtension4)doc;
                extension.stopRewriteSession(rewriteSession);
            }
            this.restoreSelection();
        }
    }

    private int calculateLeadingSpace(IDocument doc, int startLine, int endLine) {
        try {
            int result = Integer.MAX_VALUE;
            for (int line = startLine; line <= endLine; ++line) {
                int offset;
                int lineStart = doc.getLineOffset(line);
                int lineEnd = lineStart + doc.getLineLength(line) - 1;
                for (offset = lineStart; Character.isWhitespace(doc.getChar(offset)) && offset < lineEnd; ++offset) {
                }
                int leadingSpaces = offset - lineStart;
                result = Math.min(result, leadingSpaces);
            }
            return result;
        }
        catch (BadLocationException e) {
            return 0;
        }
    }

    private boolean linesHaveCommentPrefix(IDocument doc, String lineCommentPrefix, int startLine, int endLine) {
        try {
            int docLen = doc.getLength();
            for (int line = startLine; line <= endLine; ++line) {
                int offset;
                int lineStart = doc.getLineOffset(line);
                int lineEnd = lineStart + doc.getLineLength(line) - 1;
                for (offset = lineStart; Character.isWhitespace(doc.getChar(offset)) && offset < lineEnd; ++offset) {
                }
                if (docLen - offset > lineCommentPrefix.length() && doc.get(offset, lineCommentPrefix.length()).equals(lineCommentPrefix)) continue;
                return false;
            }
        }
        catch (BadLocationException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIndentLines() {
        IDocument doc = this.getDocument();
        DocumentRewriteSession rewriteSession = null;
        Point p = this.getSelectedRange();
        if (doc instanceof IDocumentExtension4) {
            IDocumentExtension4 extension = (IDocumentExtension4)doc;
            rewriteSession = extension.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        }
        try {
            int selStart = p.x;
            int selLen = p.y;
            int selEnd = selStart + selLen;
            int startLine = doc.getLineOfOffset(selStart);
            int endLine = doc.getLineOfOffset(selEnd);
            if (selLen > 0 && this.lookingAtLineEnd(doc, selEnd)) {
                --endLine;
            }
            for (int line = startLine; line <= endLine; ++line) {
                int lineStartOffset = doc.getLineOffset(line);
                DocumentCommand cmd = new DocumentCommand(){};
                cmd.offset = lineStartOffset;
                cmd.length = 0;
                cmd.text = Character.toString('\t');
                cmd.doit = true;
                cmd.shiftsCaret = false;
                this.fAutoEditStrategy.customizeDocumentCommand(doc, cmd);
                doc.replace(cmd.offset, cmd.length, cmd.text);
            }
        }
        catch (BadLocationException e) {
            RuntimePlugin.getInstance().logException("Indent Selection command failed", e);
        }
        finally {
            if (doc instanceof IDocumentExtension4) {
                IDocumentExtension4 extension = (IDocumentExtension4)doc;
                extension.stopRewriteSession(rewriteSession);
            }
            this.restoreSelection();
        }
    }

    private boolean lookingAtLineEnd(IDocument doc, int pos) {
        String[] legalLineTerms = doc.getLegalLineDelimiters();
        try {
            for (String lineTerm : legalLineTerms) {
                int len = lineTerm.length();
                if (pos <= len || !doc.get(pos - len, len).equals(lineTerm)) continue;
                return true;
            }
        }
        catch (BadLocationException e) {
            RuntimePlugin.getInstance().logException("Error examining document for line termination", e);
        }
        return false;
    }

    public void configure(SourceViewerConfiguration configuration) {
        StyledText textWidget = this.getTextWidget();
        if (textWidget != null && !textWidget.isDisposed()) {
            Color backgroundColor;
            Color foregroundColor = textWidget.getForeground();
            if (foregroundColor != null && foregroundColor.isDisposed()) {
                textWidget.setForeground(null);
            }
            if ((backgroundColor = textWidget.getBackground()) != null && backgroundColor.isDisposed()) {
                textWidget.setBackground(null);
            }
        }
        super.configure(configuration);
        if (configuration instanceof UniversalEditor.StructuredSourceViewerConfiguration) {
            List strategies;
            UniversalEditor.StructuredSourceViewerConfiguration sSVConfiguration = (UniversalEditor.StructuredSourceViewerConfiguration)configuration;
            this.fOutlinePresenter = sSVConfiguration.getOutlinePresenter((ISourceViewer)this);
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.install((ITextViewer)this);
            }
            this.fStructurePresenter = sSVConfiguration.getOutlinePresenter((ISourceViewer)this);
            if (this.fStructurePresenter != null) {
                this.fStructurePresenter.install((ITextViewer)this);
            }
            this.fHierarchyPresenter = sSVConfiguration.getHierarchyPresenter((ISourceViewer)this, true);
            if (this.fHierarchyPresenter != null) {
                this.fHierarchyPresenter.install((ITextViewer)this);
            }
            if (this.fAutoIndentStrategies != null && (strategies = (List)this.fAutoIndentStrategies.get("__dftl_partition_content_type")) != null && strategies.size() > 0) {
                this.fAutoEditStrategy = strategies.get(0) instanceof IAutoEditStrategy ? (IAutoEditStrategy)strategies.get(0) : new DefaultAutoIndentStrategy();
            }
        }
    }

    public void unconfigure() {
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        if (this.fStructurePresenter != null) {
            this.fStructurePresenter.uninstall();
            this.fStructurePresenter = null;
        }
        if (this.fHierarchyPresenter != null) {
            this.fHierarchyPresenter.uninstall();
            this.fHierarchyPresenter = null;
        }
        super.unconfigure();
    }
}

