/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.compiler.codegen;

import java.util.List;
import org.eclipse.imp.prefspecs.compiler.DynamicEnumValueSource;
import org.eclipse.imp.prefspecs.compiler.IEnumValueSource;
import org.eclipse.imp.prefspecs.compiler.LiteralEnumValueSource;
import org.eclipse.imp.prefspecs.compiler.codegen.FieldCodeGenerator;
import org.eclipse.imp.prefspecs.compiler.model.FieldInfo;

public abstract class EnumFieldCodeGenerator
extends FieldCodeGenerator {
    public EnumFieldCodeGenerator(FieldInfo fieldInfo) {
        super(fieldInfo);
    }

    protected String getEnumDefaultValueExpr(IEnumValueSource vs) {
        if (vs instanceof LiteralEnumValueSource) {
            LiteralEnumValueSource levs = (LiteralEnumValueSource)vs;
            return "\"" + levs.getDefaultKey() + "\"";
        }
        if (vs instanceof DynamicEnumValueSource) {
            DynamicEnumValueSource devs = (DynamicEnumValueSource)vs;
            return "new " + devs.getQualClassName() + "().getDefaultLabel()";
        }
        return "";
    }

    public String getValueStringsExpr(IEnumValueSource vs) {
        if (vs instanceof LiteralEnumValueSource) {
            LiteralEnumValueSource levs = (LiteralEnumValueSource)vs;
            List<String> labels = levs.getValues();
            return this.toStringArrayLiteral(labels);
        }
        if (vs instanceof DynamicEnumValueSource) {
            return "evp.getValues()";
        }
        throw new IllegalStateException("Unexpected type of enum value source: " + vs.getClass().getCanonicalName());
    }

    public String getLabelStringsExpr(IEnumValueSource vs) {
        StringBuilder sb = new StringBuilder();
        if (vs instanceof LiteralEnumValueSource) {
            LiteralEnumValueSource levs = (LiteralEnumValueSource)vs;
            List<String> values = levs.getValues();
            List<String> labels = levs.getLabels();
            sb.append("new String[] { ");
            for (int i = 0; i < labels.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                if (labels.get(i) != null) {
                    this.appendWithQuotes(labels.get(i), sb);
                    continue;
                }
                this.appendWithQuotes(this.createLabelFor(values.get(i)), sb);
            }
            sb.append(" }");
        } else if (vs instanceof DynamicEnumValueSource) {
            sb.append("evp.getLabels()");
        }
        return sb.toString();
    }
}

