/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.compiler.model;

import org.eclipse.imp.prefspecs.compiler.codegen.FieldCodeGenerator;
import org.eclipse.imp.prefspecs.compiler.codegen.IntFieldCodeGenerator;
import org.eclipse.imp.prefspecs.compiler.model.FieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.IPageMemberContainer;
import org.eclipse.ui.console.MessageConsoleStream;

public class IntFieldInfo
extends FieldInfo {
    protected int defaultValue = 0;
    protected boolean hasRangeSpec = false;
    protected int rangeHigh = Integer.MAX_VALUE;
    protected int rangeLow = Integer.MIN_VALUE;

    public IntFieldInfo(IPageMemberContainer parentPage, String name) {
        this(parentPage, name, 0);
    }

    public IntFieldInfo(IPageMemberContainer parentPage, String name, int defValue) {
        super(parentPage, name);
        this.defaultValue = defValue;
    }

    public FieldCodeGenerator getCodeGenerator() {
        return new IntFieldCodeGenerator(this);
    }

    public void setDefaultValue(int i) {
        if (i < this.getRangeLow() || i > this.getRangeHigh()) {
            throw new IllegalArgumentException("IntFieldInfo.setDefaultValue(int): attempt to set default value = " + i + " outside of range = " + this.getRangeLow() + ".." + this.getRangeHigh());
        }
        this.defaultValue = i;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasRangeSpec() {
        return this.hasRangeSpec;
    }

    public void setRange(int low, int high) {
        if (high < low) {
            throw new IllegalArgumentException("IntFieldInfo.setRange(int,int): range upper bound = " + high + " is less than lower bound = " + low);
        }
        this.hasRangeSpec = true;
        this.rangeLow = low;
        this.rangeHigh = high;
    }

    public int getRangeHigh() {
        return this.rangeHigh;
    }

    public int getRangeLow() {
        return this.rangeLow;
    }

    public void dump(String prefix, MessageConsoleStream out) {
        super.dump(prefix, out);
        String indent = prefix + "  ";
        out.println(indent + "defaultValue    = " + this.getDefaultValue());
    }
}

