/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.treeModelBuilder;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.imp.editor.ModelTreeNode;
import org.eclipse.imp.prefspecs.PrefspecsPlugin;
import org.eclipse.imp.prefspecs.parser.Ast.ASTNode;
import org.eclipse.imp.prefspecs.parser.Ast.booleanFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.colorFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.comboFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.conditionalSpec__identifier_AGAINST_identifier;
import org.eclipse.imp.prefspecs.parser.Ast.conditionalSpec__identifier_WITH_identifier;
import org.eclipse.imp.prefspecs.parser.Ast.conditionalsSpec;
import org.eclipse.imp.prefspecs.parser.Ast.configurationTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.defaultTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.dirListFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.directoryFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.doubleFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.fieldsSpec;
import org.eclipse.imp.prefspecs.parser.Ast.fileFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.fontFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.instanceTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.intFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.pageSpec;
import org.eclipse.imp.prefspecs.parser.Ast.projectTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.radioFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.stringFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.tabsSpec;
import org.eclipse.imp.services.ILabelProvider;
import org.eclipse.imp.utils.MarkerUtils;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class PrefspecsLabelProvider
implements ILabelProvider {
    private Set<ILabelProviderListener> fListeners = new HashSet<ILabelProviderListener>();
    private static ImageRegistry sImageRegistry = PrefspecsPlugin.getInstance().getImageRegistry();
    private static Image DEFAULT_IMAGE = sImageRegistry.get("prefspecs_default_image");
    private static Image FILE_IMAGE = sImageRegistry.get("prefspecs_file");
    private static Image FILE_WITH_WARNING_IMAGE = sImageRegistry.get("prefspecs_file_warning");
    private static Image FILE_WITH_ERROR_IMAGE = sImageRegistry.get("prefspecs_file_error");
    private static Image BOOLEAN_FIELD_IMAGE = sImageRegistry.get("boolean_field");
    private static Image COLOR_FIELD_IMAGE = sImageRegistry.get("color_field");
    private static Image COMBO_FIELD_IMAGE = sImageRegistry.get("combo_field");
    private static Image DIRECTORY_FIELD_IMAGE = sImageRegistry.get("directory_field");
    private static Image DIRLIST_FIELD_IMAGE = sImageRegistry.get("dirlist_field");
    private static Image DOUBLE_FIELD_IMAGE = sImageRegistry.get("double_field");
    private static Image FILE_FIELD_IMAGE = sImageRegistry.get("file_field");
    private static Image FONT_FIELD_IMAGE = sImageRegistry.get("font_field");
    private static Image INT_FIELD_IMAGE = sImageRegistry.get("int_field");
    private static Image RADIO_FIELD_IMAGE = sImageRegistry.get("radio_field");
    private static Image STRING_FIELD_IMAGE = sImageRegistry.get("string_field");

    public Image getImage(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            int sev = MarkerUtils.getMaxProblemMarkerSeverity((IResource)file, (int)1);
            switch (sev) {
                case 2: {
                    return FILE_WITH_ERROR_IMAGE;
                }
                case 1: {
                    return FILE_WITH_WARNING_IMAGE;
                }
            }
            return FILE_IMAGE;
        }
        ASTNode n = element instanceof ModelTreeNode ? (ASTNode)((ModelTreeNode)element).getASTNode() : (ASTNode)element;
        return PrefspecsLabelProvider.getImageFor(n);
    }

    public static Image getImageFor(ASTNode n) {
        if (n instanceof booleanFieldSpec) {
            return BOOLEAN_FIELD_IMAGE;
        }
        if (n instanceof colorFieldSpec) {
            return COLOR_FIELD_IMAGE;
        }
        if (n instanceof comboFieldSpec) {
            return COMBO_FIELD_IMAGE;
        }
        if (n instanceof directoryFieldSpec) {
            return DIRECTORY_FIELD_IMAGE;
        }
        if (n instanceof dirListFieldSpec) {
            return DIRLIST_FIELD_IMAGE;
        }
        if (n instanceof doubleFieldSpec) {
            return DOUBLE_FIELD_IMAGE;
        }
        if (n instanceof fontFieldSpec) {
            return FONT_FIELD_IMAGE;
        }
        if (n instanceof fileFieldSpec) {
            return FILE_FIELD_IMAGE;
        }
        if (n instanceof intFieldSpec) {
            return INT_FIELD_IMAGE;
        }
        if (n instanceof radioFieldSpec) {
            return RADIO_FIELD_IMAGE;
        }
        if (n instanceof stringFieldSpec) {
            return STRING_FIELD_IMAGE;
        }
        return DEFAULT_IMAGE;
    }

    public String getText(Object element) {
        ASTNode n = element instanceof ModelTreeNode ? (ASTNode)((ModelTreeNode)element).getASTNode() : (ASTNode)element;
        return PrefspecsLabelProvider.getLabelFor(n);
    }

    public static String getLabelFor(ASTNode n) {
        if (n instanceof pageSpec) {
            return "Page " + ((pageSpec)n).getpageName().toString();
        }
        if (n instanceof tabsSpec) {
            return "Tabs";
        }
        if (n instanceof defaultTabSpec) {
            return "Default tab";
        }
        if (n instanceof configurationTabSpec) {
            return "Configuration tab";
        }
        if (n instanceof instanceTabSpec) {
            return "Instance tab";
        }
        if (n instanceof projectTabSpec) {
            return "Project tab";
        }
        if (n instanceof fieldsSpec) {
            return "Fields";
        }
        if (n instanceof booleanFieldSpec) {
            return ((booleanFieldSpec)n).getidentifier().toString();
        }
        if (n instanceof colorFieldSpec) {
            return ((colorFieldSpec)n).getidentifier().toString();
        }
        if (n instanceof comboFieldSpec) {
            return ((comboFieldSpec)n).getidentifier().toString();
        }
        if (n instanceof directoryFieldSpec) {
            return ((directoryFieldSpec)n).getidentifier().toString();
        }
        if (n instanceof dirListFieldSpec) {
            return ((dirListFieldSpec)n).getidentifier().toString();
        }
        if (n instanceof doubleFieldSpec) {
            return ((doubleFieldSpec)n).getidentifier().toString();
        }
        if (n instanceof fileFieldSpec) {
            return ((fileFieldSpec)n).getidentifier().toString();
        }
        if (n instanceof fontFieldSpec) {
            return ((fontFieldSpec)n).getidentifier().toString();
        }
        if (n instanceof intFieldSpec) {
            return ((intFieldSpec)n).getidentifier().toString();
        }
        if (n instanceof radioFieldSpec) {
            return ((radioFieldSpec)n).getidentifier().toString();
        }
        if (n instanceof stringFieldSpec) {
            return ((stringFieldSpec)n).getidentifier().toString();
        }
        if (n instanceof conditionalsSpec) {
            return "Conditionals";
        }
        if (n instanceof conditionalSpec__identifier_WITH_identifier) {
            return ((conditionalSpec__identifier_WITH_identifier)n).getidentifier().toString();
        }
        if (n instanceof conditionalSpec__identifier_AGAINST_identifier) {
            return ((conditionalSpec__identifier_AGAINST_identifier)n).getidentifier().toString();
        }
        return "<???>";
    }

    public void addListener(ILabelProviderListener listener) {
        this.fListeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.fListeners.remove(listener);
    }
}

