/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.type.constraints.fastrep;

import org.eclipse.imp.analysis.type.constraints.bindings.ITypeBinding;
import org.eclipse.imp.analysis.type.constraints.fastrep.CaptureType;
import org.eclipse.imp.analysis.type.constraints.fastrep.FastTypeAdapter;
import org.eclipse.imp.analysis.type.constraints.fastrep.GenericType;
import org.eclipse.imp.analysis.type.constraints.fastrep.HierarchyType;
import org.eclipse.imp.analysis.type.constraints.fastrep.ParameterizedType;
import org.eclipse.imp.analysis.type.constraints.fastrep.StandardType;
import org.eclipse.imp.analysis.type.constraints.fastrep.TType;
import org.eclipse.imp.analysis.type.constraints.fastrep.TypeEnvironment;
import org.eclipse.imp.analysis.type.constraints.fastrep.WildcardType;
import org.eclipse.imp.core.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawType<T>
extends HierarchyType<T> {
    private GenericType fTypeDeclaration;

    protected RawType(TypeEnvironment environment) {
        super(environment);
    }

    @Override
    protected void initialize(ITypeBinding binding, T typeRep) {
        Assert.isTrue((boolean)binding.isRawType());
        super.initialize(binding, typeRep);
        TypeEnvironment environment = this.getEnvironment();
        this.fTypeDeclaration = (GenericType)environment.create(binding.getTypeDeclaration());
    }

    @Override
    public int getKind() {
        return 8;
    }

    @Override
    public boolean doEquals(TType type) {
        return this.getTypeRepresentation().equals(((RawType)type).getTypeRepresentation());
    }

    public int hashCode() {
        return this.getTypeRepresentation().hashCode();
    }

    @Override
    public TType getTypeDeclaration() {
        return this.fTypeDeclaration;
    }

    @Override
    public TType getErasure() {
        return this.fTypeDeclaration;
    }

    GenericType getGenericType() {
        return this.fTypeDeclaration;
    }

    @Override
    protected boolean doCanAssignTo(TType lhs) {
        int targetType = lhs.getKind();
        switch (targetType) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return this.canAssignToStandardType((StandardType)lhs);
            }
            case 6: {
                return false;
            }
            case 7: {
                return this.isSubType((ParameterizedType)lhs);
            }
            case 8: {
                return this.isSubType((HierarchyType)lhs);
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)lhs).checkAssignmentBound(this);
            }
            case 12: {
                return false;
            }
            case 13: {
                return ((CaptureType)lhs).checkLowerBound(this);
            }
        }
        return false;
    }

    @Override
    protected boolean isTypeEquivalentTo(TType other) {
        int otherElementType = other.getKind();
        if (otherElementType == 7 || otherElementType == 6) {
            return this.getErasure().isTypeEquivalentTo(other.getErasure());
        }
        return super.isTypeEquivalentTo(other);
    }

    @Override
    public String getName() {
        return FastTypeAdapter.getInstance().getShortName(this.getTypeRepresentation());
    }

    @Override
    protected String getPlainPrettySignature() {
        return FastTypeAdapter.getInstance().getFullyQualifiedName(this.getTypeRepresentation());
    }
}

