/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.builder;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.runtime.RuntimePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerCreator
implements IMessageHandler {
    protected IFile file;
    protected String problemType;

    public MarkerCreator(IFile file) {
        this(file, "org.eclipse.core.resources.problemmarker");
    }

    public MarkerCreator(IFile file, String problemType) {
        this.file = file;
        this.problemType = problemType;
    }

    @Override
    public void clearMessages() {
    }

    void createMarker(String msg, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine, Map<String, Object> attributes) {
        String[] attributeNames = new String[]{"lineNumber", "charStart", "charEnd", "message", "priority", "severity"};
        Object[] values = new Object[]{startLine, startOffset, endOffset, msg, 2, 2};
        try {
            IMarker m = this.file.createMarker(this.problemType);
            m.setAttributes(attributeNames, values);
            if (attributes != null) {
                for (String key : attributes.keySet()) {
                    m.setAttribute(key, attributes.get(key));
                }
            }
        }
        catch (CoreException e) {
            RuntimePlugin.getInstance().logException("MarkerCreator.handleMessage(): CoreException caught while trying to create marker", e);
        }
        catch (Exception e) {
            RuntimePlugin.getInstance().logException("MarkerCreator.handleMessage(): Exception caught while trying to create marker", e);
        }
    }

    @Override
    public void handleSimpleMessage(String msg, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine, Map<String, Object> attributes) {
        this.createMarker(msg, startOffset, endOffset, startCol, endCol, startLine, endLine, attributes);
    }

    @Override
    public void handleSimpleMessage(String msg, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine) {
        this.createMarker(msg, startOffset, endOffset, startCol, endCol, startLine, endLine, null);
    }

    @Override
    public void endMessageGroup() {
    }

    @Override
    public void startMessageGroup(String groupName) {
    }

    @Override
    public void endMessages() {
    }
}

