/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.StructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureRootNode;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.editor.ModelTreeNode;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.services.ICompareNodeIdentifier;
import org.eclipse.imp.services.ILabelProvider;
import org.eclipse.imp.services.base.TreeModelBuilderBase;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;

public class ModelStructureCreator
extends StructureCreator {
    private Language fLanguage;
    private ICompareNodeIdentifier fCompareNodeIdentifier;
    private ILabelProvider fLabelProvider;
    private ISourcePositionLocator fSrcPositionLocator;

    public String getName() {
        return "Structural Comparison";
    }

    protected IStructureComparator createStructureComparator(Object input, IDocument document, ISharedDocumentAdapter sharedDocumentAdapter, IProgressMonitor monitor) throws CoreException {
        this.determineLanguage(input, document);
        if (this.fLanguage != null) {
            Object compareRoot;
            ServiceFactory svcFactory = ServiceFactory.getInstance();
            IParseController pc = svcFactory.getParseController(this.fLanguage);
            this.fCompareNodeIdentifier = svcFactory.getCompareNodeIdentifier(this.fLanguage);
            this.fLabelProvider = svcFactory.getLabelProvider(this.fLanguage);
            TreeModelBuilderBase builder = svcFactory.getTreeModelBuilder(this.fLanguage);
            this.fSrcPositionLocator = pc.getSourcePositionLocator();
            pc.initialize(null, null, null);
            Object astRoot = pc.parse(document, monitor);
            if (astRoot != null) {
                ModelTreeNode modelRoot = builder.buildTree(astRoot);
                compareRoot = this.buildCompareTree(modelRoot, null, document);
            } else {
                compareRoot = new StructureRootNode(document, input, (StructureCreator)this, sharedDocumentAdapter);
            }
            return compareRoot;
        }
        return null;
    }

    private TreeCompareNode buildCompareTree(ModelTreeNode treeNode, DocumentRangeNode parent, IDocument document) {
        TreeCompareNode compareNode = new TreeCompareNode(parent, treeNode, document);
        for (ModelTreeNode treeChild : treeNode.getChildren()) {
            compareNode.addChild(this.buildCompareTree(treeChild, compareNode, document));
        }
        return compareNode;
    }

    private void determineLanguage(Object element, IDocument document) {
        IResourceProvider resProvider;
        if (element instanceof IAdaptable && (resProvider = (IResourceProvider)((IAdaptable)element).getAdapter(IResourceProvider.class)) != null) {
            IResource res = resProvider.getResource();
            this.fLanguage = LanguageRegistry.findLanguage(res.getFullPath(), document);
        }
    }

    public String getContents(Object node, boolean ignoreWhitespace) {
        if (node instanceof IStreamContentAccessor) {
            IStreamContentAccessor sca = (IStreamContentAccessor)node;
            try {
                return ModelStructureCreator.readString(sca);
            }
            catch (CoreException ex) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readString(InputStream is, String encoding) {
        if (is == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            StringBuffer buffer = new StringBuffer();
            char[] part = new char[2048];
            int read = 0;
            reader = new BufferedReader(new InputStreamReader(is, encoding));
            while ((read = reader.read(part)) != -1) {
                buffer.append(part, 0, read);
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException ex) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
        return null;
    }

    public static String readString(IStreamContentAccessor sa) throws CoreException {
        InputStream is = sa.getContents();
        if (is != null) {
            String encoding = null;
            if (sa instanceof IEncodedStreamContentAccessor) {
                try {
                    encoding = ((IEncodedStreamContentAccessor)sa).getCharset();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            return ModelStructureCreator.readString(is, encoding);
        }
        return null;
    }

    public class TreeCompareNode
    extends DocumentRangeNode
    implements ITypedElement {
        private final Object fASTNode;

        public TreeCompareNode(ModelTreeNode treeNode, IDocument document) {
            this(null, treeNode, document);
        }

        public TreeCompareNode(DocumentRangeNode parent, ModelTreeNode treeNode, IDocument document) {
            super(parent, ModelStructureCreator.this.fCompareNodeIdentifier.getTypeCode(treeNode.getASTNode()), ModelStructureCreator.this.fCompareNodeIdentifier.getID(treeNode.getASTNode()), document, ModelStructureCreator.this.fSrcPositionLocator.getStartOffset(treeNode.getASTNode()), ModelStructureCreator.this.fSrcPositionLocator.getLength(treeNode.getASTNode()));
            this.fASTNode = treeNode.getASTNode();
        }

        public String toString() {
            return this.getTypeCode() + ":" + this.getId();
        }

        public Image getImage() {
            return ModelStructureCreator.this.fLabelProvider != null ? ModelStructureCreator.this.fLabelProvider.getImage(this.fASTNode) : null;
        }

        public String getName() {
            return ModelStructureCreator.this.fLabelProvider != null ? ModelStructureCreator.this.fLabelProvider.getText(this.fASTNode) : this.toString();
        }

        public String getType() {
            return "?type?";
        }
    }
}

