/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.ILanguageSyntaxProperties;
import org.eclipse.imp.services.base.LanguageSyntaxPropertiesBase;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;

public class DoubleClickStrategy
extends DefaultTextDoubleClickStrategy {
    private final IParseController fParseController;
    protected final IdentifierDetector fWordDetector;
    protected final ILanguageSyntaxProperties fSyntaxProps;
    protected final DefaultCharacterPairMatcher fPairMatcher;

    public DoubleClickStrategy(IParseController pc) {
        this.fParseController = pc;
        this.fWordDetector = new IdentifierDetector();
        StringBuilder sb = new StringBuilder();
        ILanguageSyntaxProperties props = pc.getSyntaxProperties();
        if (props != null) {
            this.fSyntaxProps = props;
            String[][] fences = this.fSyntaxProps.getFences();
            if (fences != null) {
                for (int i = 0; i < fences.length; ++i) {
                    sb.append(fences[i][0]);
                    sb.append(fences[i][1]);
                }
            }
        } else {
            this.fSyntaxProps = new LanguageSyntaxPropertiesBase(){

                public String getSingleLineCommentPrefix() {
                    return null;
                }

                public String getBlockCommentStart() {
                    return null;
                }

                public String getBlockCommentEnd() {
                    return null;
                }

                public String getBlockCommentContinuation() {
                    return null;
                }
            };
        }
        this.fPairMatcher = new DefaultCharacterPairMatcher(sb.toString().toCharArray());
    }

    protected IRegion findWord(IDocument document, int anchor) {
        return this.fWordDetector.getWordSelection(document, anchor);
    }

    protected IRegion findExtendedDoubleClickSelection(IDocument document, int offset) {
        Region seed = new Region(offset, 1);
        IRegion extendedRegion = this.fSyntaxProps.getDoubleClickRegion(offset, this.fParseController);
        if (extendedRegion != null && !extendedRegion.equals(seed)) {
            return extendedRegion;
        }
        IRegion match = this.fPairMatcher.match(document, offset);
        if (match != null && match.getLength() >= 2) {
            return new Region(match.getOffset() + 1, match.getLength() - 2);
        }
        return this.findWord(document, offset);
    }

    private final class IdentifierDetector {
        private static final int UNKNOWN = -1;
        private static final int WS = 0;
        private static final int ID = 1;
        private static final int IDS = 2;
        private static final int FORWARD = 0;
        private static final int BACKWARD = 1;
        private int fState;
        private int fAnchorState;
        private int fDirection;
        private int fStart;
        private int fEnd;

        private IdentifierDetector() {
        }

        private void setAnchor(int anchor) {
            this.fState = -1;
            this.fAnchorState = -1;
            this.fDirection = -1;
            this.fStart = anchor;
            this.fEnd = anchor - 1;
        }

        private boolean isIdentifierStart(char c) {
            return DoubleClickStrategy.this.fSyntaxProps.isIdentifierStart(c);
        }

        private boolean isIdentifierPart(char c) {
            return DoubleClickStrategy.this.fSyntaxProps.isIdentifierPart(c);
        }

        private boolean isWhitespace(char c) {
            return DoubleClickStrategy.this.fSyntaxProps.isWhitespace(c);
        }

        private boolean backward(char c, int offset) {
            this.checkDirection(1);
            switch (this.fState) {
                case 2: {
                    if (this.isWhitespace(c)) {
                        this.fState = 0;
                        return true;
                    }
                    if (this.isIdentifierStart(c)) {
                        this.fStart = offset;
                        this.fState = 2;
                        return true;
                    }
                    if (this.isIdentifierPart(c)) {
                        this.fStart = offset;
                        this.fState = 1;
                        return true;
                    }
                    return false;
                }
                case 1: {
                    if (this.isIdentifierStart(c)) {
                        this.fStart = offset;
                        this.fState = 2;
                        return true;
                    }
                    if (this.isIdentifierPart(c)) {
                        this.fStart = offset;
                        this.fState = 1;
                        return true;
                    }
                    return false;
                }
                case 0: {
                    return this.isWhitespace(c);
                }
            }
            return false;
        }

        private boolean forward(char c, int offset) {
            this.checkDirection(0);
            switch (this.fState) {
                case 0: {
                    if (this.isWhitespace(c)) {
                        this.fState = 0;
                        return true;
                    }
                    if (this.isIdentifierStart(c)) {
                        this.fEnd = offset;
                        this.fState = 2;
                        return true;
                    }
                    return false;
                }
                case 1: 
                case 2: {
                    if (this.isIdentifierStart(c)) {
                        this.fEnd = offset;
                        this.fState = 2;
                        return true;
                    }
                    if (this.isIdentifierPart(c)) {
                        this.fEnd = offset;
                        this.fState = 1;
                        return true;
                    }
                    return false;
                }
                case -1: {
                    if (this.isIdentifierStart(c)) {
                        this.fEnd = offset;
                        this.fAnchorState = this.fState = 2;
                        return true;
                    }
                    if (this.isIdentifierPart(c)) {
                        this.fEnd = offset;
                        this.fAnchorState = this.fState = 1;
                        return true;
                    }
                    if (this.isWhitespace(c)) {
                        this.fAnchorState = this.fState = 0;
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        private void checkDirection(int direction) {
            if (this.fDirection == direction) {
                return;
            }
            if (direction == 0) {
                this.fState = this.fStart <= this.fEnd ? this.fAnchorState : -1;
            } else if (direction == 1) {
                this.fState = this.fEnd >= this.fStart ? this.fAnchorState : -1;
            }
            this.fDirection = direction;
        }

        public IRegion getWordSelection(IDocument document, int anchor) {
            try {
                char c;
                int offset;
                boolean min = false;
                int max = document.getLength();
                this.setAnchor(anchor);
                for (offset = anchor; offset < max && this.forward(c = document.getChar(offset), offset); ++offset) {
                }
                for (offset = anchor; offset >= 0 && this.backward(c = document.getChar(offset), offset); --offset) {
                }
                return new Region(this.fStart, this.fEnd - this.fStart + 1);
            }
            catch (BadLocationException x) {
                return new Region(anchor, 0);
            }
        }
    }
}

