/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.imp.actions.OpenAction;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenWithMenu;

public class OpenEditorActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private boolean fIsEditorOwner;
    private OpenAction fOpen;
    private ISelectionProvider fSelectionProvider;

    public OpenEditorActionGroup(IViewPart part) {
        this(part.getSite(), null);
    }

    public OpenEditorActionGroup(IWorkbenchPartSite site, ISelectionProvider specialSelectionProvider) {
        this.fSite = site;
        this.fOpen = new OpenAction(this.fSite);
        this.fOpen.setActionDefinitionId("org.eclipse.imp.runtime.editor.openDeclaration");
        this.fSelectionProvider = specialSelectionProvider == null ? this.fSite.getSelectionProvider() : specialSelectionProvider;
        this.initialize();
        if (specialSelectionProvider != null) {
            this.fOpen.setSpecialSelectionProvider(specialSelectionProvider);
        }
    }

    public OpenEditorActionGroup(UniversalEditor editor) {
        this.fIsEditorOwner = true;
        this.fOpen = new OpenAction(editor);
        this.fOpen.setActionDefinitionId("org.eclipse.imp.runtime.editor.openDeclaration");
        editor.setAction("org.eclipse.imp.runtime.editor.openDeclaration", (IAction)this.fOpen);
        this.fSite = editor.getEditorSite();
        this.fSelectionProvider = this.fSite.getSelectionProvider();
        this.initialize();
    }

    public IAction getOpenAction() {
        return this.fOpen;
    }

    private void initialize() {
        ISelection selection = this.fSelectionProvider.getSelection();
        this.fOpen.update(selection);
        this.fSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fOpen);
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.appendToGroup(menu, (IAction)this.fOpen);
        if (!this.fIsEditorOwner) {
            this.addOpenWithMenu(menu);
        }
    }

    public void dispose() {
        this.fSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpen);
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("org.eclipse.imp.runtime.actions.Open", (IAction)this.fOpen);
    }

    private void appendToGroup(IMenuManager menu, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup("group.open", action);
        }
    }

    private void addOpenWithMenu(IMenuManager menu) {
        ISelection selection = this.getContext().getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() != 1) {
            return;
        }
        Object o = ss.getFirstElement();
        if (!(o instanceof IAdaptable)) {
            return;
        }
        IAdaptable element = (IAdaptable)o;
        Object resource = element.getAdapter(IResource.class);
        if (!(resource instanceof IFile)) {
            return;
        }
        MenuManager submenu = new MenuManager("Open Wit&h");
        submenu.add((IContributionItem)new OpenWithMenu(this.fSite.getPage(), (IAdaptable)((IFile)resource)));
        menu.appendToGroup("group.open", (IContributionItem)submenu);
    }
}

