/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.imp.editor.DoubleClickStrategy;
import org.eclipse.imp.editor.LanguageServiceManager;
import org.eclipse.imp.editor.OutlineInformationControl;
import org.eclipse.imp.editor.ServiceControllerManager;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.editor.internal.QuickFixController;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferenceCache;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.IDocumentationProvider;
import org.eclipse.imp.services.base.DefaultAnnotationHover;
import org.eclipse.imp.services.base.TreeModelBuilderBase;
import org.eclipse.imp.ui.textPresentation.HTMLTextPresenter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class StructuredSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    protected final UniversalEditor fEditor;
    private ServiceControllerManager fServiceControllerManager;
    private LanguageServiceManager fLanguageServiceManager;
    private IPreferencesService fLangSpecificPrefs;
    private InformationPresenter fInfoPresenter;
    private IInformationProvider fOutlineElementProvider = new OutlineInformationProvider();

    public StructuredSourceViewerConfiguration(IPreferenceStore prefStore, UniversalEditor editor) {
        super(prefStore);
        this.fEditor = editor;
    }

    protected ServiceControllerManager getServiceControllerManager() {
        if (this.fServiceControllerManager == null) {
            this.fServiceControllerManager = this.fEditor.fServiceControllerManager;
        }
        return this.fServiceControllerManager;
    }

    protected LanguageServiceManager getLanguageServiceManager() {
        if (this.fLanguageServiceManager == null) {
            this.fLanguageServiceManager = this.fEditor.getLanguageServiceManager();
        }
        return this.fLanguageServiceManager;
    }

    protected IPreferencesService getLangSpecificPrefs() {
        if (this.fLangSpecificPrefs == null) {
            this.fLangSpecificPrefs = this.fEditor.getLanguageSpecificPreferences();
        }
        return this.fLangSpecificPrefs;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        boolean langSpecificSetting = this.getLangSpecificPrefs() != null && this.getLangSpecificPrefs().isDefined("tabWidth");
        return langSpecificSetting ? this.getLangSpecificPrefs().getIntPreference("tabWidth") : PreferenceCache.tabWidth;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.getServiceControllerManager() == null || this.getLanguageServiceManager().getTokenColorer() == null) {
            return super.getPresentationReconciler(sourceViewer);
        }
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setRepairer((IPresentationRepairer)new UniversalEditor.PresentationRepairer(this.fEditor), "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)new UniversalEditor.PresentationDamager(this.fEditor), "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.getServiceControllerManager() == null) {
            return super.getContentAssistant(sourceViewer);
        }
        ContentAssistant ca = new ContentAssistant();
        ca.setContentAssistProcessor((IContentAssistProcessor)this.getServiceControllerManager().getCompletionProcessor(), "__dftl_partition_content_type");
        ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return ca;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.getLanguageServiceManager() == null) {
            return super.getAnnotationHover(sourceViewer);
        }
        IAnnotationHover hover = this.getLanguageServiceManager().getAnnotationHover();
        if (hover == null) {
            hover = new DefaultAnnotationHover();
        }
        return hover;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.getLanguageServiceManager() == null) {
            return super.getAutoEditStrategies(sourceViewer, contentType);
        }
        Set<org.eclipse.imp.services.IAutoEditStrategy> autoEdits = this.getLanguageServiceManager().getAutoEditStrategies();
        if (autoEdits == null || autoEdits.size() == 0) {
            return super.getAutoEditStrategies(sourceViewer, contentType);
        }
        return autoEdits.toArray(new IAutoEditStrategy[autoEdits.size()]);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        if (this.getServiceControllerManager() == null || this.getServiceControllerManager().getFormattingController() == null) {
            return null;
        }
        ContentFormatter formatter = new ContentFormatter();
        formatter.setFormattingStrategy((IFormattingStrategy)this.getServiceControllerManager().getFormattingController(), "__dftl_partition_content_type");
        return formatter;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return super.getDefaultPrefixes(sourceViewer, contentType);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        LanguageServiceManager lsm = this.getLanguageServiceManager();
        return lsm != null ? new DoubleClickStrategy(lsm.getParseController()) : super.getDoubleClickStrategy(sourceViewer, contentType);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (this.getServiceControllerManager() != null && this.getServiceControllerManager().getHyperLinkController() != null) {
            return new IHyperlinkDetector[]{this.getServiceControllerManager().getHyperLinkController()};
        }
        return super.getHyperlinkDetectors(sourceViewer);
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        return super.getHyperlinkPresenter(sourceViewer);
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return super.getIndentPrefixes(sourceViewer, contentType);
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, "Press 'F2' for focus", (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        if (this.getLanguageServiceManager() == null) {
            return super.getInformationPresenter(sourceViewer);
        }
        if (this.fInfoPresenter == null) {
            this.fInfoPresenter = new InformationPresenter(this.getInformationControlCreator(sourceViewer));
            this.fInfoPresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            this.fInfoPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
            IInformationProvider provider = new IInformationProvider(){
                private IAnnotationModel fAnnotationModel;
                {
                    this.fAnnotationModel = StructuredSourceViewerConfiguration.this.fEditor.getDocumentProvider().getAnnotationModel((Object)StructuredSourceViewerConfiguration.this.fEditor.getEditorInput());
                }

                private List<Annotation> getParserAnnotationsAtOffset(int offset) {
                    LinkedList<Annotation> result = new LinkedList<Annotation>();
                    if (this.fAnnotationModel != null) {
                        Iterator iter = this.fAnnotationModel.getAnnotationIterator();
                        while (iter.hasNext()) {
                            Annotation ann = (Annotation)iter.next();
                            if (!this.fAnnotationModel.getPosition(ann).includes(offset) || !UniversalEditor.isParseAnnotation(ann)) continue;
                            result.add(ann);
                        }
                    }
                    return result;
                }

                public IRegion getSubject(ITextViewer textViewer, int offset) {
                    List<Annotation> parserAnnsAtOffset = this.getParserAnnotationsAtOffset(offset);
                    if (parserAnnsAtOffset.size() > 0) {
                        Annotation theAnn = parserAnnsAtOffset.get(0);
                        Position pos = this.fAnnotationModel.getPosition(theAnn);
                        return new Region(pos.offset, pos.length);
                    }
                    IParseController pc = StructuredSourceViewerConfiguration.this.getLanguageServiceManager().getParseController();
                    ISourcePositionLocator locator = pc.getSourcePositionLocator();
                    if (locator == null) {
                        return new Region(offset, 0);
                    }
                    Object selNode = locator.findNode(pc.getCurrentAst(), offset);
                    return new Region(locator.getStartOffset(selNode), locator.getLength(selNode));
                }

                public String getInformation(ITextViewer textViewer, IRegion subject) {
                    List<Annotation> parserAnnsAtOffset = this.getParserAnnotationsAtOffset(subject.getOffset());
                    if (parserAnnsAtOffset.size() > 0) {
                        Annotation theAnn = parserAnnsAtOffset.get(0);
                        return theAnn.getText();
                    }
                    IParseController pc = StructuredSourceViewerConfiguration.this.getLanguageServiceManager().getParseController();
                    ISourcePositionLocator locator = pc.getSourcePositionLocator();
                    if (locator == null) {
                        return "";
                    }
                    IDocumentationProvider docProvider = StructuredSourceViewerConfiguration.this.getLanguageServiceManager().getDocProvider();
                    Object selNode = locator.findNode(pc.getCurrentAst(), subject.getOffset());
                    return docProvider != null ? docProvider.getDocumentation(selNode, pc) : null;
                }
            };
            this.fInfoPresenter.setInformationProvider(provider, "__dftl_partition_content_type");
            this.fInfoPresenter.setSizeConstraints(60, 10, true, false);
            this.fInfoPresenter.setRestoreInformationControlBounds(this.getSettings("outline_presenter_bounds"), true, true);
        }
        return this.fInfoPresenter;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.getServiceControllerManager() == null) {
            return super.getTextHover(sourceViewer, contentType);
        }
        return this.getServiceControllerManager().getHoverHelpController();
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        return super.getTextHover(sourceViewer, contentType, stateMask);
    }

    public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
        return super.getUndoManager(sourceViewer);
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return super.getOverviewRulerAnnotationHover(sourceViewer);
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer) {
        if (this.getLanguageServiceManager() == null) {
            return null;
        }
        if (this.getLanguageServiceManager().getModelBuilder() == null) {
            return null;
        }
        InformationPresenter presenter = new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, "org.eclipse.imp.runtime.editor.showOutline"));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        IInformationProvider provider = this.fOutlineElementProvider;
        presenter.setInformationProvider(provider, "__dftl_partition_content_type");
        presenter.setSizeConstraints(50, 20, true, false);
        presenter.setRestoreInformationControlBounds(this.getSettings("outline_presenter_bounds"), true, true);
        return presenter;
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, final String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new OutlineInformationControl(parent, shellStyle, treeStyle, commandId, StructuredSourceViewerConfiguration.this.fEditor.getLanguage());
            }
        };
    }

    public IInformationPresenter getHierarchyPresenter(ISourceViewer sourceViewer, boolean doCodeResolve) {
        InformationPresenter presenter = new InformationPresenter(this.getHierarchyPresenterControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        IInformationProvider provider = null;
        presenter.setInformationProvider(provider, "__dftl_partition_content_type");
        presenter.setSizeConstraints(50, 20, true, false);
        presenter.setRestoreInformationControlBounds(this.getSettings("hierarchy_presenter_bounds"), true, true);
        return presenter;
    }

    private IInformationControlCreator getHierarchyPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        };
    }

    private IDialogSettings getSettings(String sectionName) {
        IDialogSettings settings = RuntimePlugin.getInstance().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = RuntimePlugin.getInstance().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        return new QuickFixController(this.fEditor);
    }

    private class OutlineInformationProvider
    implements IInformationProvider,
    IInformationProviderExtension {
        private TreeModelBuilderBase fBuilder;

        private OutlineInformationProvider() {
        }

        public IRegion getSubject(ITextViewer textViewer, int offset) {
            return new Region(offset, 0);
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return "never called?!?";
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            if (this.fBuilder == null) {
                this.fBuilder = StructuredSourceViewerConfiguration.this.getLanguageServiceManager().getModelBuilder();
            }
            return this.fBuilder.buildTree(StructuredSourceViewerConfiguration.this.getLanguageServiceManager().getParseController().getCurrentAst());
        }
    }
}

