/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.util.ResourceBundle;
import org.eclipse.imp.editor.GotoAnnotationAction;
import org.eclipse.imp.editor.GotoNextTargetAction;
import org.eclipse.imp.editor.GotoPreviousTargetAction;
import org.eclipse.imp.editor.SelectEnclosingAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class TextEditorActionContributor
extends BasicTextEditorActionContributor {
    private GotoAnnotationAction fNextAnnotation;
    private GotoAnnotationAction fPreviousAnnotation = new GotoAnnotationAction("PreviousAnnotation.", false);
    private RetargetTextEditorAction fShowOutline;
    private GotoNextTargetAction fNextTarget;
    private GotoPreviousTargetAction fPreviousTarget;
    private SelectEnclosingAction fSelectEnclosing;

    public TextEditorActionContributor() {
        this.fNextAnnotation = new GotoAnnotationAction("NextAnnotation.", true);
        this.fShowOutline = new RetargetTextEditorAction(ResourceBundle.getBundle("org.eclipse.imp.editor.messages"), "ShowOutline.");
        this.fShowOutline.setActionDefinitionId("org.eclipse.imp.runtime.editor.showOutline");
        this.fNextTarget = new GotoNextTargetAction();
        this.fPreviousTarget = new GotoPreviousTargetAction();
        this.fSelectEnclosing = new SelectEnclosingAction();
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", (IAction)this.fNextAnnotation);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", (IAction)this.fPreviousAnnotation);
        bars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fNextAnnotation);
        bars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fPreviousAnnotation);
        bars.setGlobalActionHandler("org.eclipse.imp.runtime.editor.gotoNextTarget", (IAction)this.fNextTarget);
        bars.setGlobalActionHandler("org.eclipse.imp.runtime.editor.gotoPreviousTarget", (IAction)this.fPreviousTarget);
        bars.setGlobalActionHandler("org.eclipse.imp.runtime.editor.selectEnclosing", (IAction)this.fSelectEnclosing);
    }

    public void contributeToMenu(IMenuManager menu) {
        IMenuManager editMenu;
        super.contributeToMenu(menu);
        IMenuManager navigateMenu = menu.findMenuUsingPath("navigate");
        if (navigateMenu != null) {
            navigateMenu.appendToGroup("show.ext", (IAction)this.fShowOutline);
            navigateMenu.add((IAction)this.fNextTarget);
            navigateMenu.add((IAction)this.fPreviousTarget);
        }
        if ((editMenu = menu.findMenuUsingPath("edit")) != null) {
            editMenu.appendToGroup("editEnd", (IAction)this.fSelectEnclosing);
        }
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        ITextEditor textEditor = null;
        if (part instanceof ITextEditor) {
            textEditor = (ITextEditor)part;
        }
        this.fPreviousAnnotation.setEditor(textEditor);
        this.fNextAnnotation.setEditor(textEditor);
        this.fNextTarget.setEditor(textEditor);
        this.fPreviousTarget.setEditor(textEditor);
        this.fSelectEnclosing.setEditor(textEditor);
        this.fShowOutline.setAction(this.getAction(textEditor, "org.eclipse.imp.runtime.editor.showOutline"));
        IActionBars bars = this.getActionBars();
        bars.setGlobalActionHandler("org.eclipse.imp.runtime.actions.format", this.getAction(textEditor, "Format"));
        bars.setGlobalActionHandler("org.eclipse.imp.runtime.actions.shiftLeft", this.getAction(textEditor, "ShiftLeft"));
        bars.setGlobalActionHandler("org.eclipse.imp.runtime.actions.shiftRight", this.getAction(textEditor, "ShiftRight"));
        bars.setGlobalActionHandler("org.eclipse.imp.runtime.actions.toggleComment", this.getAction(textEditor, "org.eclipse.imp.runtime.editor.toggleComment"));
        bars.setGlobalActionHandler("org.eclipse.imp.runtime.actions.correctIndentation", this.getAction(textEditor, "org.eclipse.imp.runtime.editor.correctIndentation"));
        bars.setGlobalActionHandler("org.eclipse.imp.runtime.actions.Open", this.getAction(textEditor, "org.eclipse.imp.runtime.editor.openDeclaration"));
    }
}

