/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.utils.StreamUtils;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

class ZipStorageEditorDocumentProvider
extends StorageDocumentProvider {
    ZipStorageEditorDocumentProvider() {
    }

    public static boolean canHandle(IEditorInput editorInput) {
        if (editorInput instanceof IURIEditorInput) {
            IURIEditorInput uriEditorInput = (IURIEditorInput)editorInput;
            URI uri = uriEditorInput.getURI();
            if (uri == null) {
                return false;
            }
            String path = uri.getPath();
            return path.contains(".jar:") || path.contains(".zip:");
        }
        return editorInput instanceof IStorageEditorInput;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return new AnnotationModel();
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        AbstractDocumentProvider.ElementInfo ei = super.createElementInfo(element);
        if (element instanceof IURIEditorInput) {
            ei.fDocument = new Document(this.getZipEntryContents((IURIEditorInput)element));
        } else if (element instanceof IStorageEditorInput) {
            ei.fDocument = new Document(this.getStorageContents((IStorageEditorInput)element));
        }
        return ei;
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput) throws CoreException {
        String contents = null;
        if (editorInput instanceof IURIEditorInput) {
            IURIEditorInput uriEditorInput = (IURIEditorInput)editorInput;
            contents = this.getZipEntryContents(uriEditorInput);
        } else if (editorInput instanceof IStorageEditorInput) {
            IStorageEditorInput storageEditorInput = (IStorageEditorInput)editorInput;
            contents = this.getStorageContents(storageEditorInput);
        } else {
            throw new IllegalArgumentException("Inappropriate type of IEditorInput passed to ZipStorageEditorDocumentProvider: " + editorInput.getClass());
        }
        document.set(contents);
        return true;
    }

    private String getStorageContents(IStorageEditorInput storageEditorInput) throws CoreException {
        InputStream is = storageEditorInput.getStorage().getContents();
        return StreamUtils.readStreamContents(is);
    }

    private String getZipEntryContents(IURIEditorInput uriEditorInput) throws CoreException {
        String contents = "";
        try {
            URI uri = uriEditorInput.getURI();
            String path = uri.getPath();
            int lastColonIdx = path.lastIndexOf(58);
            String jarPath = path.substring(0, lastColonIdx);
            String entryPath = path.substring(lastColonIdx + 1);
            ZipFile zipFile = new ZipFile(new File(jarPath));
            ZipEntry entry = zipFile.getEntry(entryPath);
            InputStream is = zipFile.getInputStream(entry);
            contents = StreamUtils.readStreamContents(is);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.imp.runtime", 0, "Error encountered while obtaining zip file contents", (Throwable)e));
        }
        catch (Exception e) {
            RuntimePlugin.getInstance().logException("Exception caught while obtaining contents of zip file entry", e);
        }
        return contents;
    }
}

