/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.hover;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.editor.quickfix.IAnnotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ProblemLocation {
    private final int fId;
    private final int fOffset;
    private final int fLength;
    private final String fMarkerType;
    IMarker marker;
    IAnnotation annotation;

    public ProblemLocation(MarkerAnnotation annotation) throws CoreException {
        this(annotation.getMarker());
    }

    public ProblemLocation(int offset, int length, IAnnotation annotation) {
        this.fId = annotation.getId();
        this.fOffset = offset;
        this.fLength = length;
        this.fMarkerType = "org.eclipse.core.resources.problemmarker";
        this.annotation = annotation;
    }

    public ProblemLocation(IMarker marker) throws CoreException {
        this.fId = marker.getAttribute("errorCode", 0);
        this.fOffset = marker.getAttribute("charStart", 0);
        this.fLength = marker.getAttribute("charEnd", 0) - this.fOffset;
        this.fMarkerType = marker.getType();
        this.marker = marker;
    }

    public int getProblemId() {
        return this.fId;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public String getMarkerType() {
        return this.fMarkerType;
    }

    public Object getAttribute(String key) throws CoreException {
        if (this.marker != null) {
            return this.marker.getAttribute(key);
        }
        return this.annotation.getAttribute(key);
    }

    public String getAttribute(String key, String def) {
        if (this.marker != null) {
            return this.marker.getAttribute(key, def);
        }
        return (String)this.annotation.getAttribute(key);
    }

    public int getAttribute(String key, int def) {
        if (this.marker != null) {
            return this.marker.getAttribute(key, def);
        }
        return (Integer)this.annotation.getAttribute(key);
    }
}

