/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.editor.internal.DefaultAnnotation;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationCreator
implements IMessageHandler {
    private final ITextEditor fEditor;
    private final List<PositionedMessage> fMessages = new LinkedList<PositionedMessage>();
    private final List<Annotation> fAnnotations = new LinkedList<Annotation>();

    public AnnotationCreator(ITextEditor textEditor) {
        this.fEditor = textEditor;
    }

    @Override
    public void clearMessages() {
        this.removeAnnotations();
        this.fMessages.clear();
    }

    @Override
    public void startMessageGroup(String groupName) {
    }

    @Override
    public void endMessageGroup() {
    }

    @Override
    public void handleSimpleMessage(String msg, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine) {
        Position pos = new Position(startOffset, endOffset - startOffset + 1);
        this.fMessages.add(new PositionedMessage(msg, pos));
    }

    @Override
    public void handleSimpleMessage(String message, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine, Map<String, Object> attributes) {
        Position pos = new Position(startOffset, endOffset - startOffset + 1);
        this.fMessages.add(new PositionedMessage(message, pos, attributes));
    }

    @Override
    public void endMessages() {
        IDocumentProvider docProvider = this.fEditor.getDocumentProvider();
        if (docProvider != null) {
            IAnnotationModel model = docProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
            if (model instanceof IAnnotationModelExtension) {
                IAnnotationModelExtension modelExt = (IAnnotationModelExtension)model;
                Annotation[] oldAnnotations = this.fAnnotations.toArray(new Annotation[this.fAnnotations.size()]);
                HashMap<Annotation, Position> newAnnotations = new HashMap<Annotation, Position>(this.fMessages.size());
                for (PositionedMessage pm : this.fMessages) {
                    Annotation anno = this.createAnnotation(pm);
                    newAnnotations.put(anno, pm.pos);
                    this.fAnnotations.add(anno);
                }
                modelExt.replaceAnnotations(oldAnnotations, newAnnotations);
            } else if (model != null) {
                Iterator i = model.getAnnotationIterator();
                while (i.hasNext()) {
                    Annotation a = (Annotation)i.next();
                    if (!UniversalEditor.isParseAnnotation(a)) continue;
                    model.removeAnnotation(a);
                }
                for (PositionedMessage pm : this.fMessages) {
                    Annotation annotation = this.createAnnotation(pm);
                    model.addAnnotation(annotation, pm.pos);
                    this.fAnnotations.add(annotation);
                }
            }
        }
        this.fMessages.clear();
    }

    private Annotation createAnnotation(PositionedMessage pm) {
        if (pm.attributes == null || !(this.fEditor instanceof UniversalEditor)) {
            return new Annotation("org.eclipse.imp.editor.parseAnnotation", false, pm.message);
        }
        return new DefaultAnnotation(this.getAnnotationType(pm), false, pm.message, (UniversalEditor)this.fEditor, pm.attributes);
    }

    private String getAnnotationType(PositionedMessage pm) {
        if (pm.attributes.containsKey("severity")) {
            int severity = (Integer)pm.attributes.get("severity");
            switch (severity) {
                case 4: {
                    return "org.eclipse.imp.editor.parseAnnotation.error";
                }
                case 2: {
                    return "org.eclipse.imp.editor.parseAnnotation.warning";
                }
                case 1: {
                    return "org.eclipse.imp.editor.parseAnnotation.info";
                }
            }
        }
        return "org.eclipse.imp.editor.parseAnnotation";
    }

    private void removeAnnotations() {
        IDocumentProvider docProvider = this.fEditor.getDocumentProvider();
        if (docProvider == null) {
            return;
        }
        IAnnotationModel model = docProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (model == null) {
            return;
        }
        if (model instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension modelExt = (IAnnotationModelExtension)model;
            Annotation[] oldAnnotations = this.fAnnotations.toArray(new Annotation[this.fAnnotations.size()]);
            modelExt.replaceAnnotations(oldAnnotations, Collections.EMPTY_MAP);
        } else {
            Iterator i = model.getAnnotationIterator();
            while (i.hasNext()) {
                Annotation a = (Annotation)i.next();
                if (!UniversalEditor.isParseAnnotation(a)) continue;
                model.removeAnnotation(a);
            }
        }
        this.fAnnotations.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PositionedMessage {
        public final String message;
        public final Position pos;
        public final Map<String, Object> attributes;

        public PositionedMessage(String msg, Position pos, Map<String, Object> attributes) {
            this.message = msg;
            this.pos = pos;
            this.attributes = attributes;
        }

        public PositionedMessage(String msg, Position pos) {
            this(msg, pos, null);
        }
    }
}

