/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.editor.internal.QuickFixController;
import org.eclipse.imp.editor.quickfix.IAnnotation;
import org.eclipse.imp.runtime.PluginImages;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class AnnotationImageProvider
implements IAnnotationImageProvider {
    private static final int NO_IMAGE = 0;
    private static final int GRAY_IMAGE = 1;
    private static final int QUICKFIX_IMAGE = 3;
    private static final int QUICKFIX_ERROR_IMAGE = 4;
    private static Image fgQuickFixImage;
    private static Image fgQuickFixErrorImage;
    private static ImageRegistry fgImageRegistry;
    private boolean fShowQuickFixIcon = RuntimePlugin.getInstance().getPreferenceStore().getBoolean("showTemporaryProblem");
    private int fCachedImageType;
    private Image fCachedImage;

    public Image getManagedImage(Annotation annotation) {
        if (annotation instanceof IAnnotation) {
            int imageType = this.getImageType(annotation);
            return this.getImage(annotation, imageType, Display.getCurrent());
        }
        return null;
    }

    public String getImageDescriptorId(Annotation annotation) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(String symbolicName) {
        return null;
    }

    private boolean showQuickFix(Annotation annotation) {
        return this.fShowQuickFixIcon && AnnotationImageProvider.hasCorrections(annotation);
    }

    private Image getQuickFixImage() {
        if (fgQuickFixImage == null) {
            fgQuickFixImage = PluginImages.get("quickfix_warning_obj.gif");
        }
        return fgQuickFixImage;
    }

    private Image getQuickFixErrorImage() {
        if (fgQuickFixErrorImage == null) {
            fgQuickFixErrorImage = PluginImages.get("quickfix_error_obj.gif");
        }
        return fgQuickFixErrorImage;
    }

    private ImageRegistry getImageRegistry(Display display) {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry(display);
        }
        return fgImageRegistry;
    }

    private int getImageType(Annotation annotation) {
        int imageType = 0;
        if (!annotation.isMarkedDeleted()) {
            if (this.showQuickFix(annotation)) {
                imageType = 4 == ((IAnnotation)annotation).getSeverity() ? 4 : 3;
            }
        } else {
            imageType = 1;
        }
        return imageType;
    }

    private Image getImage(Annotation annotation, int imageType, Display display) {
        if ((imageType == 3 || imageType == 4) && this.fCachedImageType == imageType) {
            return this.fCachedImage;
        }
        Image image = null;
        switch (imageType) {
            case 3: {
                image = this.getQuickFixImage();
                this.fCachedImageType = imageType;
                this.fCachedImage = image;
                break;
            }
            case 4: {
                image = this.getQuickFixErrorImage();
                this.fCachedImageType = imageType;
                this.fCachedImage = image;
                break;
            }
            case 1: {
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                String annotationType = annotation.getType();
                if ("org.eclipse.imp.editor.parseAnnotation.error".equals(annotationType)) {
                    image = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                } else if ("org.eclipse.imp.editor.parseAnnotation.warning".equals(annotationType)) {
                    image = sharedImages.getImage("IMG_OBJS_WARN_TSK");
                } else if ("org.eclipse.imp.editor.parseAnnotation.info".equals(annotationType)) {
                    image = sharedImages.getImage("IMG_OBJS_INFO_TSK");
                } else if ("org.eclipse.imp.editor.parseAnnotation".equals(annotationType)) {
                    image = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                }
                if (image != null) {
                    String key;
                    ImageRegistry registry = this.getImageRegistry(display);
                    Image grayImage = registry.get(key = Integer.toString(image.hashCode()));
                    if (grayImage == null) {
                        grayImage = new Image((Device)display, image, 2);
                        registry.put(key, grayImage);
                    }
                    image = grayImage;
                }
                this.fCachedImageType = -1;
                break;
            }
        }
        return image;
    }

    public static boolean hasCorrections(Annotation annotation) {
        IEditorPart editor;
        IAnnotation iAnnotation;
        int problemId;
        if (annotation instanceof IAnnotation && (problemId = (iAnnotation = (IAnnotation)annotation).getId()) != -1 && (editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) instanceof UniversalEditor) {
            QuickFixController qfc = new QuickFixController((UniversalEditor)editor);
            return qfc.canFix(annotation);
        }
        if (annotation instanceof SimpleMarkerAnnotation) {
            return AnnotationImageProvider.hasCorrections(((SimpleMarkerAnnotation)annotation).getMarker());
        }
        return false;
    }

    private static boolean hasCorrections(IMarker marker) {
        if (marker == null || !marker.exists()) {
            return false;
        }
        IMarkerHelpRegistry registry = IDE.getMarkerHelpRegistry();
        return registry != null && registry.hasResolutions(marker);
    }
}

