/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.editor.HoverHelper;
import org.eclipse.imp.editor.internal.hover.BestMatchHover;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.IHoverHelper;
import org.eclipse.imp.services.base.HoverHelperBase;
import org.eclipse.imp.utils.AnnotationUtils;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.source.ISourceViewer;

public class HoverHelpController
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2,
IModelListener {
    private IParseController controller;
    private IHoverHelper hoverHelper;
    BestMatchHover fHover;

    public HoverHelpController(Language language) {
        this.hoverHelper = ServiceFactory.getInstance().getHoverHelper(language);
        if (this.hoverHelper == null) {
            this.hoverHelper = new HoverHelper(language);
            this.fHover = new BestMatchHover();
        } else if (this.hoverHelper instanceof HoverHelperBase) {
            ((HoverHelperBase)this.hoverHelper).setLanguage(language);
        }
    }

    public IModelListener.AnalysisRequired getAnalysisRequired() {
        return IModelListener.AnalysisRequired.NAME_ANALYSIS;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        try {
            int offset = hoverRegion.getOffset();
            String help = null;
            if (this.controller != null && this.hoverHelper != null) {
                help = this.hoverHelper.getHoverHelpAt(this.controller, (ISourceViewer)textViewer, offset);
            }
            if (help == null) {
                help = AnnotationUtils.formatAnnotationList(AnnotationUtils.getAnnotationsForOffset((ISourceViewer)textViewer, offset));
            }
            return help;
        }
        catch (Throwable e) {
            ErrorHandler.reportError("Hover help service implementation threw an exception", e);
            return null;
        }
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.fHover instanceof ITextHoverExtension2) {
            Object info = this.fHover.getHoverInfo2(textViewer, hoverRegion);
            return info == null ? this.getHoverInfo(textViewer, hoverRegion) : info;
        }
        return this.fHover.getHoverInfo(textViewer, hoverRegion);
    }

    public void update(IParseController controller, IProgressMonitor monitor) {
        this.controller = controller;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHover instanceof ITextHoverExtension) {
            return this.fHover.getHoverControlCreator();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fHover).getInformationPresenterControlCreator();
        }
        return null;
    }
}

