/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.editor.EditorUtility;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.editor.hover.ProblemLocation;
import org.eclipse.imp.editor.internal.quickfix.MarkerResolutionProposal;
import org.eclipse.imp.editor.quickfix.IAnnotation;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.services.IQuickFixAssistant;
import org.eclipse.imp.services.IQuickFixInvocationContext;
import org.eclipse.imp.services.base.DefaultQuickFixAssistant;
import org.eclipse.imp.utils.AnnotationUtils;
import org.eclipse.imp.utils.MarkerUtils;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickFixController
extends QuickAssistAssistant
implements IQuickAssistProcessor {
    private IQuickFixAssistant fAssistant;
    private ICompilationUnit fCU;

    public QuickFixController(IMarker marker) {
        this(MarkerUtils.getLanguage(marker), null);
        IFileEditorInput input = MarkerUtils.getInput(marker);
        if (input != null) {
            this.fCU = ModelFactory.open(input.getFile(), EditorUtility.getSourceProject((IEditorInput)input));
        }
    }

    public QuickFixController(UniversalEditor editor) {
        this(editor.getLanguage(), null);
        if (editor.getEditorInput() instanceof FileEditorInput) {
            FileEditorInput input = (FileEditorInput)editor.getEditorInput();
            this.fCU = ModelFactory.open(input.getFile(), EditorUtility.getSourceProject((IEditorInput)input));
        }
    }

    public QuickFixController(Language lang, ICompilationUnit cu) {
        this.fCU = cu;
        this.setQuickAssistProcessor(this);
        if (lang != null) {
            this.fAssistant = ServiceFactory.getInstance().getQuickFixAssistant(lang);
        }
        if (this.fAssistant == null) {
            this.fAssistant = new DefaultQuickFixAssistant();
        }
    }

    public IQuickFixInvocationContext getContext(IQuickAssistInvocationContext quickAssistContext) {
        return new DefaultQuickFixInvocationContext(quickAssistContext, this.fCU);
    }

    public String getErrorMessage() {
        return null;
    }

    public boolean canFix(Annotation annotation) {
        return this.fAssistant.canFix(annotation);
    }

    public boolean canAssist(IQuickAssistInvocationContext quickAssistContext) {
        return this.fAssistant.canAssist(this.getContext(quickAssistContext));
    }

    public boolean canFix(IMarker marker) throws CoreException {
        for (String type : this.fAssistant.getSupportedMarkerTypes()) {
            if (!marker.getType().equals(type)) continue;
            MarkerAnnotation ma = new MarkerAnnotation(marker);
            return this.fAssistant.canFix((Annotation)ma);
        }
        return false;
    }

    public void collectProposals(IQuickFixInvocationContext context, IAnnotationModel model, Collection<Annotation> annotations, boolean addQuickFixes, boolean addQuickAssists, Collection<ICompletionProposal> proposals) {
        ArrayList<ProblemLocation> problems = new ArrayList<ProblemLocation>();
        for (Annotation curr : annotations) {
            ProblemLocation problemLocation = null;
            if (curr instanceof IAnnotation && (problemLocation = QuickFixController.getProblemLocation((IAnnotation)curr, model)) != null) {
                problems.add(problemLocation);
            }
            if (problemLocation != null || !addQuickFixes || !(curr instanceof SimpleMarkerAnnotation)) continue;
            QuickFixController.collectMarkerProposals((SimpleMarkerAnnotation)curr, proposals);
        }
        ProblemLocation[] problemLocations = problems.toArray(new ProblemLocation[problems.size()]);
        if (addQuickFixes) {
            this.collectCorrections(context, problemLocations, proposals);
        }
        if (addQuickAssists) {
            QuickFixController.collectAssists(context, problemLocations, proposals);
        }
    }

    private static ProblemLocation getProblemLocation(IAnnotation annotation, IAnnotationModel model) {
        Position pos;
        int problemId = annotation.getId();
        if (problemId != -1 && (pos = model.getPosition((Annotation)annotation)) != null) {
            return new ProblemLocation(pos.getOffset(), pos.getLength(), annotation);
        }
        return null;
    }

    public static void collectAssists(IQuickAssistInvocationContext context, ProblemLocation[] locations, Collection<ICompletionProposal> proposals) {
    }

    private static void collectMarkerProposals(SimpleMarkerAnnotation annotation, Collection<ICompletionProposal> proposals) {
        IMarker marker = annotation.getMarker();
        IMarkerResolution[] res = IDE.getMarkerHelpRegistry().getResolutions(marker);
        if (res.length > 0) {
            for (int i = 0; i < res.length; ++i) {
                proposals.add(new MarkerResolutionProposal(res[i], marker));
            }
        }
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext quickAssistContext) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        ISourceViewer viewer = quickAssistContext.getSourceViewer();
        this.collectProposals(this.getContext(quickAssistContext), AnnotationUtils.getAnnotationModel(viewer), AnnotationUtils.getAnnotationsForOffset(viewer, quickAssistContext.getOffset()), true, true, proposals);
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public void collectCorrections(IQuickAssistInvocationContext quickAssistContext, ProblemLocation[] locations, Collection<ICompletionProposal> proposals) {
        if (locations == null || locations.length == 0) {
            return;
        }
        HashSet<Integer> handledProblems = new HashSet<Integer>(locations.length);
        for (int i = 0; i < locations.length; ++i) {
            ProblemLocation curr = locations[i];
            Integer id = new Integer(curr.getProblemId());
            if (!handledProblems.add(id)) continue;
            this.fAssistant.addProposals(this.getContext(quickAssistContext), curr, proposals);
        }
    }

    private static class DefaultQuickFixInvocationContext
    implements IQuickFixInvocationContext {
        private IQuickAssistInvocationContext context;
        private ICompilationUnit model;

        public DefaultQuickFixInvocationContext(IQuickAssistInvocationContext context, ICompilationUnit model) {
            this.context = context;
            this.model = model;
        }

        public int getLength() {
            return this.context.getLength();
        }

        public int getOffset() {
            return this.context.getOffset();
        }

        public ISourceViewer getSourceViewer() {
            return this.context.getSourceViewer();
        }

        public ICompilationUnit getModel() {
            return this.model;
        }
    }
}

