/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal.hover;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.editor.quickfix.IAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class AnnotationIterator
implements Iterator {
    private Iterator fIterator;
    private Annotation fNext;
    private boolean fReturnAllAnnotations;

    public AnnotationIterator(Iterator parent, boolean returnAllAnnotations) {
        this.fReturnAllAnnotations = returnAllAnnotations;
        this.fIterator = parent;
        this.skip();
    }

    private void skip() {
        while (this.fIterator.hasNext()) {
            Annotation next = (Annotation)this.fIterator.next();
            if (next.isMarkedDeleted() || !this.fReturnAllAnnotations && !(next instanceof IAnnotation) && !AnnotationIterator.isProblemMarkerAnnotation(next)) continue;
            this.fNext = next;
            return;
        }
        this.fNext = null;
    }

    private static boolean isProblemMarkerAnnotation(Annotation annotation) {
        if (!(annotation instanceof MarkerAnnotation)) {
            return false;
        }
        try {
            return ((MarkerAnnotation)annotation).getMarker().isSubtypeOf("org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException e) {
            return false;
        }
    }

    public boolean hasNext() {
        return this.fNext != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() {
        try {
            Annotation annotation = this.fNext;
            return annotation;
        }
        finally {
            this.skip();
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

