/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal.hover;

import java.util.ArrayList;
import org.eclipse.imp.editor.hover.AbstractAnnotationHover;
import org.eclipse.imp.editor.hover.ProblemLocation;
import org.eclipse.imp.editor.internal.QuickFixController;
import org.eclipse.imp.editor.quickfix.IAnnotation;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ProblemHover
extends AbstractAnnotationHover {
    public ProblemHover() {
        super(false);
    }

    protected AbstractAnnotationHover.AnnotationInfo createAnnotationInfo(Annotation annotation, Position position, ITextViewer textViewer) {
        return new ProblemInfo(annotation, position, textViewer);
    }

    protected static class ProblemInfo
    extends AbstractAnnotationHover.AnnotationInfo {
        private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];

        public ProblemInfo(Annotation annotation, Position position, ITextViewer textViewer) {
            super(annotation, position, textViewer);
        }

        public ICompletionProposal[] getCompletionProposals() {
            ICompletionProposal[] result;
            if (this.annotation instanceof IAnnotation && (result = this.getAnnotationFixes((IAnnotation)this.annotation)).length > 0) {
                return result;
            }
            if (this.annotation instanceof MarkerAnnotation) {
                return this.getMarkerAnnotationFixes((MarkerAnnotation)this.annotation);
            }
            return NO_PROPOSALS;
        }

        private ICompletionProposal[] getAnnotationFixes(IAnnotation annotation) {
            QuickFixController qac = new QuickFixController(annotation.getEditor());
            final ProblemLocation location = new ProblemLocation(this.position.getOffset(), this.position.getLength(), annotation);
            IQuickAssistInvocationContext quickAssistContext = new IQuickAssistInvocationContext(){

                public ISourceViewer getSourceViewer() {
                    if (ProblemInfo.this.viewer instanceof ISourceViewer) {
                        return (ISourceViewer)ProblemInfo.this.viewer;
                    }
                    return null;
                }

                public int getOffset() {
                    return location.getOffset();
                }

                public int getLength() {
                    return location.getLength();
                }
            };
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            qac.collectCorrections(qac.getContext(quickAssistContext), new ProblemLocation[]{location}, proposals);
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }

        private ICompletionProposal[] getMarkerAnnotationFixes(MarkerAnnotation markerAnnotation) {
            if (markerAnnotation.isQuickFixableStateSet() && !markerAnnotation.isQuickFixable()) {
                return NO_PROPOSALS;
            }
            TextInvocationContext context = new TextInvocationContext((ISourceViewer)this.viewer, this.position.getOffset(), this.position.getLength());
            QuickFixController c = new QuickFixController(markerAnnotation.getMarker());
            return c.computeQuickAssistProposals((IQuickAssistInvocationContext)context);
        }

        public void fillToolBar(ToolBarManager manager, IInformationControl infoControl) {
            super.fillToolBar(manager, infoControl);
        }
    }
}

