/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.quickfix;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.imp.editor.EditorUtility;
import org.eclipse.imp.editor.quickfix.ChangeCorrectionProposal;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.internal.core.refactoring.UndoDocumentChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.CopyTargetEdit;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.ui.IEditorPart;

public class CUCorrectionProposal
extends ChangeCorrectionProposal {
    private ICompilationUnit fCompilationUnit;
    private final int surroundLines = 1;

    public CUCorrectionProposal(String name, ICompilationUnit cu, TextChange change, int relevance, Image image) {
        super(name, (Change)change, relevance, image);
        if (cu == null) {
            throw new IllegalArgumentException("Compilation unit must not be null");
        }
        this.fCompilationUnit = cu;
    }

    protected CUCorrectionProposal(String name, ICompilationUnit cu, int relevance, Image image) {
        this(name, cu, null, relevance, image);
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        final StringBuffer buf = new StringBuffer();
        try {
            TextChange change = this.getTextChange();
            change.setKeepPreviewEdits(true);
            final IDocument previewContent = change.getPreviewDocument(monitor);
            TextEdit rootEdit = change.getPreviewEdit(change.getEdit());
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class EditAnnotator
            extends TextEditVisitor {
                private int fWrittenToPos = 0;

                EditAnnotator() {
                }

                public void unchangedUntil(int pos) {
                    if (pos > this.fWrittenToPos) {
                        CUCorrectionProposal.this.appendContent(previewContent, this.fWrittenToPos, pos, buf, true);
                        this.fWrittenToPos = pos;
                    }
                }

                public boolean visit(MoveTargetEdit edit) {
                    return true;
                }

                public boolean visit(CopyTargetEdit edit) {
                    return true;
                }

                public boolean visit(InsertEdit edit) {
                    return this.rangeAdded((TextEdit)edit);
                }

                public boolean visit(ReplaceEdit edit) {
                    if (edit.getLength() > 0) {
                        return this.rangeAdded((TextEdit)edit);
                    }
                    return this.rangeRemoved((TextEdit)edit);
                }

                public boolean visit(MoveSourceEdit edit) {
                    return this.rangeRemoved((TextEdit)edit);
                }

                public boolean visit(DeleteEdit edit) {
                    return this.rangeRemoved((TextEdit)edit);
                }

                private boolean rangeRemoved(TextEdit edit) {
                    this.unchangedUntil(edit.getOffset());
                    return false;
                }

                private boolean rangeAdded(TextEdit edit) {
                    this.unchangedUntil(edit.getOffset());
                    buf.append("<b>");
                    CUCorrectionProposal.this.appendContent(previewContent, edit.getOffset(), edit.getExclusiveEnd(), buf, false);
                    buf.append("</b>");
                    this.fWrittenToPos = edit.getExclusiveEnd();
                    return false;
                }
            }
            EditAnnotator ea = new EditAnnotator();
            rootEdit.accept((TextEditVisitor)ea);
            ea.unchangedUntil(previewContent.getLength());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return buf.toString();
    }

    private void appendContent(IDocument text, int startOffset, int endOffset, StringBuffer buf, boolean surroundLinesOnly) {
        try {
            int startLine = text.getLineOfOffset(startOffset);
            int endLine = text.getLineOfOffset(endOffset);
            boolean dotsAdded = false;
            if (surroundLinesOnly && startOffset == 0) {
                startLine = Math.max(endLine - 1, 0);
                buf.append("...<br>");
                dotsAdded = true;
            }
            for (int i = startLine; i <= endLine; ++i) {
                if (surroundLinesOnly && i - startLine > 1 && endLine - i > 1) {
                    if (!dotsAdded) {
                        buf.append("...<br>");
                        dotsAdded = true;
                        continue;
                    }
                    if (endOffset != text.getLength()) continue;
                    return;
                }
                IRegion lineInfo = text.getLineInformation(i);
                int start = lineInfo.getOffset();
                int end = start + lineInfo.getLength();
                int from = Math.max(start, startOffset);
                int to = Math.min(end, endOffset);
                String content = text.get(from, to - from);
                if (surroundLinesOnly && from == start && content.trim().length() == 0) continue;
                for (int k = 0; k < content.length(); ++k) {
                    char ch = content.charAt(k);
                    if (ch == '<') {
                        buf.append("&lt;");
                        continue;
                    }
                    if (ch == '>') {
                        buf.append("&gt;");
                        continue;
                    }
                    buf.append(ch);
                }
                if (to != end || to == endOffset) continue;
                buf.append("<br>");
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    public void apply(IDocument document) {
        try {
            IEditorPart part = null;
            this.performChange(part, document);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected TextChange createTextChange() throws CoreException {
        LocalDocumentChange change;
        Document document;
        ICompilationUnit cu = this.getCompilationUnit();
        String name = this.getName();
        if (!cu.getResource().exists()) {
            String source;
            try {
                source = cu.getSource();
            }
            catch (Exception e) {
                source = new String();
            }
            document = new Document(source);
            document.setInitialLineDelimiter(CUCorrectionProposal.getLineDelimiterPreference(cu));
            change = new DocumentChange(name, (IDocument)document);
        } else {
            change = new LocalDocumentChange(name, EditorUtility.getDocument(cu.getResource()));
        }
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setEdit((TextEdit)rootEdit);
        document = change.getCurrentDocument((IProgressMonitor)new NullProgressMonitor());
        this.addEdits((IDocument)document, (TextEdit)rootEdit);
        return change;
    }

    public static String getLineDelimiterPreference(ICompilationUnit cu) {
        IScopeContext[] scopeContext;
        IProject project = cu.getResource().getProject();
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project)};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{new InstanceScope()};
        String platformDefault = System.getProperty("line.separator", "\n");
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", platformDefault, scopeContext);
    }

    protected final Change createChange() throws CoreException {
        return this.createTextChange();
    }

    public final TextChange getTextChange() throws CoreException {
        return (TextChange)this.getChange();
    }

    public final ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public String getPreviewContent() throws CoreException {
        return this.getTextChange().getPreviewContent((IProgressMonitor)new NullProgressMonitor());
    }

    public String toString() {
        try {
            return this.getPreviewContent();
        }
        catch (CoreException coreException) {
            return super.toString();
        }
    }

    private class LocalUndoDocumentChange
    extends UndoDocumentChange {
        public LocalUndoDocumentChange(String name, IDocument document, UndoEdit undo) {
            super(name, document, undo);
        }

        public Object[] getAffectedObjects() {
            return new Object[]{CUCorrectionProposal.this.fCompilationUnit.getFile()};
        }
    }

    private class LocalDocumentChange
    extends DocumentChange {
        private IDocument doc;

        public LocalDocumentChange(String name, IDocument document) {
            super(name, document);
            this.doc = document;
        }

        protected Change createUndoChange(UndoEdit edit) {
            return new LocalUndoDocumentChange(this.getName(), this.doc, edit);
        }
    }
}

