/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.quickfix;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class ChangeCorrectionProposal
implements ICompletionProposal,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    private Change fChange;
    private String fName;
    private int fRelevance;
    private Image fImage;
    private String fCommandId;

    public ChangeCorrectionProposal(String name, Change change, int relevance, Image image) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.fName = name;
        this.fChange = change;
        this.fRelevance = relevance;
        this.fImage = image;
        this.fCommandId = null;
    }

    public void apply(IDocument document) {
        try {
            this.performChange(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor(), document);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performChange(IEditorPart activeEditor, IDocument document) throws CoreException {
        block12: {
            Change change = null;
            IRewriteTarget rewriteTarget = null;
            try {
                Change undoChange;
                change = this.getChange();
                if (change == null) break block12;
                if (document != null) {
                    LinkedModeModel.closeAllModels((IDocument)document);
                }
                if (activeEditor != null && (rewriteTarget = (IRewriteTarget)activeEditor.getAdapter(IRewriteTarget.class)) != null) {
                    rewriteTarget.beginCompoundChange();
                }
                change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                RefactoringStatus valid = change.isValid((IProgressMonitor)new NullProgressMonitor());
                if (valid.hasFatalError()) {
                    Status status = new Status(4, "org.eclipse.imp.runtime", 4, valid.getMessageMatchingSeverity(4), null);
                    throw new CoreException((IStatus)status);
                }
                IUndoManager manager = RefactoringCore.getUndoManager();
                boolean successful = false;
                try {
                    manager.aboutToPerformChange(change);
                    undoChange = change.perform((IProgressMonitor)new NullProgressMonitor());
                    successful = true;
                }
                finally {
                    manager.changePerformed(change, successful);
                }
                if (undoChange != null) {
                    undoChange.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    manager.addUndo(this.getName(), undoChange);
                }
            }
            finally {
                if (rewriteTarget != null) {
                    rewriteTarget.endCompoundChange();
                }
                if (change != null) {
                    change.dispose();
                }
            }
        }
    }

    public String getAdditionalProposalInfo() {
        Object info = this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        return info == null ? null : info.toString();
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        StringBuffer buf = new StringBuffer();
        buf.append("<p>");
        try {
            String name;
            Change change = this.getChange();
            if (change != null) {
                name = change.getName();
                if (name.length() == 0) {
                    return null;
                }
            } else {
                return null;
            }
            buf.append(name);
        }
        catch (CoreException e) {
            buf.append("Unexpected error when accessing this proposal:<p><pre>");
            buf.append(e.getLocalizedMessage());
            buf.append("</pre>");
        }
        buf.append("</p>");
        return buf.toString();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        String shortCutString = this.getCommandId();
        if (shortCutString != null) {
            return MessageFormat.format("{0} ({1})", this.getName(), shortCutString);
        }
        return this.getName();
    }

    public StyledString getStyledDisplayString() {
        StyledString str = new StyledString(this.getName());
        String shortCutString = this.getCommandId();
        if (shortCutString != null) {
            String decorated = MessageFormat.format("{0} ({1})", this.getName(), shortCutString);
            return StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)str);
        }
        return str;
    }

    public String getName() {
        return this.fName;
    }

    public Image getImage() {
        return this.fImage;
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public final synchronized Change getChange() throws CoreException {
        if (this.fChange == null) {
            this.fChange = this.createChange();
        }
        return this.fChange;
    }

    protected Change createChange() throws CoreException {
        return new NullChange();
    }

    public void setDisplayName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.fName = name;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    public String getCommandId() {
        return this.fCommandId;
    }

    public void setCommandId(String commandId) {
        this.fCommandId = commandId;
    }
}

