/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.help;

import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.imp.editor.LanguageServiceManager;
import org.eclipse.imp.help.IMPHelpContext;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.IHelpService;
import org.eclipse.jface.text.IRegion;

public class IMPHelpContextProvider
implements IContextProvider {
    private final IHelpService fHelpContextSrvc;
    private final IParseController fParseController;
    private final String fContextID;
    private final Object[] fSelected;
    private final IRegion fSelection;

    public IMPHelpContextProvider(LanguageServiceManager srvcMgr, String helpContextID, Object[] selected) {
        this.fHelpContextSrvc = srvcMgr.getContextHelp();
        this.fParseController = srvcMgr.getParseController();
        this.fContextID = helpContextID;
        this.fSelected = selected;
        this.fSelection = null;
    }

    public IMPHelpContextProvider(LanguageServiceManager srvcMgr, String helpContextID, IRegion selection) {
        this.fHelpContextSrvc = srvcMgr.getContextHelp();
        this.fParseController = srvcMgr.getParseController();
        this.fContextID = helpContextID;
        this.fSelected = null;
        this.fSelection = selection;
    }

    public IContext getContext(Object target) {
        Object context = HelpSystem.getContext((String)this.fContextID);
        if (this.fHelpContextSrvc != null) {
            context = HelpSystem.getContext((String)this.fHelpContextSrvc.getContextId(this.fContextID));
            if (this.fSelected != null && this.fSelected.length > 0) {
                context = new IMPHelpContext((IContext)context, IMPHelpContextProvider.buildHelpString(this.fSelected, this.fHelpContextSrvc, this.fParseController));
            } else if (this.fSelection != null) {
                context = new IMPHelpContext((IContext)context, IMPHelpContextProvider.buildHelpString(this.fSelection, this.fHelpContextSrvc, this.fParseController));
            }
        }
        return context;
    }

    public static String buildHelpString(Object[] entities, IHelpService helpService, IParseController parseController) {
        if (helpService == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < entities.length; ++i) {
            sb.append(helpService.getHelp(entities[i], parseController));
        }
        String result = sb.toString();
        return result;
    }

    public static String buildHelpString(IRegion selection, IHelpService helpService, IParseController parseController) {
        return helpService.getHelp(selection, parseController);
    }

    public int getContextChangeMask() {
        return 1;
    }

    public String getSearchExpression(Object target) {
        return null;
    }
}

