/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.language;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.imp.editor.OutlineContentProviderBase;
import org.eclipse.imp.editor.OutlineLabelProvider;
import org.eclipse.imp.indexing.IndexContributorBase;
import org.eclipse.imp.language.ILanguageService;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.IASTAdapter;
import org.eclipse.imp.services.IAnnotationHover;
import org.eclipse.imp.services.IAutoEditStrategy;
import org.eclipse.imp.services.ICompareNodeIdentifier;
import org.eclipse.imp.services.IContentProposer;
import org.eclipse.imp.services.IDocumentationProvider;
import org.eclipse.imp.services.IEditorInputResolver;
import org.eclipse.imp.services.IEntityImageDecorator;
import org.eclipse.imp.services.IEntityNameLocator;
import org.eclipse.imp.services.IFoldingUpdater;
import org.eclipse.imp.services.IHelpService;
import org.eclipse.imp.services.IHoverHelper;
import org.eclipse.imp.services.ILabelProvider;
import org.eclipse.imp.services.ILanguageActionsContributor;
import org.eclipse.imp.services.ILanguageSyntaxProperties;
import org.eclipse.imp.services.INavigationTargetFinder;
import org.eclipse.imp.services.IOccurrenceMarker;
import org.eclipse.imp.services.IOutliner;
import org.eclipse.imp.services.IQuickFixAssistant;
import org.eclipse.imp.services.IRefactoringContributor;
import org.eclipse.imp.services.IReferenceResolver;
import org.eclipse.imp.services.ISourceFormatter;
import org.eclipse.imp.services.ISourceHyperlinkDetector;
import org.eclipse.imp.services.IToggleBreakpointsHandler;
import org.eclipse.imp.services.ITokenColorer;
import org.eclipse.imp.services.base.TreeModelBuilderBase;
import org.eclipse.imp.utils.ExtensionException;
import org.eclipse.imp.utils.ExtensionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceFactory {
    private static ServiceFactory sInstance;
    public static final String LANGUAGE_DESCRIPTION_POINT_ID = "languageDescription";
    public static final String LANGUAGE_DESCRIPTION_QUALIFIED_POINT_ID = "org.eclipse.imp.runtime.languageDescription";
    static final String AUTO_EDIT_STRATEGY_SERVICE = "autoEditStrategy";
    static final String ANNOTATION_HOVER_SERVICE = "annotationHover";
    static final String AST_ADAPTER_SERVICE = "astAdapter";
    static final String COMPARE_NODE_IDENTIFIER_SERVICE = "compareNodeIdentifier";
    static final String CONTENT_PROPOSER_SERVICE = "contentProposer";
    static final String CONTEXT_HELPER_SERVICE = "contextHelper";
    static final String DOCUMENTATION_PROVIDER_SERVICE = "documentationProvider";
    static final String EDITOR_ACTION_CONTRIBUTIONS_SERVICE = "editorActionContributions";
    static final String EDITOR_SERVICE = "editorService";
    static final String ENTITY_IMAGE_DECORATOR_SERVICE = "entityImageDecorator";
    static final String ENTITY_NAME_LOCATOR_SERVICE = "entityNameLocator";
    static final String FOLDING_UPDATER_SERVICE = "foldingUpdater";
    static final String FORMATTER_SERVICE = "formatter";
    static final String HOVER_HELPER_SERVICE = "hoverHelper";
    static final String HYPER_LINK_SERVICE = "hyperLink";
    static final String IMAGE_DECORATOR_SERVICE = "imageDecorator";
    static final String INDEX_CONTRIBUTOR_SERVICE = "indexContributor";
    static final String LABEL_PROVIDER_SERVICE = "labelProvider";
    static final String MODEL_LISTENER_SERVICE = "modelListener";
    static final String MODEL_TREE_BUILDER_SERVICE = "modelTreeBuilder";
    static final String MARK_OCCURRENCES_SERVICE = "markOccurrences";
    static final String NAVIGATION_TARGET_FINDER_SERVICE = "navigationTargetFinder";
    static final String OUTLINE_CONTENT_PROVIDER_SERVICE = "outlineContentProvider";
    static final String OUTLINER_SERVICE = "outliner";
    static final String PARSER_SERVICE = "parser";
    static final String PREFERENCES_SERVICE = "preferencesDialog";
    static final String PREFERENCES_SPECIFICATION = "preferencesSpecification";
    static final String REFACTORING_CONTRIBUTIONS_SERVICE = "refactoringContributions";
    static final String REFERENCE_RESOLVER_SERVICE = "referenceResolvers";
    static final String SYNTAX_PROPS_SERVICE = "syntaxProps";
    static final String TOGGLE_BREAKPOINTS_HANDLER_SERVICE = "toggleBreakpointHandler";
    static final String TOKEN_COLORER_SERVICE = "tokenColorer";
    static final String VIEWER_FILTER_SERVICE = "viewerFilter";
    static final String EDITOR_INPUT_RESOLVER_SERVICE = "editorInputResolver";
    static final String QUICK_FIX_ASSISTANT_SERVICE = "quickFixAssistant";
    public static final List<String> ALL_SERVICES;

    protected ServiceFactory() {
    }

    public static ServiceFactory getInstance() {
        if (sInstance == null) {
            sInstance = new ServiceFactory();
        }
        return sInstance;
    }

    public static ServiceFactory otherGetInstance() {
        return sInstance;
    }

    public IAnnotationHover getAnnotationHover(Language lang) {
        try {
            return (IAnnotationHover)this.loadService(lang, ANNOTATION_HOVER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of annotationHover", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of annotationHover does not implement IAnnotationHover", e);
        }
        return null;
    }

    public IASTAdapter getASTAdapter(Language lang) {
        try {
            return (IASTAdapter)((Object)this.loadService(lang, AST_ADAPTER_SERVICE));
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of astAdapter", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of astAdapter does not implement IASTAdapter", e);
        }
        return null;
    }

    public Set<IAutoEditStrategy> getAutoEditStrategies(Language lang) {
        try {
            Set<ILanguageService> services = this.loadServices(lang, AUTO_EDIT_STRATEGY_SERVICE);
            HashSet<IAutoEditStrategy> autoEditStrategies = new HashSet<IAutoEditStrategy>();
            for (ILanguageService s : services) {
                autoEditStrategies.add((IAutoEditStrategy)s);
            }
            return autoEditStrategies;
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of autoEditStrategy", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of autoEditStrategy does not implement IAutoEditStrategy", e);
        }
        return null;
    }

    public ICompareNodeIdentifier getCompareNodeIdentifier(Language lang) {
        try {
            return (ICompareNodeIdentifier)this.loadService(lang, COMPARE_NODE_IDENTIFIER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of compareNodeIdentifier", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of compareNodeIdentifier does not implement ICompareNodeIdentifier", e);
        }
        return null;
    }

    public IContentProposer getContentProposer(Language lang) {
        try {
            return (IContentProposer)this.loadService(lang, CONTENT_PROPOSER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of contentProposer", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of contentProposer does not implement IContentProposer", e);
        }
        return null;
    }

    public IHelpService getContextHelper(Language lang) {
        try {
            return (IHelpService)this.loadService(lang, CONTEXT_HELPER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of contextHelper", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of contextHelper does not implement IHelpService", e);
        }
        return null;
    }

    public IDocumentationProvider getDocumentationProvider(Language lang) {
        try {
            return (IDocumentationProvider)this.loadService(lang, DOCUMENTATION_PROVIDER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of documentationProvider", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of documentationProvider does not implement IDocumentationProvider", e);
        }
        return null;
    }

    public Set<IModelListener> getEditorServices(Language lang) {
        HashSet<IModelListener> result = new HashSet<IModelListener>();
        for (ILanguageService service : this.createExtensions(lang, EDITOR_SERVICE)) {
            result.add((IModelListener)service);
        }
        return result;
    }

    public IEditorInputResolver getEditorInputResolver(Language lang) {
        try {
            return (IEditorInputResolver)this.loadService(lang, EDITOR_INPUT_RESOLVER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of editorInputResolver", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of editorInputResolver does not implement IEditorInputResolver", e);
        }
        return null;
    }

    public OutlineLabelProvider.IElementImageProvider getElementImageProvider(Language lang) {
        try {
            return (OutlineLabelProvider.IElementImageProvider)this.loadService(lang, IMAGE_DECORATOR_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of imageDecorator", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of imageDecorator does not implement IElementImageProvider", e);
        }
        return null;
    }

    public IEntityImageDecorator getEntityImageDecorator(Language lang) {
        try {
            return (IEntityImageDecorator)((Object)this.loadService(lang, ENTITY_IMAGE_DECORATOR_SERVICE));
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of entityImageDecorator", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of entityImageDecorator does not implement IEntityImageDecorator", e);
        }
        return null;
    }

    public IEntityNameLocator getEntityNameLocator(Language lang) {
        try {
            return (IEntityNameLocator)this.loadService(lang, ENTITY_NAME_LOCATOR_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of entityNameLocator", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of entityNameLocator does not implement IEntityNameLocator", e);
        }
        return null;
    }

    public IFoldingUpdater getFoldingUpdater(Language lang) {
        try {
            return (IFoldingUpdater)this.loadService(lang, FOLDING_UPDATER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of foldingUpdater", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of foldingUpdater does not implement IFoldingUpdater", e);
        }
        return null;
    }

    public IHoverHelper getHoverHelper(Language lang) {
        try {
            return (IHoverHelper)this.loadService(lang, HOVER_HELPER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of hoverHelper", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of hoverHelper does not implement IHoverHelper", e);
        }
        return null;
    }

    public IndexContributorBase getIndexContributor(Language lang) {
        try {
            return (IndexContributorBase)this.loadService(lang, INDEX_CONTRIBUTOR_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of indexContributor", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of indexContributor does not implement IndexContributorBase", e);
        }
        return null;
    }

    public ILabelProvider getLabelProvider(Language lang) {
        try {
            return (ILabelProvider)this.loadService(lang, LABEL_PROVIDER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of labelProvider", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of labelProvider does not implement ILabelProvider", e);
        }
        return null;
    }

    public Set<ILanguageActionsContributor> getLanguageActionsContributors(Language lang) {
        try {
            Set<ILanguageService> services = this.loadServices(lang, EDITOR_ACTION_CONTRIBUTIONS_SERVICE);
            HashSet<ILanguageActionsContributor> actionContributors = new HashSet<ILanguageActionsContributor>();
            for (ILanguageService s : services) {
                actionContributors.add((ILanguageActionsContributor)s);
            }
            return actionContributors;
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of editorActionContributions", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of editorActionContributions does not implement ILanguageActionConstributor", e);
        }
        return null;
    }

    public IModelListener getModelListener(Language lang) {
        try {
            return (IModelListener)this.loadService(lang, MODEL_LISTENER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of modelListener", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of modelListener does not implement IModelListener", e);
        }
        return null;
    }

    public INavigationTargetFinder getNavigationTargetFinder(Language lang) {
        try {
            return (INavigationTargetFinder)this.loadService(lang, NAVIGATION_TARGET_FINDER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of navigationTargetFinder", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of NAVIGATION_TARGET_FINDER does not implement INavigationTargetFinder", e);
        }
        return null;
    }

    public IOccurrenceMarker getOccurrenceMarker(Language lang) {
        try {
            return (IOccurrenceMarker)this.loadService(lang, MARK_OCCURRENCES_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of markOccurrences", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of markOccurrences does not implement IOccurrenceMarker", e);
        }
        return null;
    }

    public OutlineContentProviderBase getOutlineContentProvider(Language lang) {
        try {
            return (OutlineContentProviderBase)this.loadService(lang, OUTLINE_CONTENT_PROVIDER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of outlineContentProvider", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of outlineContentProvider does not implement OutlineContentProviderBase", e);
        }
        return null;
    }

    public IOutliner getOutliner(Language lang) {
        try {
            return (IOutliner)this.loadService(lang, OUTLINER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of outliner", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of outliner does not implement IOutliner", e);
        }
        return null;
    }

    public IParseController getParseController(Language lang) {
        try {
            return (IParseController)this.loadService(lang, PARSER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of parser", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of parser does not implement IParseController", e);
        }
        return null;
    }

    public IQuickFixAssistant getQuickFixAssistant(Language lang) {
        try {
            return (IQuickFixAssistant)this.loadService(lang, QUICK_FIX_ASSISTANT_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of quickFixAssistant", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of quickFixAssistant does not implement IQuickFixAssistant", e);
        }
        return null;
    }

    public Set<IRefactoringContributor> getRefactoringContributors(Language lang) {
        try {
            Set<ILanguageService> services = this.loadServices(lang, REFACTORING_CONTRIBUTIONS_SERVICE);
            HashSet<IRefactoringContributor> refactoringContribs = new HashSet<IRefactoringContributor>();
            for (ILanguageService s : services) {
                refactoringContribs.add((IRefactoringContributor)s);
            }
            return refactoringContribs;
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of refactoringContributions", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of refactoringContributions does not implement IRefactoringContributor", e);
        }
        return null;
    }

    public IReferenceResolver getReferenceResolver(Language lang) {
        try {
            return (IReferenceResolver)this.loadService(lang, REFERENCE_RESOLVER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of referenceResolvers", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of referenceResolvers does not implement IReferenceResolver", e);
        }
        return null;
    }

    public ISourceFormatter getSourceFormatter(Language lang) {
        try {
            return (ISourceFormatter)this.loadService(lang, FORMATTER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of formatter", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of formatter does not implement ISourceFormatter", e);
        }
        return null;
    }

    public ISourceHyperlinkDetector getSourceHyperlinkDetector(Language lang) {
        try {
            return (ISourceHyperlinkDetector)this.loadService(lang, HYPER_LINK_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of hyperLink", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of hyperLink does not implement ISourceHyperlinkDetector", e);
        }
        return null;
    }

    public ILanguageSyntaxProperties getSyntaxProperties(Language lang) {
        try {
            return (ILanguageSyntaxProperties)this.loadService(lang, SYNTAX_PROPS_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of syntaxProps", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of syntaxProps does not implement ILanguageSyntaxProperties", e);
        }
        return null;
    }

    public IToggleBreakpointsHandler getToggleBreakpointsHandler(Language lang) {
        try {
            return (IToggleBreakpointsHandler)this.loadService(lang, TOGGLE_BREAKPOINTS_HANDLER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of toggleBreakpointHandler", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of toggleBreakpointHandler does not implement IToggleBreakpointsHandler", e);
        }
        return null;
    }

    public ITokenColorer getTokenColorer(Language lang) {
        try {
            return (ITokenColorer)this.loadService(lang, TOKEN_COLORER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of tokenColorer", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of tokenColorer does not implement ITokenColorer", e);
        }
        return null;
    }

    public TreeModelBuilderBase getTreeModelBuilder(Language lang) {
        try {
            return (TreeModelBuilderBase)this.loadService(lang, MODEL_TREE_BUILDER_SERVICE);
        }
        catch (LinkageError e) {
            RuntimePlugin.getInstance().logException("Linkage error attempting to load implementation of modelTreeBuilder", e);
        }
        catch (ClassCastException e) {
            RuntimePlugin.getInstance().logException("Alleged implementation of modelTreeBuilder does not implement TreeModelBuilderBase", e);
        }
        return null;
    }

    private ILanguageService createExtension(Language lang, String id) {
        try {
            return ExtensionFactory.createServiceExtension(lang, id);
        }
        catch (ExtensionException e) {
            RuntimePlugin.getInstance().logException("Failed to create extension: " + id, e);
            return null;
        }
    }

    private Set<ILanguageService> createExtensions(Language lang, String id) {
        try {
            return ExtensionFactory.createServiceExtensionSet(lang, id);
        }
        catch (ExtensionException e) {
            RuntimePlugin.getInstance().logException("Failed to create set of extensions for: " + id, e);
            return new HashSet<ILanguageService>();
        }
    }

    private Set<ILanguageService> loadServices(Language lang, String serviceId) {
        return this.createExtensions(lang, serviceId);
    }

    private ILanguageService loadService(Language lang, String name) {
        if (lang == null) {
            RuntimePlugin.getInstance().writeErrorMsg("Null language for service = " + name);
            return null;
        }
        if (name == null) {
            RuntimePlugin.getInstance().writeErrorMsg("Null service for language = " + lang);
            return null;
        }
        return this.createExtension(lang, name);
    }

    static {
        ALL_SERVICES = new LinkedList<String>();
        Class<ServiceFactory> clazz = ServiceFactory.class;
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.getName().endsWith("_SERVICE") || !Modifier.isStatic(field.getModifiers())) continue;
            try {
                String val = (String)field.get(null);
                ALL_SERVICES.add("org.eclipse.imp.runtime." + val);
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }
}

