/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.model.IPathEntry;
import org.eclipse.imp.model.ISourceEntity;
import org.eclipse.imp.model.ISourceFolder;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.IWorkspaceModel;
import org.eclipse.imp.model.internal.CompilationUnitRef;
import org.eclipse.imp.model.internal.PathEntry;
import org.eclipse.imp.model.internal.SourceFolder;
import org.eclipse.imp.model.internal.SourceProject;
import org.eclipse.imp.model.internal.WorkspaceModel;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;

public class ModelFactory {
    public static final String NO_SUCH_ELEMENT = "No such element: ";
    public static final String ELEMENT_ALREADY_EXISTS = "Element already exists: ";
    private static ModelFactory sInstance = new ModelFactory();
    private IWorkspaceModel fModelRoot = new WorkspaceModel(ResourcesPlugin.getWorkspace().getRoot());
    private Map<IProject, ISourceProject> fProjectMap = new HashMap<IProject, ISourceProject>();
    private Map<Language, IFactoryExtender> fExtenderMap = new HashMap<Language, IFactoryExtender>();

    public static ModelFactory getInstance() {
        return sInstance;
    }

    private ModelFactory() {
    }

    public void installExtender(IFactoryExtender extender, Language language) {
        this.fExtenderMap.put(language, extender);
    }

    public static IWorkspaceModel getModelRoot() {
        return ModelFactory.getInstance().fModelRoot;
    }

    public static ISourceProject getProject(IProject project) {
        return ModelFactory.getInstance().fProjectMap.get(project);
    }

    public static ISourceProject open(IProject project) throws ModelException {
        return ModelFactory.getInstance().doOpen(project);
    }

    private ISourceProject doOpen(IProject project) throws ModelException {
        if (!project.exists()) {
            throw new ModelException(NO_SUCH_ELEMENT);
        }
        ISourceProject sp = this.fProjectMap.get(project);
        if (sp == null) {
            sp = new SourceProject(project);
            this.fProjectMap.put(project, sp);
            try {
                String[] natures = project.getDescription().getNatureIds();
                for (int i = 0; i < natures.length; ++i) {
                    IFactoryExtender ext;
                    String natureID = natures[i];
                    Language lang = LanguageRegistry.findLanguageByNature(natureID);
                    if (lang == null || (ext = this.fExtenderMap.get(lang)) == null) continue;
                    ext.extend(sp);
                }
            }
            catch (CoreException e) {
                ErrorHandler.reportError(e.getMessage());
            }
        }
        return sp;
    }

    public static ISourceProject create(IProject project) throws ModelException {
        return ModelFactory.getInstance().doCreate(project);
    }

    private ISourceProject doCreate(IProject project) throws ModelException {
        throw new ModelException(ELEMENT_ALREADY_EXISTS);
    }

    public static ISourceEntity open(IContainer container) throws ModelException {
        return ModelFactory.getInstance().doOpen(container);
    }

    public static ISourceEntity open(IResource resource) throws ModelException {
        if (resource instanceof IContainer) {
            return ModelFactory.getInstance().doOpen((IContainer)resource);
        }
        if (resource instanceof IFile) {
            ISourceProject srcProject = ModelFactory.getInstance().doOpen(resource.getProject());
            return ModelFactory.getInstance().doOpen((IFile)resource, srcProject);
        }
        return null;
    }

    private ISourceEntity doOpen(IContainer container) throws ModelException {
        if (container instanceof IProject) {
            return this.doOpen((IProject)container);
        }
        if (container instanceof IFolder) {
            return this.doOpen((IFolder)container);
        }
        if (container instanceof IWorkspaceRoot) {
            return this.fModelRoot;
        }
        throw new ModelException("Inappropriate argument type " + container.getClass() + " to ModelFactory.doOpen(IContainer).");
    }

    public static ISourceEntity create(IContainer container) throws ModelException {
        return ModelFactory.getInstance().doCreate(container);
    }

    private ISourceEntity doCreate(IContainer container) throws ModelException {
        if (container instanceof IProject) {
            return this.doCreate((IProject)container);
        }
        if (container instanceof IFolder) {
            return this.doOpen((IFolder)container);
        }
        if (container instanceof IWorkspaceRoot) {
            return this.fModelRoot;
        }
        throw new ModelException("Inappropriate argument type " + container.getClass() + " to ModelFactory.doOpen(IContainer).");
    }

    public static ISourceFolder open(IFolder folder) throws ModelException {
        return ModelFactory.getInstance().doOpen(folder);
    }

    private ISourceFolder doOpen(IFolder folder) throws ModelException {
        if (!folder.exists()) {
            throw new ModelException(NO_SUCH_ELEMENT);
        }
        ISourceProject sp = this.doOpen(folder.getProject());
        SourceFolder sf = new SourceFolder(sp, folder.getProjectRelativePath());
        return sf;
    }

    public static ISourceFolder create(IFolder folder) throws ModelException {
        return ModelFactory.getInstance().doCreate(folder);
    }

    private ISourceFolder doCreate(IFolder folder) throws ModelException {
        ISourceProject sp = this.doOpen(folder.getProject());
        if (!folder.exists()) {
            try {
                folder.create(true, false, null);
            }
            catch (CoreException e) {
                throw new ModelException("Unable to create underlying folder for source folder " + folder.getLocation().toPortableString(), e);
            }
        }
        SourceFolder sf = new SourceFolder(sp, folder.getProjectRelativePath());
        return sf;
    }

    public static ICompilationUnit open(IPath path, ISourceProject srcProject) {
        return ModelFactory.getInstance().doOpen(path, srcProject);
    }

    private ICompilationUnit doOpen(IPath path, ISourceProject srcProject) {
        CompilationUnitRef unit;
        IPath resolvedPath;
        if (path.isAbsolute()) {
            resolvedPath = path;
            unit = new CompilationUnitRef(resolvedPath, null);
        } else {
            resolvedPath = srcProject.resolvePath(path);
            if (resolvedPath == null) {
                return null;
            }
            unit = new CompilationUnitRef(resolvedPath, srcProject);
        }
        Language lang = LanguageRegistry.findLanguage(resolvedPath, null);
        IFactoryExtender ext = this.fExtenderMap.get(lang);
        if (ext != null) {
            ext.extend(unit);
        }
        return unit;
    }

    public static ICompilationUnit open(IFile file, ISourceProject srcProject) {
        return ModelFactory.getInstance().doOpen(file, srcProject);
    }

    private ICompilationUnit doOpen(IFile file, ISourceProject srcProject) {
        if (!file.exists()) {
            return null;
        }
        CompilationUnitRef unit = new CompilationUnitRef(file.getFullPath(), srcProject);
        TextFileDocumentProvider tfdp = new TextFileDocumentProvider();
        IDocument doc = tfdp.getDocument((Object)file);
        Language lang = LanguageRegistry.findLanguage(file.getFullPath(), doc);
        IFactoryExtender ext = this.fExtenderMap.get(lang);
        if (ext != null) {
            ext.extend(unit);
        }
        return unit;
    }

    public static ICompilationUnit create(IPath projRelPath, ISourceProject srcProject) throws ModelException {
        return ModelFactory.getInstance().doCreate(projRelPath, srcProject);
    }

    private ICompilationUnit doCreate(IPath projRelPath, ISourceProject srcProject) throws ModelException {
        throw new ModelException(ELEMENT_ALREADY_EXISTS);
    }

    public static ICompilationUnit create(IFile file, ISourceProject srcProject) throws ModelException {
        return ModelFactory.getInstance().doCreate(file, srcProject);
    }

    private ICompilationUnit doCreate(IFile file, ISourceProject srcProject) throws ModelException {
        return this.doCreate(file.getProjectRelativePath(), srcProject);
    }

    public static IPathEntry createPathEntry(IPathEntry.PathEntryType type, IPath path) {
        return new PathEntry(type, path);
    }

    public static interface IFactoryExtender {
        public void extend(ISourceProject var1);

        public void extend(ICompilationUnit var1);
    }

    public class ModelException
    extends Exception {
        private static final long serialVersionUID = -1051581958821533299L;

        public ModelException() {
        }

        public ModelException(String message) {
            super(message);
        }

        public ModelException(String message, Throwable cause) {
            super(message, cause);
        }

        public ModelException(Throwable cause) {
            super(cause);
        }
    }
}

