/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.parser;

import java.util.Iterator;
import lpg.runtime.ILexStream;
import lpg.runtime.IMessageHandler;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import lpg.runtime.Monitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.parser.ILexer;
import org.eclipse.imp.parser.IParser;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.parser.LPGSourcePositionLocator;
import org.eclipse.imp.parser.MessageHandlerAdapter;
import org.eclipse.imp.parser.ParseControllerBase;
import org.eclipse.imp.parser.SimpleAnnotationTypeInfo;
import org.eclipse.imp.services.IAnnotationTypeInfo;
import org.eclipse.jface.text.IRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleLPGParseController
extends ParseControllerBase {
    private boolean[] fIsKeyword;
    protected IParser fParser;
    protected ILexer fLexer;
    protected ILexStream fLexStream;
    protected IPrsStream fParseStream;
    protected ISourcePositionLocator fSourcePositionLocator;
    private final SimpleAnnotationTypeInfo fSimpleAnnotationTypeInfo = new SimpleAnnotationTypeInfo();

    public SimpleLPGParseController(String languageID) {
        super(languageID);
    }

    public SimpleLPGParseController() {
    }

    public IParser getParser() {
        return this.fParser;
    }

    public ILexer getLexer() {
        return this.fLexer;
    }

    public ILexStream getLexStream() {
        return this.fLexStream;
    }

    public IPrsStream getParseStream() {
        return this.fParseStream;
    }

    @Override
    public ISourcePositionLocator getSourcePositionLocator() {
        if (this.fSourcePositionLocator == null) {
            this.fSourcePositionLocator = new LPGSourcePositionLocator(this);
        }
        return this.fSourcePositionLocator;
    }

    @Override
    public Object parse(String contents, IProgressMonitor monitor) {
        PMMonitor my_monitor = new PMMonitor(monitor);
        char[] contentsArray = contents.toCharArray();
        this.fLexer.reset(contentsArray, this.fFilePath != null ? this.fFilePath.toPortableString() : null);
        this.fLexStream = this.fLexer.getILexStream();
        this.fParser.reset(this.fLexStream);
        this.fParseStream = this.fParser.getIPrsStream();
        this.fParseStream.setMessageHandler((IMessageHandler)new MessageHandlerAdapter(this.handler));
        this.fLexer.lexer(my_monitor, this.fParseStream);
        if (my_monitor.isCancelled()) {
            return this.fCurrentAst;
        }
        this.fCurrentAst = this.fParser.parser(my_monitor, 0);
        this.cacheKeywordsOnce();
        return this.fCurrentAst;
    }

    @Override
    public Iterator<IToken> getTokenIterator(IRegion region) {
        final int regionOffset = region.getOffset();
        int regionLength = region.getLength();
        final int regionEnd = regionOffset + regionLength - 1;
        return new Iterator<IToken>(){
            final IPrsStream stream;
            final int firstTokIdx;
            final int lastTokIdx;
            int curTokIdx;
            IToken[][] precedingAdjuncts;
            int[] nextPrecedingAdjunct;
            IToken[] followingAdjuncts;
            int nextFollowingAdjunct;
            private boolean finalTokenReturned;
            private boolean finalAdjunctsReturned;
            {
                int i;
                this.stream = SimpleLPGParseController.this.getParseStream();
                this.firstTokIdx = this.getTokenIndexAtCharacter(regionOffset);
                int endIdx = this.getTokenIndexAtCharacter(regionEnd);
                char[] streamChars = this.stream.getInputChars();
                int streamLen = streamChars.length;
                try {
                    if (regionEnd >= 1 && regionEnd < streamLen && streamChars[regionEnd] == '\uffff') {
                        --endIdx;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ErrorHandler.logError("SimpleLPGParseController.getTokenIterator(IRegion):  error initializing lastTokIdx", e);
                }
                this.lastTokIdx = endIdx;
                this.curTokIdx = Math.max(1, this.firstTokIdx);
                this.precedingAdjuncts = new IToken[this.lastTokIdx + 1][];
                this.stream.setStreamLength();
                for (i = 0; i < this.precedingAdjuncts.length; ++i) {
                    this.precedingAdjuncts[i] = this.stream.getPrecedingAdjuncts(i);
                }
                this.nextPrecedingAdjunct = new int[this.lastTokIdx + 1];
                for (i = 0; i < this.nextPrecedingAdjunct.length; ++i) {
                    this.nextPrecedingAdjunct[i] = this.precedingAdjuncts[i].length == 0 ? -1 : 0;
                }
                this.followingAdjuncts = this.lastTokIdx <= 0 ? new IToken[0] : this.stream.getFollowingAdjuncts(this.lastTokIdx);
                this.nextFollowingAdjunct = this.followingAdjuncts.length == 0 ? -1 : 0;
                this.finalTokenReturned = regionEnd < 1 || this.lastTokIdx <= 0;
                this.finalAdjunctsReturned = this.followingAdjuncts.length <= 0;
            }

            private int getTokenIndexAtCharacter(int offset) {
                int result = this.stream.getTokenIndexAtCharacter(offset);
                if (result < 0) {
                    result = -result + 1;
                }
                if (result >= this.stream.getTokens().size()) {
                    result = this.stream.getTokens().size() - 1;
                }
                return result;
            }

            @Override
            public boolean hasNext() {
                return !this.finalTokenReturned || !this.finalAdjunctsReturned;
            }

            @Override
            public IToken next() {
                int next = -1;
                if (this.curTokIdx <= this.lastTokIdx) {
                    next = this.nextPrecedingAdjunct[this.curTokIdx];
                    if (next >= 0 && next < this.precedingAdjuncts[this.curTokIdx].length) {
                        int n = this.curTokIdx;
                        int n2 = this.nextPrecedingAdjunct[n];
                        this.nextPrecedingAdjunct[n] = n2 + 1;
                        return this.precedingAdjuncts[this.curTokIdx][n2];
                    }
                    this.finalTokenReturned = this.curTokIdx >= this.lastTokIdx;
                    return this.stream.getIToken(this.curTokIdx++);
                }
                if (this.nextFollowingAdjunct >= 0 && this.nextFollowingAdjunct < this.followingAdjuncts.length) {
                    this.finalAdjunctsReturned = this.nextFollowingAdjunct + 1 >= this.followingAdjuncts.length;
                    return this.followingAdjuncts[this.nextFollowingAdjunct++];
                }
                return null;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("Unimplemented");
            }
        };
    }

    @Override
    public IAnnotationTypeInfo getAnnotationTypeInfo() {
        return this.fSimpleAnnotationTypeInfo;
    }

    public boolean isKeyword(int kind) {
        return kind >= 0 && kind < this.fIsKeyword.length && this.fIsKeyword[kind];
    }

    protected void cacheKeywordsOnce() {
        if (this.fIsKeyword == null) {
            IParser parser = this.getParser();
            String[] tokenKindNames = parser.orderedTerminalSymbols();
            this.fIsKeyword = new boolean[tokenKindNames.length];
            int[] keywordKinds = this.getLexer().getKeywordKinds();
            if (keywordKinds != null) {
                for (int i = 1; i < keywordKinds.length; ++i) {
                    int index = parser.getIPrsStream().mapKind(keywordKinds[i]);
                    this.fIsKeyword[index] = true;
                }
            }
        }
    }

    protected class PMMonitor
    implements Monitor {
        private IProgressMonitor monitor;
        private boolean wasCancelled = false;

        public PMMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean isCancelled() {
            if (!this.wasCancelled && this.monitor != null) {
                this.wasCancelled = this.monitor.isCanceled();
            }
            return this.wasCancelled;
        }

        public void setMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }
    }
}

