/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.runtime;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.osgi.framework.Bundle;

public class PluginImages {
    private static ImageRegistry fgImageRegistry = null;
    private static Map<String, ImageDescriptor> fgAvoidSWTErrorMap = null;
    public static final IPath ICONS_PATH = new Path("/icons");
    private static final String NAME_PREFIX = "";
    private static final int NAME_PREFIX_LENGTH = "".length();
    private static final String ENABLED_PREFIX = "enabled";
    private static final String DISABLED_PREFIX = "disabled";
    private static final String CORRECTION_PREFIX = "correction";
    public static final String VIEW_MENU_IMAGE = "view_menu.gif";
    public static final ImageDescriptor viewMenuImageDesc = PluginImages.createManaged("", "view_menu.gif");
    public static final String FILE_IMAGE = "file.gif";
    public static final ImageDescriptor fileImageDesc = PluginImages.createManaged("", "file.gif");
    public static final String FOLDER_IMAGE = "folder.gif";
    public static final ImageDescriptor folderImageDesc = PluginImages.createManaged("", "folder.gif");
    public static final String PROJECT_IMAGE = "project.gif";
    public static final ImageDescriptor projectImageDesc = PluginImages.createManaged("", "project.gif");
    public static final String IMG_OBJS_QUICK_ASSIST = "quickassist_obj.gif";
    public static final String IMG_OBJS_QUICK_FIX = "quickfix_obj.gif";
    public static final String IMG_OBJS_FIXABLE_PROBLEM = "quickfix_warning_obj.gif";
    public static final String IMG_OBJS_FIXABLE_ERROR = "quickfix_error_obj.gif";
    public static final ImageDescriptor DESC_OBJS_QUICK_ASSIST = PluginImages.createManaged("", "quickassist_obj.gif");
    public static final ImageDescriptor DESC_OBJS_QUICK_FIX = PluginImages.createManaged("", "quickfix_obj.gif");
    public static final ImageDescriptor DESC_OBJS_FIXABLE_PROBLEM = PluginImages.createManaged("", "quickfix_warning_obj.gif");
    public static final ImageDescriptor DESC_OBJS_FIXABLE_ERROR = PluginImages.createManaged("", "quickfix_error_obj.gif");
    public static final ImageDescriptor DESC_DLCL_CONFIGURE_ANNOTATIONS = PluginImages.createUnManaged("disabled", "configure_annotations.gif");
    public static final ImageDescriptor DESC_ELCL_CONFIGURE_ANNOTATIONS = PluginImages.createUnManaged("enabled", "configure_annotations.gif");
    public static final ImageDescriptor DESC_DLCL_CONFIGURE_PROBLEM_SEVERITIES = PluginImages.createUnManaged("disabled", "configure_problem_severity.gif");
    public static final ImageDescriptor DESC_ELCL_CONFIGURE_PROBLEM_SEVERITIES = PluginImages.createUnManaged("enabled", "configure_problem_severity.gif");
    public static final String IMG_CORRECTION_CHANGE = "correction_change.gif";
    public static final String IMG_CORRECTION_MOVE = "correction_move.gif";
    public static final String IMG_CORRECTION_RENAME = "correction_rename.gif";
    public static final String IMG_CORRECTION_LINKED_RENAME = "correction_linked_rename.gif";
    public static final String IMG_CORRECTION_DELETE_IMPORT = "correction_delete_import.gif";
    public static final String IMG_CORRECTION_LOCAL = "localvariable_obj.gif";
    public static final String IMG_CORRECTION_REMOVE = "remove_correction.gif";
    public static final String IMG_CORRECTION_ADD = "add_correction.gif";
    public static final String IMG_CORRECTION_CAST = "correction_cast.gif";
    public static final ImageDescriptor DESC_OVR_WARNING;
    public static final ImageDescriptor DESC_OVR_ERROR;

    public static Image get(String key) {
        return PluginImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getDescriptor(String key) {
        if (fgImageRegistry == null) {
            return fgAvoidSWTErrorMap.get(key);
        }
        return PluginImages.getImageRegistry().getDescriptor(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        PluginImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        PluginImages.setImageDescriptors(action, "lcl16", iconName);
    }

    static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry();
            for (String key : fgAvoidSWTErrorMap.keySet()) {
                fgImageRegistry.put(key, fgAvoidSWTErrorMap.get(key));
            }
            fgAvoidSWTErrorMap = null;
        }
        return fgImageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id = PluginImages.create("d" + type, relPath, false);
        if (id != null) {
            action.setDisabledImageDescriptor(id);
        }
        ImageDescriptor descriptor = PluginImages.create("e" + type, relPath);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        ImageDescriptor result = PluginImages.create(prefix, name.substring(NAME_PREFIX_LENGTH), true);
        if (fgAvoidSWTErrorMap == null) {
            fgAvoidSWTErrorMap = new HashMap<String, ImageDescriptor>();
        }
        fgAvoidSWTErrorMap.put(name, result);
        if (fgImageRegistry != null) {
            RuntimePlugin.getInstance().writeErrorMsg("Image registry already defined");
        }
        return result;
    }

    private static ImageDescriptor createManaged(String prefix, String name, String key) {
        ImageDescriptor result = PluginImages.create(prefix, name.substring(NAME_PREFIX_LENGTH), true);
        if (fgAvoidSWTErrorMap == null) {
            fgAvoidSWTErrorMap = new HashMap<String, ImageDescriptor>();
        }
        fgAvoidSWTErrorMap.put(key, result);
        if (fgImageRegistry != null) {
            RuntimePlugin.getInstance().writeErrorMsg("Image registry already defined");
        }
        return result;
    }

    private static ImageDescriptor createUnManaged(String prefix, String name) {
        return PluginImages.create(prefix, name, true);
    }

    private static ImageDescriptor createUnManagedCached(String prefix, String name) {
        return new CachedImageDescriptor(PluginImages.create(prefix, name, true));
    }

    private static ImageDescriptor create(String prefix, String name, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(prefix).append(name);
        return PluginImages.createImageDescriptor(RuntimePlugin.getInstance().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor create(String prefix, String name) {
        return PluginImages.create(prefix, name, true);
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    static {
        PluginImages.createManaged(CORRECTION_PREFIX, IMG_CORRECTION_CHANGE);
        PluginImages.createManaged(CORRECTION_PREFIX, IMG_CORRECTION_MOVE);
        PluginImages.createManaged(CORRECTION_PREFIX, IMG_CORRECTION_RENAME);
        PluginImages.createManaged(CORRECTION_PREFIX, IMG_CORRECTION_LINKED_RENAME);
        PluginImages.createManaged(CORRECTION_PREFIX, IMG_CORRECTION_DELETE_IMPORT);
        PluginImages.createManaged(CORRECTION_PREFIX, IMG_CORRECTION_LOCAL);
        PluginImages.createManaged(CORRECTION_PREFIX, IMG_CORRECTION_REMOVE);
        PluginImages.createManaged(CORRECTION_PREFIX, IMG_CORRECTION_ADD);
        PluginImages.createManaged(CORRECTION_PREFIX, IMG_CORRECTION_CAST);
        DESC_OVR_WARNING = PluginImages.createUnManagedCached(NAME_PREFIX, "warning_co.gif");
        DESC_OVR_ERROR = PluginImages.createUnManagedCached(NAME_PREFIX, "error_co.gif");
    }

    private static final class CachedImageDescriptor
    extends ImageDescriptor {
        private ImageDescriptor fDescriptor;
        private ImageData fData;

        public CachedImageDescriptor(ImageDescriptor descriptor) {
            this.fDescriptor = descriptor;
        }

        public ImageData getImageData() {
            if (this.fData == null) {
                this.fData = this.fDescriptor.getImageData();
            }
            return this.fData;
        }
    }
}

