/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.runtime;

import java.io.PrintStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.model.ISourceEntity;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.preferences.PreferenceCache;
import org.eclipse.imp.runtime.ImageDescriptorRegistry;
import org.eclipse.imp.runtime.PluginBase;
import org.eclipse.imp.utils.ConsoleUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class RuntimePlugin
extends PluginBase
implements IStartup {
    private static final String CONSOLE_NAME = "IMP Runtime";
    public static final String IMP_RUNTIME = "org.eclipse.imp.runtime";
    public static String LANGUAGE_DESCRIPTOR = "languageDescription";
    private static RuntimePlugin sPlugin;
    private static boolean EMIT_TIMING_INFO;
    public static long PRE_STARTUP_TIME;
    public static long EDITOR_START_TIME;
    public static String SOURCE_EDITOR_SCOPE;
    private FontRegistry fFontRegistry;
    private PrintStream sConsoleStream;
    private ImageDescriptorRegistry fImageDescriptorRegistry;

    public RuntimePlugin() {
        sPlugin = this;
    }

    public static RuntimePlugin getInstance() {
        return sPlugin;
    }

    public String getID() {
        return IMP_RUNTIME;
    }

    public String getLanguageID() {
        return "IMP";
    }

    public FontRegistry getFontRegistry() {
        if (this.fFontRegistry == null) {
            this.fFontRegistry = new FontRegistry();
        }
        return this.fFontRegistry;
    }

    public void start(BundleContext context) throws Exception {
        PRE_STARTUP_TIME = System.currentTimeMillis();
        super.start(context);
        if (EMIT_TIMING_INFO) {
            this.getConsoleStream().println("Entered RuntimePlugin.start(); time is " + PRE_STARTUP_TIME);
        }
        IPreferenceStore prefStore = this.getPreferenceStore();
        PreferenceCache.emitMessages = prefStore.getBoolean("emitMessages");
        PreferenceCache.tabWidth = prefStore.getInt("tabWidth");
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)new ResourceToSourceEntityAdapter(), IResource.class);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        sPlugin = null;
    }

    public PrintStream getConsoleStream() {
        if (this.sConsoleStream == null) {
            this.sConsoleStream = ConsoleUtil.findConsoleStream(CONSOLE_NAME);
        }
        return this.sConsoleStream;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)IMP_RUNTIME, (String)path);
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return RuntimePlugin.getInstance().internalGetImageDescriptorRegistry();
    }

    public void earlyStartup() {
        if (EMIT_TIMING_INFO) {
            long curTime = System.currentTimeMillis();
            this.getConsoleStream().println("Entered RuntimePlugin.earlyStartup(); time is " + curTime);
        }
        LanguageRegistry.startup();
    }

    static {
        EMIT_TIMING_INFO = false;
        SOURCE_EDITOR_SCOPE = "org.eclipse.imp.runtime.sourceEditorScope";
    }

    private static final class ResourceToSourceEntityAdapter
    implements IAdapterFactory {
        private Class[] fTypes = new Class[]{ISourceEntity.class};

        private ResourceToSourceEntityAdapter() {
        }

        public Object getAdapter(Object adaptableObject, Class adapterType) {
            if (adaptableObject instanceof IResource && adapterType == ISourceEntity.class) {
                try {
                    return ModelFactory.open((IResource)adaptableObject);
                }
                catch (ModelFactory.ModelException e) {
                    RuntimePlugin.getInstance().logException("Unable to adapt " + adaptableObject.getClass().getName() + " to " + adapterType.getName(), e);
                }
            }
            return null;
        }

        public Class[] getAdapterList() {
            return this.fTypes;
        }
    }
}

