/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.services.base;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lpg.runtime.Adjunct;
import lpg.runtime.IAst;
import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import org.eclipse.imp.parser.SimpleLPGParseController;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.base.FolderBase;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LPGFolderBase
extends FolderBase {
    protected IPrsStream prsStream;

    @Override
    protected void sendVisitorToAST(HashMap<Annotation, Position> newAnnotations, List<Annotation> annotations, Object ast) {
        if (this.fDebugMode) {
            PrintStream cons = RuntimePlugin.getInstance().getConsoleStream();
            SimpleLPGParseController lpgPC = (SimpleLPGParseController)this.parseController;
            ILexStream ls = lpgPC.getLexStream();
            cons.println("Stream length = " + ls.getStreamLength() + ", # lines = " + ls.getLineCount());
        }
    }

    @Override
    public void makeAnnotation(int start, int len) {
        if (this.fDebugMode) {
            PrintStream cons = RuntimePlugin.getInstance().getConsoleStream();
            ILexStream lexStream = this.prsStream.getILexStream();
            int end = start + len - 1;
            int first_line = lexStream.getLineNumberOfCharAt(start);
            int first_col = lexStream.getColumnOfCharAt(start);
            int last_line = lexStream.getLineNumberOfCharAt(end);
            int last_col = lexStream.getColumnOfCharAt(end);
            cons.println("Folding <line " + first_line + ", col " + first_col + " '" + lexStream.getCharValue(start) + "'> -> " + "<line " + last_line + ", col " + last_col + " '" + (end >= lexStream.getStreamLength() ? "<EOF>" : Character.valueOf(lexStream.getCharValue(end))) + "'>");
        }
        super.makeAnnotation(start, len);
    }

    protected void makeFoldableByOffsets(int first_offset, int last_offset) {
        this.makeAnnotation(first_offset, last_offset - first_offset + 1);
    }

    protected void makeFoldable(IToken first_token, IToken last_token) {
        if (last_token.getEndLine() > first_token.getLine()) {
            ILexStream lexStream = this.prsStream.getILexStream();
            int start = first_token.getStartOffset();
            int end = last_token.getEndOffset();
            if (end <= start) {
                return;
            }
            int startLine = lexStream.getLineNumberOfCharAt(start);
            int endLine = lexStream.getLineNumberOfCharAt(end);
            int startLineOffset = lexStream.getLineOffset(startLine);
            int endLineOffset = lexStream.getLineOffset(endLine + 1) + 1;
            this.makeFoldableByOffsets(startLineOffset, endLineOffset);
        }
    }

    protected boolean isWhiteNotLineTerm(char ch) {
        return Character.isWhitespace(ch) && ch != '\n' && ch != '\r' && ch != '\f';
    }

    protected void makeFoldable(IAst n) {
        if (this.fDebugMode) {
            PrintStream cons = RuntimePlugin.getInstance().getConsoleStream();
            cons.println("Folding node of type " + n.getClass());
        }
        this.makeFoldable(n.getLeftIToken(), n.getRightIToken());
    }

    protected void makeAdjunctsFoldable() {
        IToken[] comments;
        ILexStream lexStream = this.prsStream.getILexStream();
        if (lexStream == null) {
            return;
        }
        ArrayList adjuncts = this.prsStream.getAdjuncts();
        for (int i = 0; i < adjuncts.size(); i += comments.length) {
            Adjunct adjunct = (Adjunct)adjuncts.get(i);
            IToken previous_token = this.prsStream.getIToken(adjunct.getTokenIndex());
            IToken next_token = this.prsStream.getIToken(this.prsStream.getNext(previous_token.getTokenIndex()));
            comments = previous_token.getFollowingAdjuncts();
            for (int k = 0; k < comments.length; ++k) {
                Adjunct comment = (Adjunct)comments[k];
                if (comment.getEndLine() <= comment.getLine()) continue;
                IToken gate_token = k + 1 < comments.length ? comments[k + 1] : next_token;
                this.makeFoldableByOffsets(comment.getStartOffset(), gate_token.getLine() > comment.getEndLine() ? lexStream.getLineOffset(gate_token.getLine() - 1) : comment.getEndOffset());
            }
        }
    }
}

