/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.services.base;

import java.util.LinkedList;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.ILanguageSyntaxProperties;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public abstract class LanguageSyntaxPropertiesBase
implements ILanguageSyntaxProperties {
    public int[] getIdentifierComponents(String ident2) {
        LinkedList<Integer> listResult = new LinkedList<Integer>();
        for (int i = 0; i < ident2.length(); ++i) {
            if (i <= 0 || (!Character.isLowerCase(ident2.charAt(i - 1)) || !Character.isUpperCase(ident2.charAt(i))) && ident2.charAt(i) != '_') continue;
            listResult.add(i);
        }
        int[] result = new int[listResult.size()];
        int i = 0;
        for (Integer idx : listResult) {
            result[i++] = idx;
        }
        return result;
    }

    public String getIdentifierConstituentChars() {
        return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
    }

    public boolean isIdentifierStart(char ch) {
        return Character.isLetter(ch);
    }

    public boolean isIdentifierPart(char ch) {
        return this.getIdentifierConstituentChars().indexOf(ch) >= 0;
    }

    public boolean isWhitespace(char ch) {
        return Character.isWhitespace(ch);
    }

    public String[][] getFences() {
        return new String[][]{{"'", "'"}, {"\"", "\""}, {"(", ")"}, {"[", "]"}, {"{", "}"}};
    }

    public IRegion getDoubleClickRegion(int offset, IParseController pc) {
        return new Region(offset, 1);
    }
}

