/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.imp.editor.quickfix.IAnnotation;
import org.eclipse.imp.utils.HTMLPrinter;
import org.eclipse.imp.utils.IPositionPredicate;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.ui.texteditor.MarkerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtils {
    private static Set<String> sAnnotationTypesToFilter = new HashSet<String>();

    private AnnotationUtils() {
    }

    public static String formatAnnotationList(List<Annotation> annotations) {
        if (annotations != null) {
            if (annotations.size() == 1) {
                Annotation annotation = annotations.get(0);
                String message = annotation.getText();
                if (message != null && message.trim().length() > 0) {
                    return HTMLPrinter.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>();
                for (Annotation annotation : annotations) {
                    String message = annotation.getText();
                    if (message == null || message.trim().length() <= 0) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return HTMLPrinter.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return HTMLPrinter.formatMultipleMessages(messages);
                }
            }
        }
        return null;
    }

    public static boolean addAndCheckDuplicateAnnotation(Map<Integer, List<Object>> map, Annotation annotation, Position position) {
        List<Object> annotationsAtPosition;
        if (!map.containsKey(position.offset)) {
            annotationsAtPosition = new ArrayList();
            map.put(position.offset, annotationsAtPosition);
        } else {
            annotationsAtPosition = map.get(position.offset);
        }
        Integer errorCode = -1;
        if (annotation instanceof IAnnotation) {
            errorCode = ((IAnnotation)annotation).getId();
        } else if (annotation instanceof MarkerAnnotation) {
            errorCode = ((MarkerAnnotation)annotation).getMarker().getAttribute("errorCode", -1);
        }
        if (errorCode == -1) {
            if (!annotationsAtPosition.contains(annotation.getText())) {
                annotationsAtPosition.add(annotation.getText());
                return false;
            }
        } else if (!annotationsAtPosition.contains(errorCode)) {
            annotationsAtPosition.add(errorCode);
            return false;
        }
        return true;
    }

    public static List<Annotation> getAnnotationsForLine(ISourceViewer viewer, final int line) {
        final IDocument document = viewer.getDocument();
        IPositionPredicate posPred = new IPositionPredicate(){

            public boolean matchPosition(Position p) {
                return AnnotationUtils.offsetIsAtLine(p, document, line);
            }
        };
        return AnnotationUtils.getAnnotations(viewer, posPred);
    }

    public static List<Annotation> getAnnotationsForOffset(ISourceViewer viewer, final int offset) {
        IPositionPredicate posPred = new IPositionPredicate(){

            public boolean matchPosition(Position p) {
                return offset >= p.offset && offset < p.offset + p.length;
            }
        };
        return AnnotationUtils.getAnnotations(viewer, posPred);
    }

    public static boolean offsetIsAtLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                int posLine = document.getLineOfOffset(position.getOffset());
                return line == posLine;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    public static IAnnotationModel getAnnotationModel(ISourceViewer viewer) {
        return viewer.getAnnotationModel();
    }

    public static List<Annotation> getAnnotations(ISourceViewer viewer, IPositionPredicate posPred) {
        IAnnotationModel model = AnnotationUtils.getAnnotationModel(viewer);
        if (model == null) {
            return null;
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Iterator iterator = model.getAnnotationIterator();
        HashMap<Integer, List<Object>> map = new HashMap<Integer, List<Object>>();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            Position position = model.getPosition(annotation);
            if (position == null || !posPred.matchPosition(position)) continue;
            if (annotation instanceof AnnotationBag) {
                AnnotationBag bag = (AnnotationBag)annotation;
                for (Annotation bagAnnotation : bag) {
                    position = model.getPosition(bagAnnotation);
                    if (position == null || !AnnotationUtils.includeAnnotation(bagAnnotation, position) || AnnotationUtils.addAndCheckDuplicateAnnotation(map, bagAnnotation, position)) continue;
                    annotations.add(bagAnnotation);
                }
                continue;
            }
            if (!AnnotationUtils.includeAnnotation(annotation, position) || AnnotationUtils.addAndCheckDuplicateAnnotation(map, annotation, position)) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    private static boolean includeAnnotation(Annotation annotation, Position position) {
        return !sAnnotationTypesToFilter.contains(annotation.getType());
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List<Annotation> annotations = AnnotationUtils.getAnnotationsForLine(sourceViewer, lineNumber);
        return AnnotationUtils.formatAnnotationList(annotations);
    }

    static {
        sAnnotationTypesToFilter.add("org.eclipse.ui.workbench.texteditor.quickdiffUnchanged");
        sAnnotationTypesToFilter.add("org.eclipse.ui.workbench.texteditor.quickdiffChange");
        sAnnotationTypesToFilter.add("org.eclipse.ui.workbench.texteditor.quickdiffAddition");
        sAnnotationTypesToFilter.add("org.eclipse.ui.workbench.texteditor.quickdiffDeletion");
        sAnnotationTypesToFilter.add("org.eclipse.debug.core.breakpoint");
        sAnnotationTypesToFilter.add("org.eclipse.imp.runtime.occurrenceAnnotation");
        sAnnotationTypesToFilter.add("org.eclipse.projection");
    }
}

