/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.utils;

import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleUtil {
    public static MessageConsole findConsole(String name) {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = consoleManager.getConsoles();
        for (int i = 0; i < consoles.length; ++i) {
            IConsole console = consoles[i];
            if (!console.getName().equals(name)) continue;
            return (MessageConsole)console;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        consoleManager.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public static MessageConsole findAndShowConsole(String name) {
        MessageConsole console = ConsoleUtil.findConsole(name);
        ConsoleUtil.showConsole(console);
        return console;
    }

    public static PrintStream getPrintStreamFor(MessageConsole console) {
        MessageConsoleStream consStream = console.newMessageStream();
        PrintStream ps = new PrintStream((OutputStream)consStream);
        return ps;
    }

    public static PrintStream findConsoleStream(String name) {
        MessageConsole myConsole = ConsoleUtil.findConsole(name);
        return ConsoleUtil.getPrintStreamFor(myConsole);
    }

    public static void showConsole(MessageConsole console) {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        consoleManager.showConsoleView((IConsole)console);
    }
}

