/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.editor.EditorUtility;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class MarkerUtils {
    private MarkerUtils() {
    }

    public static int getMaxProblemMarkerSeverity(IResource res, int depth) {
        if (res == null || !res.isAccessible()) {
            return 0;
        }
        boolean hasWarnings = false;
        IMarker[] markers = null;
        try {
            markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        }
        catch (CoreException e) {
            RuntimePlugin.getInstance().logException("Error obtaining markers on resource " + res.getName(), e);
        }
        if (markers == null) {
            return 0;
        }
        for (int i = 0; i < markers.length; ++i) {
            IMarker m = markers[i];
            int priority = m.getAttribute("severity", -1);
            if (priority == 1) {
                hasWarnings = true;
                continue;
            }
            if (priority != 2) continue;
            return 2;
        }
        return hasWarnings ? 1 : 0;
    }

    public static Language getLanguage(IMarker marker) {
        try {
            IFileEditorInput input = MarkerUtils.getInput(marker);
            if (input != null) {
                return LanguageRegistry.findLanguage(input.getFile().getFullPath(), EditorUtility.getDocument(input));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static IFileEditorInput getInput(IMarker marker) {
        IResource res = marker.getResource();
        if (res instanceof IFile && res.isAccessible()) {
            IFile file = (IFile)res;
            return new FileEditorInput(file);
        }
        return null;
    }
}

