/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.utils.MessageInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SavingMessageHandler
implements IMessageHandler {
    private final List<MessageInfo> fMessages = new ArrayList<MessageInfo>();

    @Override
    public void clearMessages() {
        this.fMessages.clear();
    }

    @Override
    public void endMessageGroup() {
    }

    @Override
    public void startMessageGroup(String groupName) {
    }

    @Override
    public void endMessages() {
    }

    @Override
    public void handleSimpleMessage(String msg, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine) {
        this.fMessages.add(new MessageInfo(0, msg, startOffset, endOffset, startCol, endCol, startLine, endLine));
    }

    @Override
    public void handleSimpleMessage(String msg, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine, Map<String, Object> attributes) {
        Object severityValue = attributes.get("severity");
        int severity = severityValue instanceof Integer ? (Integer)severityValue : 0;
        this.fMessages.add(new MessageInfo(severity, msg, startOffset, endOffset, startCol, endCol, startLine, endLine));
    }

    public List<MessageInfo> getMessages() {
        return Collections.unmodifiableList(this.fMessages);
    }

    public String getConcatenatedMessages() {
        StringBuilder sb = new StringBuilder();
        for (MessageInfo info : this.getMessages()) {
            sb.append("Line " + info.fStartLine + ", column " + info.fStartCol + ": " + info.fMessage + "\n");
        }
        return sb.toString();
    }
}

