/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.box.builders;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.box.Activator;
import org.eclipse.imp.box.interpreter.BoxInterpreter;
import org.eclipse.imp.box.parser.Ast.IBox;
import org.eclipse.imp.box.parser.BoxParseController;
import org.eclipse.imp.builder.BuilderBase;
import org.eclipse.imp.builder.BuilderUtils;
import org.eclipse.imp.builder.MarkerCreator;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.runtime.PluginBase;
import org.eclipse.ui.console.MessageConsoleStream;

public class BoxBuilder
extends BuilderBase {
    public static final String BUILDER_ID = "org.eclipse.imp.box.builder";
    public static final String PROBLEM_MARKER_ID = "org.eclipse.imp.box.problem";
    public static final String LANGUAGE_NAME = "Box";
    public static final Language LANGUAGE = LanguageRegistry.findLanguage((String)"Box");

    protected PluginBase getPlugin() {
        return Activator.getInstance();
    }

    protected String getErrorMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected String getWarningMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected String getInfoMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected boolean isSourceFile(IFile file) {
        IPath path = file.getRawLocation();
        if (path == null) {
            return false;
        }
        String pathString = path.toString();
        if (pathString.indexOf("/bin/") != -1) {
            return false;
        }
        return LANGUAGE.hasExtension(path.getFileExtension());
    }

    protected boolean isNonRootSourceFile(IFile resource) {
        return false;
    }

    protected void collectDependencies(IFile file) {
    }

    protected boolean isOutputFolder(IResource resource) {
        return resource.getFullPath().lastSegment().equals("bin");
    }

    protected String getConsoleName() {
        return "Box Console";
    }

    protected void compile(IFile file, IProgressMonitor monitor) {
        IBox boxProg = this.parseAndCreateMarkers(file, monitor);
        if (boxProg != null) {
            try {
                BoxInterpreter bi = new BoxInterpreter();
                String result = bi.interpret(boxProg);
                MessageConsoleStream mcs = this.getConsoleStream();
                PrintStream ps = new PrintStream((OutputStream)mcs);
                mcs.getConsole().clearConsole();
                ps.println(result);
                IPath filePath = file.getFullPath();
                IPath outPath = filePath.removeFileExtension().addFileExtension("txt");
                IFile outFile = file.getWorkspace().getRoot().getFile(outPath);
                if (outFile.exists()) {
                    outFile.setContents((InputStream)new StringBufferInputStream(result), true, false, monitor);
                } else {
                    outFile.create((InputStream)new StringBufferInputStream(result), true, monitor);
                }
                this.doRefresh((IResource)file.getParent());
            }
            catch (Exception e) {
                this.getPlugin().logException("Error while interpreting Box program", (Throwable)e);
            }
        }
    }

    protected IBox parseAndCreateMarkers(IFile file, IProgressMonitor monitor) {
        try {
            BoxParseController parseController = new BoxParseController();
            MarkerCreator markerCreator = new MarkerCreator(file, PROBLEM_MARKER_ID);
            ISourceProject sourceProject = ModelFactory.open((IProject)file.getProject());
            String contents = BuilderUtils.getFileContents((IFile)file);
            parseController.initialize(file.getProjectRelativePath(), sourceProject, (IMessageHandler)markerCreator);
            return (IBox)parseController.parse(contents, monitor);
        }
        catch (Exception e) {
            this.getPlugin().logException("Exception encountered while parsing Box program", (Throwable)e);
            return null;
        }
    }
}

