/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.box.parser;

import java.io.IOException;
import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.LexParser;
import lpg.runtime.LpgLexStream;
import lpg.runtime.Monitor;
import lpg.runtime.ParseTable;
import lpg.runtime.RuleAction;
import org.eclipse.imp.box.parser.BoxLexerprs;
import org.eclipse.imp.box.parser.BoxParsersym;
import org.eclipse.imp.parser.ILexer;

public class BoxLexer
implements RuleAction,
ILexer {
    private BoxLexerLpgLexStream lexStream;
    private static ParseTable prs = new BoxLexerprs();
    private LexParser lexParser = new LexParser();
    NoKWLexer kwLexer;
    boolean printTokens;
    private static final int ECLIPSE_TAB_VALUE = 4;

    public ParseTable getParseTable() {
        return prs;
    }

    public LexParser getParser() {
        return this.lexParser;
    }

    public int getToken(int i) {
        return this.lexParser.getToken(i);
    }

    public int getRhsFirstTokenIndex(int i) {
        return this.lexParser.getFirstToken(i);
    }

    public int getRhsLastTokenIndex(int i) {
        return this.lexParser.getLastToken(i);
    }

    public int getLeftSpan() {
        return this.lexParser.getToken(1);
    }

    public int getRightSpan() {
        return this.lexParser.getLastToken();
    }

    public void resetKeywordLexer() {
        if (this.kwLexer == null) {
            this.kwLexer = new NoKWLexer(this.lexStream.getInputChars(), 0);
        } else {
            this.kwLexer.setInputChars(this.lexStream.getInputChars());
        }
    }

    public void reset(String filename, int tab) throws IOException {
        this.lexStream = new BoxLexerLpgLexStream(filename, tab);
        this.lexParser.reset((ILexStream)this.lexStream, prs, (RuleAction)this);
        this.resetKeywordLexer();
    }

    public void reset(char[] input_chars, String filename) {
        this.reset(input_chars, filename, 1);
    }

    public void reset(char[] input_chars, String filename, int tab) {
        this.lexStream = new BoxLexerLpgLexStream(input_chars, filename, tab);
        this.lexParser.reset((ILexStream)this.lexStream, prs, (RuleAction)this);
        this.resetKeywordLexer();
    }

    public BoxLexer(String filename, int tab) throws IOException {
        this.reset(filename, tab);
    }

    public BoxLexer(char[] input_chars, String filename, int tab) {
        this.reset(input_chars, filename, tab);
    }

    public BoxLexer(char[] input_chars, String filename) {
        this.reset(input_chars, filename, 1);
    }

    public BoxLexer() {
    }

    public ILexStream getILexStream() {
        return this.lexStream;
    }

    public ILexStream getLexStream() {
        return this.lexStream;
    }

    private void initializeLexer(IPrsStream prsStream, int start_offset, int end_offset) {
        if (this.lexStream.getInputChars() == null) {
            throw new NullPointerException("LexStream was not initialized");
        }
        this.lexStream.setPrsStream(prsStream);
        prsStream.makeToken(start_offset, end_offset, 0);
    }

    private void addEOF(IPrsStream prsStream, int end_offset) {
        prsStream.makeToken(end_offset, end_offset, 19);
        prsStream.setStreamLength(prsStream.getSize());
    }

    public void lexer(IPrsStream prsStream) {
        this.lexer(null, prsStream);
    }

    public void lexer(Monitor monitor, IPrsStream prsStream) {
        this.initializeLexer(prsStream, 0, -1);
        this.lexParser.parseCharacters(monitor);
        this.addEOF(prsStream, this.lexStream.getStreamIndex());
    }

    public void lexer(IPrsStream prsStream, int start_offset, int end_offset) {
        this.lexer(null, prsStream, start_offset, end_offset);
    }

    public void lexer(Monitor monitor, IPrsStream prsStream, int start_offset, int end_offset) {
        if (start_offset <= 1) {
            this.initializeLexer(prsStream, 0, -1);
        } else {
            this.initializeLexer(prsStream, start_offset - 1, start_offset - 1);
        }
        this.lexParser.parseCharacters(monitor, start_offset, end_offset);
        this.addEOF(prsStream, end_offset >= this.lexStream.getStreamIndex() ? this.lexStream.getStreamIndex() : end_offset + 1);
    }

    public void reportLexicalError(int startLoc, int endLoc) {
        IPrsStream prs_stream = this.lexStream.getPrsStream();
        if (prs_stream == null) {
            this.lexStream.reportLexicalError(startLoc, endLoc);
        } else {
            for (int i = prs_stream.getSize() - 1; i > 0 && prs_stream.getStartOffset(i) >= startLoc; --i) {
                prs_stream.removeLastToken();
            }
            prs_stream.makeToken(startLoc, endLoc, 0);
        }
    }

    public int[] getKeywordKinds() {
        return this.kwLexer.getKeywordKinds();
    }

    public BoxLexer(String filename) throws IOException {
        this(filename, 4);
        this.kwLexer = new NoKWLexer(this.lexStream.getInputChars(), 0);
    }

    public void initialize(char[] content, String filename) {
        this.reset(content, filename);
    }

    final void makeToken(int left_token, int right_token, int kind) {
        this.lexStream.makeToken(left_token, right_token, kind);
    }

    final void makeToken(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        this.lexStream.makeToken(startOffset, endOffset, kind);
        if (this.printTokens) {
            this.printValue(startOffset, endOffset);
        }
    }

    final void makeComment(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        this.lexStream.getIPrsStream().makeAdjunct(startOffset, endOffset, kind);
    }

    final void skipToken() {
        if (this.printTokens) {
            this.printValue(this.getLeftSpan(), this.getRightSpan());
        }
    }

    final void checkForKeyWord() {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        int kwKind = this.kwLexer.lexer(startOffset, endOffset);
        this.lexStream.makeToken(startOffset, endOffset, kwKind);
        if (this.printTokens) {
            this.printValue(startOffset, endOffset);
        }
    }

    final void checkForKeyWord(int defaultKind) {
        int endOffset;
        int startOffset = this.getLeftSpan();
        int kwKind = this.kwLexer.lexer(startOffset, endOffset = this.getRightSpan());
        if (kwKind == 0) {
            kwKind = defaultKind;
        }
        this.lexStream.makeToken(startOffset, endOffset, kwKind);
        if (this.printTokens) {
            this.printValue(startOffset, endOffset);
        }
    }

    final void printValue(int startOffset, int endOffset) {
        String s = new String(this.lexStream.getInputChars(), startOffset, endOffset - startOffset + 1);
        System.out.print(s);
    }

    public void ruleAction(int ruleNumber) {
        switch (ruleNumber) {
            case 1: {
                this.makeToken(14);
                break;
            }
            case 2: {
                this.makeToken(12);
                break;
            }
            case 3: {
                this.makeToken(8);
                break;
            }
            case 4: {
                this.makeToken(11);
                break;
            }
            case 5: {
                this.makeToken(10);
                break;
            }
            case 6: {
                this.makeToken(15);
                break;
            }
            case 7: {
                this.makeToken(9);
                break;
            }
            case 8: {
                this.makeToken(13);
                break;
            }
            case 9: {
                this.makeToken(1);
                break;
            }
            case 10: {
                this.makeToken(21);
                break;
            }
            case 11: {
                this.makeToken(2);
                break;
            }
            case 12: {
                this.makeToken(3);
                break;
            }
            case 13: {
                this.makeToken(22);
                break;
            }
            case 14: {
                this.makeToken(23);
                break;
            }
            case 15: {
                this.makeToken(4);
                break;
            }
            case 16: {
                this.makeToken(5);
                break;
            }
            case 17: {
                this.makeToken(16);
                break;
            }
            case 18: {
                this.makeToken(7);
                break;
            }
            case 19: {
                this.skipToken();
                break;
            }
            case 20: {
                this.makeComment(24);
                break;
            }
            case 21: {
                this.makeToken(6);
                break;
            }
            case 22: {
                this.makeToken(18);
                break;
            }
            case 23: {
                this.makeToken(17);
                break;
            }
            case 24: {
                this.makeToken(20);
                break;
            }
        }
    }

    static class BoxLexerLpgLexStream
    extends LpgLexStream {
        public static final int[] tokenKind = new int[]{102, 102, 102, 102, 102, 102, 102, 102, 102, 15, 39, 102, 16, 40, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 36, 79, 37, 83, 71, 77, 84, 70, 98, 99, 97, 95, 90, 96, 92, 38, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 86, 87, 93, 75, 94, 91, 80, 53, 54, 55, 28, 56, 57, 29, 30, 31, 58, 59, 32, 60, 61, 33, 62, 63, 64, 34, 65, 66, 2, 35, 67, 68, 69, 73, 72, 74, 85, 76, 81, 41, 17, 18, 42, 19, 20, 21, 22, 23, 43, 44, 45, 46, 24, 25, 3, 47, 26, 1, 4, 48, 27, 49, 50, 51, 52, 88, 78, 89, 82, 100, 101};

        public final int getKind(int i) {
            int c;
            int n = c = i >= this.getStreamLength() ? 65535 : (int)this.getCharValue(i);
            return c < 128 ? tokenKind[c] : (c == 65535 ? 101 : 100);
        }

        public String[] orderedExportedSymbols() {
            return BoxParsersym.orderedTerminalSymbols;
        }

        public BoxLexerLpgLexStream(String filename, int tab) throws IOException {
            super(filename, tab);
        }

        public BoxLexerLpgLexStream(char[] input_chars, String filename, int tab) {
            super(input_chars, filename, tab);
        }

        public BoxLexerLpgLexStream(char[] input_chars, String filename) {
            super(input_chars, filename, 1);
        }
    }

    public static class NoKWLexer {
        public int[] getKeywordKinds() {
            return null;
        }

        public int lexer(int curtok, int lasttok) {
            return 0;
        }

        public void setInputChars(char[] inputChars) {
        }

        final int getKind(int c) {
            return 0;
        }

        public NoKWLexer(char[] inputChars, int identifierKind) {
        }
    }
}

