/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting.spec;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.imp.box.builders.BoxFactory;
import org.eclipse.imp.box.parser.Ast.IBox;
import org.eclipse.imp.box.parser.BoxParseController;
import org.eclipse.imp.formatting.spec.ExtensionPointBinder;
import org.eclipse.imp.formatting.spec.ParseException;
import org.eclipse.imp.formatting.spec.Rule;
import org.eclipse.imp.formatting.spec.Separator;
import org.eclipse.imp.formatting.spec.Specification;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser
extends DefaultHandler {
    protected static SAXParserFactory spf = SAXParserFactory.newInstance();
    protected Specification fSpec;
    protected Rule fTmpRule;
    protected String fTmpContents;
    private ISourceProject fProject;
    private IPath fPath;
    private Language fObjectLanguage;
    private IParseController fObjectParser;
    private IParseController fBoxParser;
    private IProgressMonitor fBoxParserMonitor;
    private IProgressMonitor fObjectParserMonitor;
    private IMessageHandler fHandler;
    private Separator fTmpSeparator;
    private boolean fNoObjectParsing;

    public Parser(IPath path, ISourceProject project, IMessageHandler handler) throws ModelFactory.ModelException {
        this.fPath = path;
        this.fSpec = new Specification(this);
        this.fProject = project;
        this.fHandler = handler;
        this.fNoObjectParsing = false;
    }

    public IMessageHandler getMessageHandler() {
        return this.fHandler;
    }

    public Specification parse(IPath path) throws ParseException, FileNotFoundException {
        this.fPath = path;
        this.fNoObjectParsing = false;
        return this.parse(new InputSource(new FileReader(path.toOSString())));
    }

    public Specification parse(String inputString) throws ParseException {
        this.fNoObjectParsing = false;
        return this.parse(new InputSource(new StringReader(inputString)));
    }

    public Specification load(String inputString) throws ParseException {
        this.fNoObjectParsing = true;
        return this.parse(new InputSource(new StringReader(inputString)));
    }

    private Specification parse(InputSource input) throws ParseException {
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(input, (DefaultHandler)this);
            if (this.fSpec == null) {
                throw new ParseException("Parsing of " + input + "failed.");
            }
            return this.fSpec;
        }
        catch (SAXException se) {
            throw new ParseException("Parsing of " + input + " failed because XML was invalid", se);
        }
        catch (ParserConfigurationException pce) {
            throw new ParseException("Parsing of " + input + " failed because XML configuration is wrong", pce);
        }
        catch (IOException ie) {
            throw new ParseException("Parsing of " + input + " failed because of an input error", ie);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("rule")) {
            this.fTmpRule = new Rule();
        } else if (qName.equals("box")) {
            this.fTmpContents = "";
        } else if (qName.equals("preview")) {
            this.fTmpContents = "";
        } else if (qName.equals("example")) {
            this.fTmpContents = "";
        } else if (qName.equals("language")) {
            this.fTmpContents = "";
        } else if (qName.equals("separator")) {
            this.fTmpSeparator = new Separator();
            this.fTmpContents = "";
        } else if (qName.equals("space-option")) {
            String name = attributes.getValue("name");
            Integer value = Integer.parseInt(attributes.getValue("value"));
            this.fSpec.setSpaceOption(name, value);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("rule")) {
            this.fSpec.addRule(this.fTmpRule);
        } else if (qName.equals("box")) {
            if (this.fTmpRule != null) {
                if (this.fNoObjectParsing) {
                    this.fTmpRule.setBoxString(this.fTmpContents);
                } else {
                    try {
                        this.parseBoxAndObject(this.fTmpContents, this.fTmpRule);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else if (qName.equals("preview")) {
            if (this.fTmpRule != null) {
                this.fTmpRule.setPatternString(this.fTmpContents);
            }
        } else if (qName.equals("example")) {
            this.fSpec.setExample(this.fTmpContents);
            this.fSpec.setExampleAst(this.parseObject(this.fTmpContents));
        } else if (qName.equals("language")) {
            this.fSpec.setLanguage(this.fTmpContents);
            this.setLanguage(this.fTmpContents);
        } else if (qName.equals("separator")) {
            this.fTmpSeparator.setLabel(this.fTmpContents);
            this.fSpec.addSeparator(this.fTmpSeparator);
        }
    }

    public void setLanguage(String langName) {
        if (this.fObjectParser == null) {
            try {
                this.fObjectLanguage = LanguageRegistry.findLanguage((String)langName);
                if (this.fObjectLanguage != null) {
                    ExtensionPointBinder b = new ExtensionPointBinder(this.fObjectLanguage);
                    this.fObjectParser = b.getObjectParser();
                } else {
                    this.displayAlert("Unknown target language", "A language descriptor for the language '" + langName + "' has not been registered.");
                }
            }
            catch (Exception e) {
                String msg = e.getMessage().contains("astAdapter") ? "Unable to find specified AST adapter class; check the formatting extension in the plugin.xml" : "Unable to find target language parser class; check the formatting extension in the plugin.xml";
                this.displayAlert("Error initializing target language pattern parser", msg);
            }
        }
    }

    private void displayAlert(final String title, final String msg) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        final Shell shell = display.getActiveShell();
        display.asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            }
        });
    }

    public void parseBoxAndObject(String boxString, Rule rule) throws ParseException {
        rule.setBoxString(boxString);
        rule.setBoxAst(this.parseBox(boxString));
        if (rule.getBoxAst() != null) {
            rule.setPatternString(BoxFactory.extractText((IBox)rule.getBoxAst()));
            rule.setPatternAst(this.parseObject(rule.getPatternString()));
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.fTmpContents = this.fTmpContents + new String(ch, start, length);
    }

    public IBox parseBox(String boxString) {
        this.initializeBoxParser();
        return (IBox)this.fBoxParser.parse(boxString, this.fBoxParserMonitor);
    }

    private void initializeBoxParser() {
        if (this.fBoxParser == null) {
            this.fBoxParser = new BoxParseController();
            this.fBoxParserMonitor = new NullProgressMonitor();
        }
        this.fBoxParser.initialize(this.fPath, this.fProject, this.fHandler);
    }

    public Object parseObject(String objectString) {
        if (this.fObjectParser == null) {
            this.fHandler.clearMessages();
            this.fHandler.handleSimpleMessage("Unable to parse formatted text: no parser is configured", 0, 0, 0, 0, 0, 0);
            this.fHandler.endMessages();
            return null;
        }
        this.initializeObjectParser(this.fObjectParser);
        return this.fObjectParser.parse(objectString, this.fObjectParserMonitor);
    }

    private void initializeObjectParser(IParseController parseController) {
        if (this.fObjectParserMonitor == null) {
            this.fObjectParserMonitor = new NullProgressMonitor();
        }
        parseController.initialize(this.fPath, this.fProject, this.fHandler);
    }
}

