/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.box.interpreter.BoxInterpreter;
import org.eclipse.imp.box.parser.Ast.IBox;
import org.eclipse.imp.box.parser.BoxParseController;
import org.eclipse.imp.formatting.editor.RuleTable;
import org.eclipse.imp.formatting.editor.SpaceOptionTable;
import org.eclipse.imp.formatting.spec.ExtensionPointBinder;
import org.eclipse.imp.formatting.spec.ParseException;
import org.eclipse.imp.formatting.spec.Parser;
import org.eclipse.imp.formatting.spec.Specification;
import org.eclipse.imp.formatting.spec.Transformer;
import org.eclipse.imp.formatting.spec.Unparser;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.utils.DynamicBundleUtils;
import org.eclipse.imp.utils.ExtensionPointUtils;
import org.eclipse.imp.utils.SavingMessageHandler;
import org.eclipse.imp.utils.StreamUtils;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.osgi.framework.Bundle;

public class Editor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private static final int RuleEditorIndex = 0;
    private static final int ExampleEditorIndex = 1;
    private static final int OptionEditorIndex = 2;
    protected TextEditor fEditor;
    protected Text fExampleText;
    private Specification fModel;
    private boolean fExampleModified = false;
    private Parser fParser;
    private RuleTable fRuleTable;
    private SpaceOptionTable fSpaceTable;
    private ModifyListener fExampleModifyListener;
    private Font fSampleFont;
    private Color fErrorColor;
    private Color fNormalColor;
    private Bundle fLanguageProjectBundle;
    private Bundle fFormattingProjectBundle;

    public Editor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        LanguageRegistry.getLanguages();
    }

    public Specification getModel() {
        return this.fModel;
    }

    public void createExampleViewer() {
        Composite parent = new Composite(this.getContainer(), 0);
        parent.setLayout((Layout)new FillLayout());
        this.fExampleText = new Text(parent, 2816);
        this.fSampleFont = new Font((Device)this.fExampleText.getDisplay(), "Monospace", 14, 0);
        this.fExampleText.setFont(this.fSampleFont);
        this.fExampleModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Editor.this.fModel.setExample(Editor.this.fExampleText.getText());
                Editor.this.fExampleModified = true;
                Editor.this.firePropertyChange(257);
                Object ast = Editor.this.fParser.parseObject(Editor.this.fExampleText.getText());
                if (ast != null) {
                    Editor.this.fModel.setExampleAst(ast);
                }
            }
        };
        this.fExampleText.addModifyListener(this.fExampleModifyListener);
        this.fExampleText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 && (e.stateMask & 0x440000) != 0) {
                    Editor.this.reformatExample();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.addPage(1, (Control)parent);
        this.setPageText(1, "Example");
    }

    protected void updateExample() {
        if (this.fModel != null) {
            String current = this.fExampleText.getText();
            if (current == null || current.length() == 0) {
                this.fExampleText.setText(this.fModel.getExample());
            }
            this.reformatExample();
        }
    }

    protected void createPages() {
        this.createRuleEditor();
        this.fErrorColor = new Color((Device)this.fRuleTable.getSite().getWorkbenchWindow().getShell().getDisplay(), 255, 128, 128);
        this.fNormalColor = new Color((Device)this.fRuleTable.getSite().getWorkbenchWindow().getShell().getDisplay(), 255, 255, 255);
        IEditorInput input = this.fRuleTable.getEditorInput();
        this.setPartName(input.getName());
        this.fModel = this.updateModelFromFile(input);
        this.createExampleViewer();
        this.createOptionEditor();
        this.fRuleTable.setModel(this.fModel);
        this.fSpaceTable.setModel(this.fModel);
        this.updateExample();
        this.fExampleModified = false;
    }

    private void createOptionEditor() {
        this.fSpaceTable = new SpaceOptionTable(this.fModel);
        this.fSpaceTable.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                Editor.this.firePropertyChange(257);
            }
        });
        try {
            this.addPage(2, this.fSpaceTable, this.getEditorInput());
            this.setPageText(2, this.fSpaceTable.getTitle());
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private void createRuleEditor() {
        this.fRuleTable = new RuleTable();
        this.fRuleTable.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                Editor.this.firePropertyChange(257);
            }
        });
        try {
            this.addPage(0, this.fRuleTable, this.getEditorInput());
            this.setPageText(0, this.fRuleTable.getTitle());
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private Specification updateModelFromFile(IEditorInput input) {
        try {
            IFile file = ((IFileEditorInput)input).getFile();
            IPath path = file.getProjectRelativePath();
            IProject project = file.getProject();
            IPath fullFilePath = project.getLocation().append(path);
            ISourceProject sp = ModelFactory.open((IProject)project);
            this.fParser = new Parser(fullFilePath, sp, (IMessageHandler)new SavingMessageHandler());
            String editorText = StreamUtils.readStreamContents((InputStream)file.getContents());
            if (editorText == null || editorText.length() == 0) {
                String langName = ExtensionPointUtils.discoverLanguageForProject((IProject)project);
                if (langName == null) {
                    langName = this.askUserForLanguage();
                }
                if (langName.length() > 0) {
                    this.activateWorkspaceBundles(langName);
                    this.fParser.setLanguage(langName);
                    Specification skelSpec = new Specification(langName, this.fParser);
                    this.fExampleModified = true;
                    return skelSpec;
                }
                return new Specification("", this.fParser);
            }
            Pattern pat = Pattern.compile("<language>([a-zA-Z0-9_]+)</language>");
            Matcher m = pat.matcher(editorText);
            if (m.find()) {
                String langName = m.group(1);
                this.activateWorkspaceBundles(langName);
            }
            this.fParser.getMessageHandler().clearMessages();
            this.fModel = this.fParser.load(editorText);
            this.fParser.getMessageHandler().endMessages();
            return this.fModel;
        }
        catch (ParseException e) {
            SavingMessageHandler smh = (SavingMessageHandler)this.fParser.getMessageHandler();
            System.err.println("error:" + smh.getConcatenatedMessages());
        }
        catch (ModelFactory.ModelException e) {
            System.err.println("model error:" + (Object)((Object)e));
        }
        catch (CoreException e) {
            System.err.println("file reading error:" + (Object)((Object)e));
        }
        return new Specification(this.fParser);
    }

    private String askUserForLanguage() {
        InputDialog d = new InputDialog(this.fRuleTable.getSite().getShell(), "Missing language ID", "Please provide the language ID", "", new IInputValidator(){

            public String isValid(String newText) {
                return newText != null && newText.length() > 0 ? null : "Language ID must be non-empty";
            }
        });
        if (d.open() == 0) {
            return d.getValue();
        }
        return "";
    }

    private void activateWorkspaceBundles(String langName) {
        this.fLanguageProjectBundle = DynamicBundleUtils.activateWorkspaceBundleForLanguage((String)langName);
        this.fFormattingProjectBundle = this.fLanguageProjectBundle != null ? DynamicBundleUtils.activateWorkspaceBundleForExtension((String)langName, (String)"org.eclipse.imp.formatting.formattingSpecification") : null;
    }

    private void deactivateWorkspaceBundles() {
        if (this.fLanguageProjectBundle != null) {
            DynamicBundleUtils.deactivateWorkspaceBundle((Bundle)this.fLanguageProjectBundle);
            this.fLanguageProjectBundle = null;
        }
        if (this.fFormattingProjectBundle != null) {
            DynamicBundleUtils.deactivateWorkspaceBundle((Bundle)this.fFormattingProjectBundle);
            this.fFormattingProjectBundle = null;
        }
    }

    private void reformatExample() {
        this.fParser.getMessageHandler().clearMessages();
        String exampleStr = this.fModel.getExample();
        Object ast = this.fParser.parseObject(exampleStr);
        if (ast != null) {
            this.fModel.setExampleAst(ast);
            try {
                Language objectLanguage = LanguageRegistry.findLanguage((String)this.fModel.getLanguage());
                this.activateWorkspaceBundles(objectLanguage.getName());
                ExtensionPointBinder b = new ExtensionPointBinder(objectLanguage);
                Transformer t = new Transformer(this.fModel, b.getASTAdapter());
                String boxStr = t.transformToBox(exampleStr, this.fModel.getExampleAst());
                IBox box = BoxParseController.parseBox((String)boxStr);
                BoxInterpreter bi = new BoxInterpreter();
                String newExample = bi.interpret(box);
                this.fExampleText.removeModifyListener(this.fExampleModifyListener);
                this.fExampleText.setText(newExample);
                this.fExampleText.addModifyListener(this.fExampleModifyListener);
                this.fExampleText.append(ast.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.fExampleText.setBackground(this.fNormalColor);
        } else {
            SavingMessageHandler smh = (SavingMessageHandler)this.fParser.getMessageHandler();
            String allMsgs = smh.getConcatenatedMessages();
            this.fExampleText.setToolTipText(allMsgs);
            this.fExampleText.setBackground(this.fErrorColor);
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.deactivateWorkspaceBundles();
        this.fSampleFont.dispose();
        this.fErrorColor.dispose();
        this.fNormalColor.dispose();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            Unparser u = new Unparser();
            String contents = u.unparse(this.fModel);
            IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
            ByteArrayInputStream s = new ByteArrayInputStream(contents.getBytes());
            file.setContents((InputStream)s, 0, monitor);
            this.fRuleTable.setDirty(false);
            this.fSpaceTable.setDirty(false);
            this.fExampleModified = false;
            this.firePropertyChange(257);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = Editor.this.getSite().getWorkbenchWindow().getPages();
                    for (int i = 0; i < pages.length; ++i) {
                        if (!((FileEditorInput)Editor.this.fEditor.getEditorInput()).getFile().getProject().equals(event.getResource())) continue;
                        IEditorPart editorPart = pages[i].findEditor(Editor.this.fEditor.getEditorInput());
                        pages[i].closeEditor(editorPart, true);
                    }
                }
            });
        }
    }

    protected void pageChange(int newPageIndex) {
        switch (newPageIndex) {
            case 2: {
                this.fSpaceTable.refresh();
                break;
            }
            case 1: {
                this.updateExample();
                break;
            }
        }
        super.pageChange(newPageIndex);
    }

    public boolean isDirty() {
        return this.fRuleTable.isDirty() || this.fSpaceTable.isDirty() || this.fExampleModified;
    }

    public void newRule() {
        this.fRuleTable.newRule();
    }

    public void addSeparator() {
        this.fRuleTable.addSeparator();
    }

    public void deleteRule() {
        this.fRuleTable.deleteRule();
    }

    public void formatRule() {
        this.fRuleTable.formatRule();
    }

    public void addRuleFromExample() {
        this.fRuleTable.addRuleFromExample();
    }

    public void moveUp() {
        this.fRuleTable.move(-1);
    }

    public void moveDown() {
        this.fRuleTable.move(1);
    }

    public void addOption() {
        this.fSpaceTable.newOption();
    }

    public void deleteOption() {
        this.fSpaceTable.deleteOption();
    }
}

