/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg;

import java.net.URL;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.model.IPathEntry;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.preferences.PreferencesService;
import org.eclipse.imp.runtime.PluginBase;
import org.eclipse.imp.utils.ExtensionFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class LPGRuntimePlugin
extends PluginBase {
    public static final String kPluginID = "org.eclipse.imp.lpg.ide";
    protected static LPGRuntimePlugin sPlugin;
    protected static PreferencesService preferencesService;
    private static String kLanguageID;
    public static final IPath ICONS_PATH;

    public static LPGRuntimePlugin getInstance() {
        return sPlugin;
    }

    public LPGRuntimePlugin() {
        sPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        kLanguageID = ExtensionFactory.retrieveLanguageIdFromPlugin((String)kPluginID);
        if (preferencesService == null) {
            preferencesService = this.getPreferencesService();
        }
        ModelFactory.getInstance().installExtender(new ModelFactory.IFactoryExtender(){

            public void extend(ISourceProject project) {
                IPreferenceStore store = LPGRuntimePlugin.getInstance().getPreferenceStore();
                Path includeDir = new Path(store.getString("IncludePathToUse"));
                project.getBuildPath().add(ModelFactory.createPathEntry((IPathEntry.PathEntryType)IPathEntry.PathEntryType.SOURCE_FOLDER, (IPath)includeDir));
            }

            public void extend(ICompilationUnit unit) {
            }
        }, LanguageRegistry.findLanguage((String)kLanguageID));
        this.fEmitInfoMessages = preferencesService.getBooleanPreference("EmitDiagnostics");
        this.fixGeneratorPermissions();
    }

    private void fixGeneratorPermissions() {
        String path = preferencesService.getBooleanPreference("UseDefaultExecutable") ? preferencesService.getStringPreference("default", "ExecutableToUse") : preferencesService.getStringPreference("ExecutableToUse");
        IFileSystem fs = EFS.getLocalFileSystem();
        IFileStore fStore = fs.getStore((IPath)new Path(path));
        IFileInfo fInfo = fStore.fetchInfo();
        if (!fInfo.getAttribute(4)) {
            fInfo.setAttribute(4, true);
            try {
                fStore.putInfo(fInfo, 1024, null);
            }
            catch (CoreException e) {
                this.logException("Exception encountered when attempting to fix generator permissions", e);
            }
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        IPath path = ICONS_PATH.append("default.gif");
        ImageDescriptor imageDescriptor = LPGRuntimePlugin.createImageDescriptor(LPGRuntimePlugin.getInstance().getBundle(), path);
        reg.put("default_ast", imageDescriptor);
        path = ICONS_PATH.append("outline_item.gif");
        imageDescriptor = LPGRuntimePlugin.createImageDescriptor(LPGRuntimePlugin.getInstance().getBundle(), path);
        reg.put("outline_item", imageDescriptor);
        path = ICONS_PATH.append("grammarfile.gif");
        imageDescriptor = LPGRuntimePlugin.createImageDescriptor(LPGRuntimePlugin.getInstance().getBundle(), path);
        reg.put("grammarfile", imageDescriptor);
        path = ICONS_PATH.append("grammarfile-warning.jpg");
        imageDescriptor = LPGRuntimePlugin.createImageDescriptor(LPGRuntimePlugin.getInstance().getBundle(), path);
        reg.put("grammarfile-warning", imageDescriptor);
        path = ICONS_PATH.append("grammarfile-error.jpg");
        imageDescriptor = LPGRuntimePlugin.createImageDescriptor(LPGRuntimePlugin.getInstance().getBundle(), path);
        reg.put("grammarfile-error", imageDescriptor);
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        return null;
    }

    public String getLanguageID() {
        if (kLanguageID == null) {
            kLanguageID = ExtensionFactory.retrieveLanguageIdFromPlugin((String)kPluginID);
        }
        return kLanguageID;
    }

    public String getID() {
        return kPluginID;
    }

    public void maybeWriteInfoMsg(String msg) {
        if (!preferencesService.getBooleanPreference("EmitDiagnostics")) {
            return;
        }
        this.writeInfoMsg(msg);
    }

    static {
        preferencesService = null;
        ICONS_PATH = new Path("icons/");
    }
}

