/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.imp.builder.MarkerCreator;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.prefspecs.PrefspecsPlugin;
import org.eclipse.imp.prefspecs.compiler.DynamicEnumValueSource;
import org.eclipse.imp.prefspecs.compiler.IEnumValueSource;
import org.eclipse.imp.prefspecs.compiler.LiteralEnumValueSource;
import org.eclipse.imp.prefspecs.compiler.codegen.CodeGenerator;
import org.eclipse.imp.prefspecs.compiler.model.BooleanFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.ColorFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.ComboFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.DirListFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.DirectoryFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.DoubleFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.EnumFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.FieldGroup;
import org.eclipse.imp.prefspecs.compiler.model.FieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.FieldVisitor;
import org.eclipse.imp.prefspecs.compiler.model.FileFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.FontFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.IPageMemberContainer;
import org.eclipse.imp.prefspecs.compiler.model.ITabContainer;
import org.eclipse.imp.prefspecs.compiler.model.IntFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.PageInfo;
import org.eclipse.imp.prefspecs.compiler.model.PreferencesInfo;
import org.eclipse.imp.prefspecs.compiler.model.RadioFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.StringFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.TabContainerBase;
import org.eclipse.imp.prefspecs.compiler.model.TabInfo;
import org.eclipse.imp.prefspecs.parser.Ast.ASTNode;
import org.eclipse.imp.prefspecs.parser.Ast.ASTNodeToken;
import org.eclipse.imp.prefspecs.parser.Ast.AbstractASTNodeList;
import org.eclipse.imp.prefspecs.parser.Ast.AbstractVisitor;
import org.eclipse.imp.prefspecs.parser.Ast.IbooleanValue;
import org.eclipse.imp.prefspecs.parser.Ast.IfontStyle;
import org.eclipse.imp.prefspecs.parser.Ast.IgeneralSpec;
import org.eclipse.imp.prefspecs.parser.Ast.IsignedNumber;
import org.eclipse.imp.prefspecs.parser.Ast.IstaticOrDynamicValues;
import org.eclipse.imp.prefspecs.parser.Ast.IstringEmptySpec;
import org.eclipse.imp.prefspecs.parser.Ast.ItypeOrValuesSpec;
import org.eclipse.imp.prefspecs.parser.Ast.booleanDefValueSpec;
import org.eclipse.imp.prefspecs.parser.Ast.booleanFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.booleanFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.booleanSpecificSpecList;
import org.eclipse.imp.prefspecs.parser.Ast.colorDefValueSpec;
import org.eclipse.imp.prefspecs.parser.Ast.colorFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.colorFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.colorSpecificSpecList;
import org.eclipse.imp.prefspecs.parser.Ast.columnsSpec;
import org.eclipse.imp.prefspecs.parser.Ast.comboFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.comboFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.comboSpecificSpecList;
import org.eclipse.imp.prefspecs.parser.Ast.conditionType__IF;
import org.eclipse.imp.prefspecs.parser.Ast.conditionalSpec__identifier_AGAINST_identifier;
import org.eclipse.imp.prefspecs.parser.Ast.conditionalSpec__identifier_WITH_identifier;
import org.eclipse.imp.prefspecs.parser.Ast.configurationTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.defaultTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.dirListFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.directoryFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.directoryFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.dirlistFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.doubleDefValueSpec;
import org.eclipse.imp.prefspecs.parser.Ast.doubleFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.doubleFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.doubleRangeSpec;
import org.eclipse.imp.prefspecs.parser.Ast.doubleSpecificSpecList;
import org.eclipse.imp.prefspecs.parser.Ast.enumDefValueSpec;
import org.eclipse.imp.prefspecs.parser.Ast.fileFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.fileFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.fontDefValueSpec;
import org.eclipse.imp.prefspecs.parser.Ast.fontFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.fontFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.fontSpecificSpecList;
import org.eclipse.imp.prefspecs.parser.Ast.fontStyle__BOLD;
import org.eclipse.imp.prefspecs.parser.Ast.fontStyle__ITALIC;
import org.eclipse.imp.prefspecs.parser.Ast.fontStyle__NORMAL;
import org.eclipse.imp.prefspecs.parser.Ast.generalSpecList;
import org.eclipse.imp.prefspecs.parser.Ast.groupSpec;
import org.eclipse.imp.prefspecs.parser.Ast.instanceTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.intDefValueSpec;
import org.eclipse.imp.prefspecs.parser.Ast.intFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.intFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.intRangeSpec;
import org.eclipse.imp.prefspecs.parser.Ast.intSpecificSpecList;
import org.eclipse.imp.prefspecs.parser.Ast.isRemovableSpec;
import org.eclipse.imp.prefspecs.parser.Ast.labelledStringValueList;
import org.eclipse.imp.prefspecs.parser.Ast.optConditionalSpec;
import org.eclipse.imp.prefspecs.parser.Ast.optDetailsSpec;
import org.eclipse.imp.prefspecs.parser.Ast.optLabelSpec;
import org.eclipse.imp.prefspecs.parser.Ast.optPackageSpec;
import org.eclipse.imp.prefspecs.parser.Ast.optToolTipSpec;
import org.eclipse.imp.prefspecs.parser.Ast.pageSpec;
import org.eclipse.imp.prefspecs.parser.Ast.prefSpecs;
import org.eclipse.imp.prefspecs.parser.Ast.projectTabSpec;
import org.eclipse.imp.prefspecs.parser.Ast.radioFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.radioFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.radioSpecificSpecList;
import org.eclipse.imp.prefspecs.parser.Ast.sign__MINUS;
import org.eclipse.imp.prefspecs.parser.Ast.signedNumber__INTEGER;
import org.eclipse.imp.prefspecs.parser.Ast.signedNumber__sign_INTEGER;
import org.eclipse.imp.prefspecs.parser.Ast.staticOrDynamicValues;
import org.eclipse.imp.prefspecs.parser.Ast.stringDefValueSpec;
import org.eclipse.imp.prefspecs.parser.Ast.stringEmptySpec__EMPTYALLOWED_FALSE_SEMICOLON;
import org.eclipse.imp.prefspecs.parser.Ast.stringEmptySpec__EMPTYALLOWED_TRUE_stringValue_SEMICOLON;
import org.eclipse.imp.prefspecs.parser.Ast.stringFieldPropertySpecs;
import org.eclipse.imp.prefspecs.parser.Ast.stringFieldSpec;
import org.eclipse.imp.prefspecs.parser.Ast.stringSpecificSpecList;
import org.eclipse.imp.prefspecs.parser.Ast.stringValidatorSpec;
import org.eclipse.imp.prefspecs.parser.Ast.stringValue;
import org.eclipse.imp.prefspecs.parser.Ast.typeOrValuesSpec__TYPE_identifier_SEMICOLON;
import org.eclipse.imp.prefspecs.parser.Ast.typeOrValuesSpec__valuesSpec_SEMICOLON;
import org.eclipse.imp.prefspecs.parser.Ast.typeSpec;
import org.eclipse.imp.prefspecs.parser.PrefspecsParseController;
import org.eclipse.imp.wizards.CodeServiceWizard;
import org.eclipse.imp.wizards.ExtensionEnabler;
import org.eclipse.imp.wizards.ExtensionPointWizard;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.plugin.ImpPluginElement;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.console.MessageConsoleStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefspecsCompiler {
    public static String PROBLEM_MARKER_ID = "org.eclipse.imp.prefspecs.problem";
    private final String ENUM_VALUE_PROVIDER_INTF_QUAL_NAME = "org.eclipse.imp.preferences.fields.IEnumValueProvider";
    private static final String VALIDATOR_INTF_QUAL_NAME = "org.eclipse.imp.preferences.fields.StringFieldEditor.Validator";
    protected IProject fProject = null;
    protected String fProjectName = null;
    protected String fLanguageName = null;
    private IFile fSpecFile;
    protected PreferencesInfo fPreferencesInfo = new PreferencesInfo();
    protected List<PageInfo> fPages = new ArrayList<PageInfo>();
    protected ITabContainer fTabContainer = null;
    protected Stack<IPageMemberContainer> fMemberContainer = new Stack();
    protected PageInfo fCurPageInfo = null;
    protected String fPageClassNameBase = null;
    protected String fPageId = null;
    protected String fAlternativeMessage = null;
    protected String fPageName = null;
    protected String fPageMenuItem = null;
    protected String fPagePackageName = null;
    protected boolean fNoDetails = false;
    private Map<String, IEnumValueSource> fTypeMap = new HashMap<String, IEnumValueSource>();
    private final MessageConsoleStream fConsoleStream;

    public PrefspecsCompiler(String problem_marker_id, MessageConsoleStream messageConsoleStream) {
        PROBLEM_MARKER_ID = problem_marker_id;
        this.fConsoleStream = messageConsoleStream;
    }

    protected void parseAndProduceModel(IFile specFile) {
        IProject project;
        if (specFile == null) {
            this.fConsoleStream.println("PrefspecsCompiler.parseAndProduceModel(..): no specification file?");
        }
        if ((project = specFile.getProject()) == null) {
            this.fConsoleStream.println("PrefspecsCompiler.parseAndProduceModel(..): project is null");
        }
        ISourceProject sourceProject = null;
        try {
            sourceProject = ModelFactory.open((IProject)project);
        }
        catch (ModelFactory.ModelException me) {
            this.fConsoleStream.println("PrefspecsCompiler.parseAndProduceModel(..): exception while opening source project:\n" + me.getMessage() + "\n");
        }
        PrefspecsParseController parseController = new PrefspecsParseController();
        MarkerCreator markerCreator = new MarkerCreator(specFile, PROBLEM_MARKER_ID);
        parseController.getAnnotationTypeInfo().addProblemMarkerType(PROBLEM_MARKER_ID);
        parseController.initialize(specFile.getProjectRelativePath(), sourceProject, (IMessageHandler)markerCreator);
        parseController.parse(this.getFileContents(specFile), (IProgressMonitor)new NullProgressMonitor());
        ASTNode currentAst = (ASTNode)parseController.getCurrentAst();
        if (currentAst == null) {
            this.fConsoleStream.println("PrefspecsCompiler.parseAndProduceModel(): current AST is null (parse errors?); unable to compute page info.");
            return;
        }
        TranslatorVisitor visitor = new TranslatorVisitor();
        currentAst.accept(visitor);
    }

    private void createErrorMarker(String msg, ASTNode node) {
        int startLine = node.getLeftIToken().getLine();
        int startOffset = node.getLeftIToken().getStartOffset();
        int endOffset = node.getRightIToken().getEndOffset() + 1;
        this.createMarker(msg, startLine, startOffset, endOffset, 2);
    }

    private void createMarker(String msg, int startLine, int startOffset, int endOffset, int severity) {
        try {
            IMarker m = this.fSpecFile.createMarker(PROBLEM_MARKER_ID);
            String[] attributeNames = new String[]{"lineNumber", "charStart", "charEnd", "message", "priority", "severity"};
            Object[] values = new Object[]{startLine, startOffset, endOffset, msg, 2, severity};
            m.setAttributes(attributeNames, values);
        }
        catch (CoreException e) {
            PrefspecsPlugin.getInstance().logException("PrefspecsCompiler.createMarker: CoreException trying to create marker", e);
        }
        catch (Exception e) {
            PrefspecsPlugin.getInstance().logException("PrefspecsCompiler.createMarker: Exception trying to create marker", e);
        }
    }

    public IType findClass(String validatorQualClass) {
        IJavaProject javaProj = JavaCore.create((IProject)this.fProject);
        try {
            return javaProj.findType(validatorQualClass);
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    public boolean classImplementsInterface(IType clazz, String interfaceQualName) {
        try {
            String[] supers;
            for (String sup : supers = clazz.getSuperInterfaceNames()) {
                if (!sup.equals(interfaceQualName) && !sup.equals(interfaceQualName.substring(interfaceQualName.lastIndexOf(46) + 1))) continue;
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    private List<IClasspathEntry> getSourceCPEntries(IJavaProject javaProj) {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        try {
            IClasspathEntry[] cpEntries = javaProj.getResolvedClasspath(true);
            for (int i = 0; i < cpEntries.length; ++i) {
                if (cpEntries[i].getEntryKind() != 3) continue;
                result.add(cpEntries[i]);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return result;
    }

    public String getFileContents(IFile file) {
        char[] buf = null;
        try {
            File javaFile = new File(file.getLocation().toOSString());
            FileReader fileReader = new FileReader(javaFile);
            int len = (int)javaFile.length();
            buf = new char[len];
            fileReader.read(buf, 0, len);
            return new String(buf);
        }
        catch (FileNotFoundException fnf) {
            this.fConsoleStream.println(fnf.getMessage());
            return "";
        }
        catch (IOException io) {
            this.fConsoleStream.println(io.getMessage());
            return "";
        }
    }

    public void compile(final IFile specFile, final IProgressMonitor mon) {
        this.fSpecFile = specFile;
        IWorkspaceRunnable wsop = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject project;
                IPluginModel pluginModel;
                PrefspecsCompiler.this.collectCodeParms(specFile);
                if (PrefspecsCompiler.this.fPageId == null) {
                    PrefspecsCompiler.this.fPageId = PrefspecsCompiler.this.fPagePackageName;
                }
                if ((pluginModel = this.getPluginModel(project = specFile.getProject())) == null) {
                    PrefspecsCompiler.this.createMarker("Unable to read plugin.xml; possibly it or MANIFEST.MF is missing?", 1, 0, 0, 1);
                } else {
                    ExtensionEnabler.loadImpExtensionsModel((IPluginModel)pluginModel, (IProject)project);
                    IExtensions pmExtensions = pluginModel.getExtensions();
                    IPluginExtension[] pluginExtensions = pmExtensions.getExtensions();
                    this.removeOldPageExtensions(pmExtensions, pluginExtensions);
                    ExtensionEnabler.saveAndRefresh((IPluginModel)pluginModel);
                }
                PrefspecsCompiler.this.generateCodeStubs(specFile, mon);
                this.addNewPageExtensions(specFile, monitor);
            }

            private IPluginModel getPluginModel(IProject project) {
                BundlePluginModel bpm;
                IBundleModel bm;
                IPluginModel pluginModel = ExtensionEnabler.getPluginModel((IProject)project);
                if (pluginModel instanceof BundlePluginModel && (bm = (bpm = (BundlePluginModel)pluginModel).getBundleModel()) instanceof WorkspaceBundleModel) {
                    ((WorkspaceBundleModel)bm).setEditable(true);
                }
                return pluginModel;
            }

            private void addNewPageExtensions(IFile specFile2, IProgressMonitor monitor) {
                for (PageInfo pageInfo : PrefspecsCompiler.this.fPages) {
                    String pageName2 = pageInfo.getName();
                    int lastCompIdx = pageName2.indexOf(46) > 0 ? pageName2.lastIndexOf(46) + 1 : 0;
                    String pageParent = lastCompIdx > 0 ? PrefspecsCompiler.this.fPageId + "." + pageName2.substring(0, lastCompIdx - 1) : "";
                    String pageLabel = pageName2.substring(lastCompIdx);
                    ExtensionEnabler.enable((IProject)specFile2.getProject(), (String)"org.eclipse.ui", (String)"preferencePages", (String[][])new String[][]{{"page:id", PrefspecsCompiler.this.fPageId + "." + pageName2}, {"page:name", pageLabel}, {"page:class", PrefspecsCompiler.this.fPagePackageName + "." + pageName2.replaceAll("\\.", "") + "PreferencePage"}, {"page:category", pageParent}}, (boolean)false, PrefspecsCompiler.this.getPluginDependencies(), (IProgressMonitor)monitor);
                }
            }

            private void removeOldPageExtensions(IExtensions pmExtensions, IPluginExtension[] pluginExtensions) throws CoreException {
                for (int i = 0; i < pluginExtensions.length; ++i) {
                    IPluginExtension pluginExtension = pluginExtensions[i];
                    if (pluginExtension == null || pluginExtension.getPoint() == null) continue;
                    String point = "org.eclipse.ui.preferencePages";
                    if (pluginExtension.getPoint() == null || !pluginExtension.getPoint().equals(point)) continue;
                    IPluginObject[] children = pluginExtension.getChildren();
                    for (int j = 0; j < children.length; ++j) {
                        ImpPluginElement ipe;
                        IPluginAttribute pa;
                        if (!children[j].getName().equals("page") || (pa = (ipe = (ImpPluginElement)children[j]).getAttribute("id")) == null || !pa.getValue().startsWith(PrefspecsCompiler.this.fPageId)) continue;
                        pmExtensions.remove(pluginExtension);
                    }
                }
            }
        };
        try {
            wsop.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ErrorHandler.reportError((String)"PrefspecsCompiler.performGeneration:  CoreException:  ", (Throwable)e);
        }
    }

    protected void collectCodeParms(IFile file) {
        this.fProject = file.getProject();
        this.fProjectName = this.fProject.getName();
        IPath filePath = file.getLocation();
        IPath projectPath = file.getProject().getLocation();
        IPath packagePath = filePath.removeFirstSegments(projectPath.segmentCount() + this.getProjectSourceLocationPath().segmentCount());
        packagePath = packagePath.removeLastSegments(1);
        this.fPagePackageName = packagePath.toString();
        this.fPagePackageName = this.fPagePackageName.substring(this.fPagePackageName.indexOf(58) + 1);
        this.fPagePackageName = this.fPagePackageName.replace('\\', '.');
        this.fPagePackageName = this.fPagePackageName.replace('/', '.');
        this.fLanguageName = CodeServiceWizard.discoverProjectLanguage((IProject)file.getProject());
    }

    public void generateCodeStubs(IFile specFile, IProgressMonitor mon) throws CoreException {
        IProject fProject = specFile.getProject();
        Map<String, String> subs = this.getStandardSubstitutions(fProject);
        this.parseAndProduceModel(specFile);
        if (specFile.findMaxProblemSeverity(PROBLEM_MARKER_ID, true, 0) >= 2) {
            return;
        }
        ISourceProject sourceProject = null;
        try {
            sourceProject = ModelFactory.open((IProject)fProject);
        }
        catch (ModelFactory.ModelException me) {
            this.fConsoleStream.println("PrefspecsCompiler.generateCodeStubs(..): exception opening source project:\n" + me.getMessage() + "\nReturning without parsing");
            return;
        }
        this.fPageClassNameBase = this.fPages.get(0).getName();
        String constantsClassName = this.fPageClassNameBase + "Constants";
        String initializerClassName = this.fPageClassNameBase + "Initializer";
        subs.put("$PREFS_CLASS_NAME$", this.fPageClassNameBase);
        subs.put("$PREFS_PACKAGE_NAME$", this.fPagePackageName);
        subs.put("$PREFS_INIT_CLASS_NAME$", initializerClassName);
        CodeGenerator prefFactory = new CodeGenerator(this.fConsoleStream);
        String projectSourceLoc = ExtensionPointWizard.getProjectSourceLocation((IProject)fProject);
        String pluginPkgName = this.getPluginPackageName(fProject, null);
        String pluginClassName = this.getPluginClassName(fProject, null);
        prefFactory.generatePreferenceConstantsClass(this.fPages, sourceProject, projectSourceLoc, this.fPagePackageName, constantsClassName, mon);
        prefFactory.generatePreferenceInitializerClass(this.fPages, pluginPkgName, pluginClassName, constantsClassName, sourceProject, projectSourceLoc, this.fPagePackageName, initializerClassName, mon);
        for (PageInfo pageInfo : this.fPages) {
            TabInfo projTabInfo;
            TabInfo instTabInfo;
            TabInfo confTabInfo;
            String javaPageName = pageInfo.getName().replaceAll("\\.", "");
            TabContainerBase tabContainer = pageInfo.getTabInfos().hasNext() ? pageInfo : this.fPreferencesInfo;
            subs.put("$PREFS_CLASS_NAME$", javaPageName);
            prefFactory.generatePreferencePageClass(pageInfo, tabContainer, pluginPkgName, pluginClassName, constantsClassName, initializerClassName, sourceProject, projectSourceLoc, this.fPagePackageName, javaPageName + "PreferencePage", mon);
            TabInfo defTabInfo = this.findTabInfo("default", pageInfo);
            if (defTabInfo != null && defTabInfo.getIsUsed()) {
                prefFactory.generateDefaultTabClass(pageInfo, pluginPkgName, pluginClassName, constantsClassName, initializerClassName, sourceProject, projectSourceLoc, this.fPagePackageName, javaPageName + "DefaultTab", mon);
            }
            if ((confTabInfo = this.findTabInfo("configuration", pageInfo)) != null && confTabInfo.getIsUsed()) {
                prefFactory.generateConfigurationTabClass(pageInfo, pluginPkgName, pluginClassName, constantsClassName, sourceProject, projectSourceLoc, this.fPagePackageName, javaPageName + "ConfigurationTab", mon);
            }
            if ((instTabInfo = this.findTabInfo("instance", pageInfo)) != null && instTabInfo.getIsUsed()) {
                prefFactory.generateInstanceTabClass(pageInfo, pluginPkgName, pluginClassName, constantsClassName, sourceProject, projectSourceLoc, this.fPagePackageName, javaPageName + "InstanceTab", mon);
            }
            if ((projTabInfo = this.findTabInfo("project", pageInfo)) == null || !projTabInfo.getIsUsed()) continue;
            prefFactory.generateProjectTabClass(pageInfo, pluginPkgName, pluginClassName, constantsClassName, sourceProject, projectSourceLoc, this.fPagePackageName, javaPageName + "ProjectTab", mon);
        }
    }

    private TabInfo findTabInfo(String tabName, ITabContainer tabContainer) {
        TabInfo result = tabContainer.getTabInfo(tabName);
        if (result == null) {
            result = this.fPreferencesInfo.getTabInfo(tabName);
        }
        return result;
    }

    public String getPluginPackageName(IProject project, String defaultName) {
        String result = defaultName;
        if (result == null) {
            result = this.fLanguageName;
        }
        if (project != null) {
            String activator = null;
            IPluginModel pm = ExtensionEnabler.getPluginModelForProject((IProject)project);
            if (pm != null) {
                WorkspaceBundleModel wbm = new WorkspaceBundleModel(project.getFile("META-INF/MANIFEST.MF"));
                activator = wbm.getBundle().getHeader("Bundle-Activator");
            }
            if (activator != null && !activator.equals("") && activator.lastIndexOf(".") >= 0) {
                result = activator.substring(0, activator.lastIndexOf("."));
            }
        }
        return result;
    }

    public String getPluginClassName(IProject project, String defaultName) {
        String result = defaultName;
        if (result == null) {
            result = this.fPageClassNameBase + "Plugin";
        }
        if (project != null) {
            String activator = null;
            IPluginModel pm = ExtensionEnabler.getPluginModelForProject((IProject)project);
            if (pm != null) {
                WorkspaceBundleModel wbm = new WorkspaceBundleModel(project.getFile("META-INF/MANIFEST.MF"));
                activator = wbm.getBundle().getHeader("Bundle-Activator");
            }
            if (activator != null) {
                result = activator.substring(activator.lastIndexOf(".") + 1);
            }
        }
        return result;
    }

    public String getPluginID(IProject project, String defaultID) {
        String result = defaultID;
        if (result == null) {
            this.getPluginPackageName(project, null);
        }
        if (project != null) {
            result = ExtensionEnabler.getPluginIDForProject((IProject)project);
        }
        return result;
    }

    public Map<String, String> getStandardSubstitutions(IProject project) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("$LANG_NAME$", this.fLanguageName);
        result.put("$CLASS_NAME_PREFIX$", this.fPageClassNameBase);
        result.put("$PACKAGE_NAME$", this.fPagePackageName);
        result.put("$PROJECT_NAME$", this.fProjectName);
        result.put("$PLUGIN_PACKAGE$", this.getPluginPackageName(null, null));
        result.put("$PLUGIN_CLASS$", this.getPluginClassName(null, null));
        result.put("$PLUGIN_ID$", this.getPluginID(null, null));
        result.remove("$PLUGIN_PACKAGE$");
        result.put("$PLUGIN_PACKAGE$", this.getPluginPackageName(project, null));
        result.remove("$PLUGIN_CLASS$");
        result.put("$PLUGIN_CLASS$", this.getPluginClassName(project, null));
        result.remove("$PLUGIN_ID$");
        result.put("$PLUGIN_ID$", this.getPluginID(project, null));
        return result;
    }

    public IPath getProjectSourceLocationPath() {
        return new Path(ExtensionPointWizard.getProjectSourceLocation((IProject)this.fProject));
    }

    protected List<String> getPluginDependencies() {
        return Arrays.asList("org.eclipse.core.runtime", "org.eclipse.core.resources", "org.eclipse.imp.runtime");
    }

    private void logError(Exception e) {
        Status status = new Status(4, "org.eclipse.imp.prefspecs", 0, e.getMessage(), (Throwable)e);
        PrefspecsPlugin.getInstance().getLog().log((IStatus)status);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TranslatorVisitor
    extends AbstractVisitor {
        private TranslatorVisitor() {
        }

        @Override
        public boolean visit(prefSpecs n) {
            PrefspecsCompiler.this.fTabContainer = PrefspecsCompiler.this.fPreferencesInfo;
            if (n.gettabsSpec() == null) {
                this.createStandardTab("default", false);
                this.createStandardTab("configuration", true);
                this.createStandardTab("instance", true);
                this.createStandardTab("project", true);
            }
            return super.visit(n);
        }

        @Override
        public void unimplementedVisitor(String s) {
        }

        @Override
        public boolean visit(optPackageSpec ps) {
            PrefspecsCompiler.this.fPagePackageName = ps.getpackageName().toString();
            return false;
        }

        @Override
        public boolean visit(optDetailsSpec n) {
            PrefspecsCompiler.this.fNoDetails = n.getonOff().toString().equalsIgnoreCase("off");
            return false;
        }

        @Override
        public boolean visit(pageSpec p) {
            String pageName2 = p.getpageName().toString();
            PrefspecsCompiler.this.fCurPageInfo = new PageInfo(pageName2);
            PrefspecsCompiler.this.fCurPageInfo.setNoDetails(PrefspecsCompiler.this.fNoDetails);
            PrefspecsCompiler.this.fPages.add(PrefspecsCompiler.this.fCurPageInfo);
            PrefspecsCompiler.this.fTabContainer = PrefspecsCompiler.this.fCurPageInfo;
            PrefspecsCompiler.this.fMemberContainer.push(PrefspecsCompiler.this.fCurPageInfo);
            return true;
        }

        private void createStandardTab(String level, boolean editableRemovable) {
            TabInfo tab = new TabInfo(PrefspecsCompiler.this.fTabContainer, level);
            tab.setIsEditable(editableRemovable);
            tab.setIsRemovable(editableRemovable);
            tab.setIsUsed(true);
        }

        @Override
        public void endVisit(pageSpec p) {
            PrefspecsCompiler.this.fCurPageInfo.dump(PrefspecsCompiler.this.fConsoleStream);
            PrefspecsCompiler.this.fMemberContainer.pop();
        }

        private <T> T findSpec(generalSpecList specs, Class<T> type) {
            for (int i = 0; i < specs.size(); ++i) {
                IgeneralSpec spec = specs.getgeneralSpecAt(i);
                if (!type.isInstance(spec)) continue;
                return (T)spec;
            }
            return null;
        }

        private void checkGeneralSpecs(AbstractASTNodeList specs) {
            HashSet specsSeen = new HashSet();
            for (int i = 0; i < specs.size(); ++i) {
                ASTNode elt = specs.getElementAt(i);
                if (specsSeen.contains(elt.getClass())) {
                    PrefspecsCompiler.this.createErrorMarker("Multiple property specifications of the same type for single entity.", specs);
                }
                specsSeen.add(elt.getClass());
            }
        }

        @Override
        public boolean visit(defaultTabSpec tabSpec) {
            TabInfo tabInfo = new TabInfo(PrefspecsCompiler.this.fTabContainer, "default");
            tabInfo.setIsRemovable(false);
            tabInfo.setIsUsed(tabSpec.getinout().toString().equals("in"));
            return false;
        }

        @Override
        public boolean visit(configurationTabSpec tabSpec) {
            TabInfo tabInfo = new TabInfo(PrefspecsCompiler.this.fTabContainer, "configuration");
            tabInfo.setIsUsed(tabSpec.getinout().toString().equals("in"));
            return false;
        }

        @Override
        public boolean visit(instanceTabSpec tabSpec) {
            TabInfo tabInfo = new TabInfo(PrefspecsCompiler.this.fTabContainer, "instance");
            tabInfo.setIsUsed(tabSpec.getinout().toString().equals("in"));
            return false;
        }

        @Override
        public boolean visit(projectTabSpec tabSpec) {
            TabInfo tabInfo = new TabInfo(PrefspecsCompiler.this.fTabContainer, "project");
            tabInfo.setIsUsed(tabSpec.getinout().toString().equals("in"));
            return false;
        }

        private String unquoteString(ASTNodeToken stringLit) {
            String text = stringLit.toString();
            return this.unquoteString(text);
        }

        private String unquoteString(String text) {
            return text.substring(1, text.length() - 1);
        }

        private String getLabel(optLabelSpec labelSpec) {
            return this.unquoteString(labelSpec.getSTRING_LITERAL());
        }

        private boolean getValueOf(IbooleanValue bv) {
            return bv.toString().equals("true");
        }

        private String getValueOf(stringValue sv) {
            return sv.getSTRING_LITERAL().toString();
        }

        private int getValueOf(IsignedNumber sn) {
            if (sn instanceof signedNumber__INTEGER) {
                return Integer.parseInt(((signedNumber__INTEGER)sn).getINTEGER().toString());
            }
            signedNumber__sign_INTEGER sn1 = (signedNumber__sign_INTEGER)sn;
            int absVal = Integer.parseInt(sn1.getINTEGER().toString());
            return sn1.getsign() instanceof sign__MINUS ? -absVal : absVal;
        }

        private int getValueOf(IfontStyle style) {
            if (style instanceof fontStyle__NORMAL) {
                return 0;
            }
            if (style instanceof fontStyle__BOLD) {
                return 1;
            }
            if (style instanceof fontStyle__ITALIC) {
                return 2;
            }
            return 0;
        }

        @Override
        public boolean visit(groupSpec n) {
            FieldGroup group = new FieldGroup(n.getSTRING_LITERAL().toString(), PrefspecsCompiler.this.fMemberContainer.peek());
            PrefspecsCompiler.this.fMemberContainer.push(group);
            return true;
        }

        @Override
        public void endVisit(groupSpec n) {
            PrefspecsCompiler.this.fMemberContainer.pop();
        }

        private BooleanFieldInfo findConditionalField(final optConditionalSpec condSpec, String depFieldName) {
            final String name = condSpec.getidentifier().getIDENTIFIER().toString();
            final BooleanFieldInfo[] result = new BooleanFieldInfo[1];
            new FieldVisitor(){

                public void visitField(FieldInfo fieldInfo) {
                    String fieldName = fieldInfo.getName();
                    if (fieldName.equals(name)) {
                        if (fieldInfo instanceof BooleanFieldInfo) {
                            result[0] = (BooleanFieldInfo)fieldInfo;
                        } else {
                            PrefspecsCompiler.this.createErrorMarker("A field can only be made conditional on a boolean field", condSpec);
                        }
                    }
                }
            }.visit(PrefspecsCompiler.this.fCurPageInfo);
            if (result[0] == null) {
                PrefspecsCompiler.this.createErrorMarker("Field " + depFieldName + " is conditional on a non-existent field", condSpec);
            }
            return result[0];
        }

        private void setFieldProperties(FieldInfo field, AbstractASTNodeList generalSpecs, optConditionalSpec condSpec) {
            optToolTipSpec toolTipSpec;
            optLabelSpec labelSpec;
            this.checkGeneralSpecs(generalSpecs);
            isRemovableSpec removableSpec = this.findSpec(generalSpecs, isRemovableSpec.class);
            if (removableSpec != null) {
                field.setIsRemovable(this.getValueOf(removableSpec.getbooleanValue()));
            }
            if ((labelSpec = this.findSpec(generalSpecs, optLabelSpec.class)) != null) {
                field.setLabel(this.unquoteString(labelSpec.getSTRING_LITERAL()));
            }
            if ((toolTipSpec = this.findSpec(generalSpecs, optToolTipSpec.class)) != null) {
                field.setToolTipText(this.unquoteString(toolTipSpec.getSTRING_LITERAL()));
            }
            if (condSpec != null) {
                field.setIsConditional(true);
                field.setConditionalWith(condSpec.getconditionType() instanceof conditionType__IF);
                field.setConditionField(this.findConditionalField(condSpec, field.getName()));
            }
        }

        private <T> T findSpec(AbstractASTNodeList specs, Class<T> type) {
            for (int i = 0; i < specs.size(); ++i) {
                ASTNode elt = specs.getElementAt(i);
                if (!type.isInstance(elt)) continue;
                return (T)elt;
            }
            return null;
        }

        @Override
        public boolean visit(booleanFieldSpec boolField) {
            BooleanFieldInfo boolInfo = new BooleanFieldInfo(PrefspecsCompiler.this.fMemberContainer.peek(), boolField.getidentifier().toString());
            booleanFieldPropertySpecs propSpecs = boolField.getbooleanFieldPropertySpecs();
            if (propSpecs != null) {
                booleanSpecificSpecList booleanSpecificSpecs = propSpecs.getbooleanSpecificSpecs();
                this.setFieldProperties(boolInfo, booleanSpecificSpecs, boolField.getoptConditionalSpec());
                booleanDefValueSpec defValueSpec = this.findSpec(booleanSpecificSpecs, booleanDefValueSpec.class);
                if (defValueSpec != null) {
                    boolInfo.setDefaultValue(this.getValueOf(defValueSpec.getbooleanValue()));
                }
            }
            return false;
        }

        @Override
        public boolean visit(dirListFieldSpec dirListField) {
            DirListFieldInfo dirListInfo = new DirListFieldInfo(PrefspecsCompiler.this.fMemberContainer.peek(), dirListField.getidentifier().toString());
            dirlistFieldPropertySpecs propSpecs = dirListField.getdirlistFieldPropertySpecs();
            if (propSpecs != null) {
                IstringEmptySpec emptyValueSpec;
                stringSpecificSpecList stringSpecificSpecs = propSpecs.getstringSpecificSpecs();
                this.setFieldProperties(dirListInfo, stringSpecificSpecs, dirListField.getoptConditionalSpec());
                stringDefValueSpec defValueSpec = this.findSpec(stringSpecificSpecs, stringDefValueSpec.class);
                if (defValueSpec != null) {
                    dirListInfo.setDefaultValue(this.getValueOf(defValueSpec.getstringValue()));
                }
                if ((emptyValueSpec = this.findSpec(stringSpecificSpecs, IstringEmptySpec.class)) instanceof stringEmptySpec__EMPTYALLOWED_FALSE_SEMICOLON) {
                    dirListInfo.setEmptyValueAllowed(false);
                    dirListInfo.setEmptyValue(null);
                } else if (emptyValueSpec instanceof stringEmptySpec__EMPTYALLOWED_TRUE_stringValue_SEMICOLON) {
                    stringEmptySpec__EMPTYALLOWED_TRUE_stringValue_SEMICOLON ses1 = (stringEmptySpec__EMPTYALLOWED_TRUE_stringValue_SEMICOLON)emptyValueSpec;
                    dirListInfo.setEmptyValueAllowed(true);
                    dirListInfo.setEmptyValue(this.getValueOf(ses1.getstringValue()));
                }
            }
            return false;
        }

        @Override
        public boolean visit(directoryFieldSpec directoryField) {
            DirectoryFieldInfo dirInfo = new DirectoryFieldInfo(PrefspecsCompiler.this.fMemberContainer.peek(), directoryField.getidentifier().toString());
            directoryFieldPropertySpecs propSpecs = directoryField.getdirectoryFieldPropertySpecs();
            if (propSpecs != null) {
                IstringEmptySpec emptyValueSpec;
                stringSpecificSpecList stringSpecificSpecs = propSpecs.getstringSpecificSpecs();
                this.setFieldProperties(dirInfo, stringSpecificSpecs, directoryField.getoptConditionalSpec());
                stringDefValueSpec defValueSpec = this.findSpec(stringSpecificSpecs, stringDefValueSpec.class);
                if (defValueSpec != null) {
                    dirInfo.setDefaultValue(this.getValueOf(defValueSpec.getstringValue()));
                }
                if ((emptyValueSpec = this.findSpec(stringSpecificSpecs, IstringEmptySpec.class)) instanceof stringEmptySpec__EMPTYALLOWED_FALSE_SEMICOLON) {
                    dirInfo.setEmptyValueAllowed(false);
                    dirInfo.setEmptyValue(null);
                } else if (emptyValueSpec instanceof stringEmptySpec__EMPTYALLOWED_TRUE_stringValue_SEMICOLON) {
                    stringEmptySpec__EMPTYALLOWED_TRUE_stringValue_SEMICOLON ses1 = (stringEmptySpec__EMPTYALLOWED_TRUE_stringValue_SEMICOLON)emptyValueSpec;
                    dirInfo.setEmptyValueAllowed(true);
                    dirInfo.setEmptyValue(this.getValueOf(ses1.getstringValue()));
                }
            }
            return false;
        }

        @Override
        public boolean visit(fileFieldSpec fileField) {
            FileFieldInfo fileInfo = new FileFieldInfo(PrefspecsCompiler.this.fMemberContainer.peek(), fileField.getidentifier().toString());
            fileFieldPropertySpecs propSpecs = fileField.getfileFieldPropertySpecs();
            if (propSpecs != null) {
                IstringEmptySpec emptyValueSpec;
                stringSpecificSpecList stringSpecificSpecs = propSpecs.getstringSpecificSpecs();
                this.setFieldProperties(fileInfo, stringSpecificSpecs, fileField.getoptConditionalSpec());
                stringDefValueSpec defValueSpec = this.findSpec(stringSpecificSpecs, stringDefValueSpec.class);
                if (defValueSpec != null) {
                    fileInfo.setDefaultValue(this.getValueOf(defValueSpec.getstringValue()));
                }
                if ((emptyValueSpec = this.findSpec(stringSpecificSpecs, IstringEmptySpec.class)) instanceof stringEmptySpec__EMPTYALLOWED_FALSE_SEMICOLON) {
                    fileInfo.setEmptyValueAllowed(false);
                    fileInfo.setEmptyValue(null);
                } else if (emptyValueSpec instanceof stringEmptySpec__EMPTYALLOWED_TRUE_stringValue_SEMICOLON) {
                    stringEmptySpec__EMPTYALLOWED_TRUE_stringValue_SEMICOLON ses1 = (stringEmptySpec__EMPTYALLOWED_TRUE_stringValue_SEMICOLON)emptyValueSpec;
                    fileInfo.setEmptyValueAllowed(true);
                    fileInfo.setEmptyValue(this.getValueOf(ses1.getstringValue()));
                }
            }
            return false;
        }

        @Override
        public boolean visit(intFieldSpec intField) {
            IntFieldInfo intInfo = new IntFieldInfo(PrefspecsCompiler.this.fMemberContainer.peek(), intField.getidentifier().toString());
            intFieldPropertySpecs propSpecs = intField.getintFieldPropertySpecs();
            if (propSpecs != null) {
                intRangeSpec rangeSpec;
                intSpecificSpecList intSpecificSpecs = propSpecs.getintSpecificSpecs();
                this.setFieldProperties(intInfo, intSpecificSpecs, intField.getoptConditionalSpec());
                intDefValueSpec defValueSpec = this.findSpec(intSpecificSpecs, intDefValueSpec.class);
                if (defValueSpec != null) {
                    intInfo.setDefaultValue(this.getValueOf(defValueSpec.getsignedNumber()));
                }
                if ((rangeSpec = this.findSpec(intSpecificSpecs, intRangeSpec.class)) != null) {
                    int lowValue = this.getValueOf(rangeSpec.getlow());
                    int hiValue = this.getValueOf(rangeSpec.gethigh());
                    intInfo.setRange(lowValue, hiValue);
                }
            }
            return false;
        }

        @Override
        public boolean visit(doubleFieldSpec doubleField) {
            DoubleFieldInfo doubleInfo = new DoubleFieldInfo(PrefspecsCompiler.this.fMemberContainer.peek(), doubleField.getidentifier().toString());
            doubleFieldPropertySpecs propSpecs = doubleField.getdoubleFieldPropertySpecs();
            if (propSpecs != null) {
                doubleSpecificSpecList doubleSpecificSpecs = propSpecs.getdoubleSpecificSpecs();
                this.setFieldProperties(doubleInfo, doubleSpecificSpecs, doubleField.getoptConditionalSpec());
                doubleRangeSpec rangeSpec = this.findSpec(doubleSpecificSpecs, doubleRangeSpec.class);
                doubleDefValueSpec defValueSpec = this.findSpec(doubleSpecificSpecs, doubleDefValueSpec.class);
                if (defValueSpec != null) {
                    doubleInfo.setDefaultValue(Double.parseDouble(defValueSpec.getDECIMAL().toString()));
                }
                if (rangeSpec != null) {
                    double lowValue = Double.parseDouble(rangeSpec.getlow().toString());
                    double hiValue = Double.parseDouble(rangeSpec.gethigh().toString());
                    doubleInfo.setRange(lowValue, hiValue);
                }
            }
            return false;
        }

        @Override
        public boolean visit(stringFieldSpec stringField) {
            StringFieldInfo stringInfo = new StringFieldInfo(PrefspecsCompiler.this.fMemberContainer.peek(), stringField.getidentifier().toString());
            stringFieldPropertySpecs propSpecs = stringField.getstringFieldPropertySpecs();
            if (propSpecs != null) {
                IstringEmptySpec emptyValueSpec;
                stringSpecificSpecList stringSpecificSpecs = propSpecs.getstringSpecificSpecs();
                this.setFieldProperties(stringInfo, stringSpecificSpecs, stringField.getoptConditionalSpec());
                stringDefValueSpec defValueSpec = this.findSpec(stringSpecificSpecs, stringDefValueSpec.class);
                if (defValueSpec != null) {
                    stringInfo.setDefaultValue(this.getValueOf(defValueSpec.getstringValue()));
                }
                if ((emptyValueSpec = this.findSpec(stringSpecificSpecs, IstringEmptySpec.class)) instanceof stringEmptySpec__EMPTYALLOWED_FALSE_SEMICOLON) {
                    stringInfo.setEmptyValueAllowed(false);
                    stringInfo.setEmptyValue(null);
                } else if (emptyValueSpec instanceof stringEmptySpec__EMPTYALLOWED_TRUE_stringValue_SEMICOLON) {
                    stringEmptySpec__EMPTYALLOWED_TRUE_stringValue_SEMICOLON ses1 = (stringEmptySpec__EMPTYALLOWED_TRUE_stringValue_SEMICOLON)emptyValueSpec;
                    stringInfo.setEmptyValueAllowed(true);
                    stringInfo.setEmptyValue(this.getValueOf(ses1.getstringValue()));
                }
                stringValidatorSpec validatorSpec = this.findSpec(stringSpecificSpecs, stringValidatorSpec.class);
                if (validatorSpec != null) {
                    String validatorQualClass = this.unquoteString(validatorSpec.getqualClassName().getSTRING_LITERAL().toString());
                    IType validatorClass = PrefspecsCompiler.this.findClass(validatorQualClass);
                    stringInfo.setValidatorQualClass(validatorQualClass);
                    if (validatorClass == null) {
                        PrefspecsCompiler.this.createErrorMarker("Validator class " + validatorQualClass + " does not exist", validatorSpec);
                    } else if (!PrefspecsCompiler.this.classImplementsInterface(validatorClass, PrefspecsCompiler.VALIDATOR_INTF_QUAL_NAME)) {
                        PrefspecsCompiler.this.createErrorMarker("Validator class " + validatorQualClass + " must implement " + PrefspecsCompiler.VALIDATOR_INTF_QUAL_NAME, validatorSpec);
                    }
                }
            }
            return false;
        }

        @Override
        public boolean visit(colorFieldSpec colorField) {
            ColorFieldInfo colorInfo = new ColorFieldInfo(PrefspecsCompiler.this.fMemberContainer.peek(), colorField.getidentifier().toString());
            colorFieldPropertySpecs propSpecs = colorField.getcolorFieldPropertySpecs();
            if (propSpecs != null) {
                colorSpecificSpecList colorSpecificSpecs = propSpecs.getcolorSpecificSpecs();
                this.setFieldProperties(colorInfo, colorSpecificSpecs, colorField.getoptConditionalSpec());
                colorDefValueSpec defValueSpec = this.findSpec(colorSpecificSpecs, colorDefValueSpec.class);
                if (defValueSpec != null) {
                    int r = Integer.parseInt(defValueSpec.getred().toString());
                    int g = Integer.parseInt(defValueSpec.getgreen().toString());
                    int b = Integer.parseInt(defValueSpec.getblue().toString());
                    colorInfo.setDefaultColor(StringConverter.asString((RGB)new RGB(r, g, b)));
                }
            }
            return false;
        }

        @Override
        public boolean visit(fontFieldSpec fontField) {
            FontFieldInfo fontInfo = new FontFieldInfo(PrefspecsCompiler.this.fMemberContainer.peek(), fontField.getidentifier().toString());
            fontFieldPropertySpecs propSpecs = fontField.getfontFieldPropertySpecs();
            if (propSpecs != null) {
                fontSpecificSpecList fontSpecificSpecs = propSpecs.getfontSpecificSpecs();
                this.setFieldProperties(fontInfo, fontSpecificSpecs, fontField.getoptConditionalSpec());
                fontDefValueSpec defValueSpec = this.findSpec(fontSpecificSpecs, fontDefValueSpec.class);
                if (defValueSpec != null) {
                    fontInfo.setDefaultName(this.getValueOf(defValueSpec.getname()));
                    fontInfo.setDefaultHeight(Integer.parseInt(defValueSpec.getheight().toString()));
                    fontInfo.setDefaultStyle(this.getValueOf(defValueSpec.getstyle()));
                }
            }
            return false;
        }

        private IEnumValueSource getValueSourceFrom(IstaticOrDynamicValues sodv) {
            if (sodv instanceof labelledStringValueList) {
                return new LiteralEnumValueSource((labelledStringValueList)sodv);
            }
            if (sodv instanceof staticOrDynamicValues) {
                String qualClassName = this.unquoteString(((staticOrDynamicValues)sodv).getqualClassName().toString());
                IType qualClass = PrefspecsCompiler.this.findClass(qualClassName);
                if (qualClass == null) {
                    PrefspecsCompiler.this.createErrorMarker("Value provider class '" + qualClassName + "' does not exist in this project's classpath.", (ASTNode)((Object)sodv));
                } else if (!PrefspecsCompiler.this.classImplementsInterface(qualClass, "org.eclipse.imp.preferences.fields.IEnumValueProvider")) {
                    PrefspecsCompiler.this.createErrorMarker("Value provider class '" + qualClassName + "' must implement " + "org.eclipse.imp.preferences.fields.IEnumValueProvider", (ASTNode)((Object)sodv));
                }
                return new DynamicEnumValueSource(qualClassName);
            }
            throw new IllegalStateException("Unexpected type of enum value source: " + sodv.getClass().getCanonicalName());
        }

        @Override
        public boolean visit(typeSpec n) {
            String typeName = n.getidentifier().getIDENTIFIER().toString();
            IEnumValueSource vs = this.getValueSourceFrom(n.getstaticOrDynamicValues());
            PrefspecsCompiler.this.fTypeMap.put(typeName, vs);
            return false;
        }

        @Override
        public boolean visit(comboFieldSpec comboField) {
            ComboFieldInfo comboInfo = new ComboFieldInfo(PrefspecsCompiler.this.fMemberContainer.peek(), comboField.getidentifier().toString());
            comboFieldPropertySpecs propSpecs = comboField.getcomboFieldPropertySpecs();
            if (propSpecs != null) {
                comboSpecificSpecList comboSpecificSpecs = propSpecs.getcomboSpecificSpecs();
                enumDefValueSpec defValueSpec = this.findSpec(comboSpecificSpecs, enumDefValueSpec.class);
                ItypeOrValuesSpec tovSpec = this.findSpec(comboSpecificSpecs, ItypeOrValuesSpec.class);
                columnsSpec columnsSpec2 = this.findSpec(comboSpecificSpecs, columnsSpec.class);
                this.setFieldProperties(comboInfo, comboSpecificSpecs, comboField.getoptConditionalSpec());
                this.setupValueSource(comboInfo, tovSpec, defValueSpec);
                if (columnsSpec2 != null) {
                    comboInfo.setNumColumns(Integer.parseInt(columnsSpec2.getINTEGER().toString()));
                }
            }
            return false;
        }

        private void setupValueSource(EnumFieldInfo enumField, ItypeOrValuesSpec tovSpec, enumDefValueSpec defValueSpec) {
            IEnumValueSource vs;
            if (tovSpec instanceof typeOrValuesSpec__TYPE_identifier_SEMICOLON) {
                vs = (IEnumValueSource)PrefspecsCompiler.this.fTypeMap.get(((typeOrValuesSpec__TYPE_identifier_SEMICOLON)tovSpec).getidentifier().getIDENTIFIER().toString());
            } else {
                typeOrValuesSpec__valuesSpec_SEMICOLON tovs1 = (typeOrValuesSpec__valuesSpec_SEMICOLON)tovSpec;
                vs = this.getValueSourceFrom(tovs1.getvaluesSpec().getstaticOrDynamicValues());
            }
            if (defValueSpec != null) {
                if (vs instanceof LiteralEnumValueSource) {
                    LiteralEnumValueSource levs = (LiteralEnumValueSource)vs;
                    levs.setDefaultKey(defValueSpec.getidentifier().getIDENTIFIER().toString());
                } else {
                    PrefspecsCompiler.this.createErrorMarker("Can't specify a hard-wired default value for a dynamic value provider", defValueSpec);
                }
            }
            enumField.setValueSource(vs);
        }

        @Override
        public boolean visit(radioFieldSpec radioField) {
            RadioFieldInfo radioInfo = new RadioFieldInfo(PrefspecsCompiler.this.fMemberContainer.peek(), radioField.getidentifier().toString());
            radioFieldPropertySpecs propSpecs = radioField.getradioFieldPropertySpecs();
            if (propSpecs != null) {
                radioSpecificSpecList radioSpecificSpecs = propSpecs.getradioSpecificSpecs();
                enumDefValueSpec defValueSpec = this.findSpec(radioSpecificSpecs, enumDefValueSpec.class);
                ItypeOrValuesSpec tovSpec = this.findSpec(radioSpecificSpecs, ItypeOrValuesSpec.class);
                columnsSpec columnsSpec2 = this.findSpec(radioSpecificSpecs, columnsSpec.class);
                this.setFieldProperties(radioInfo, radioSpecificSpecs, radioField.getoptConditionalSpec());
                this.setupValueSource(radioInfo, tovSpec, defValueSpec);
                if (columnsSpec2 != null) {
                    radioInfo.setNumColumns(Integer.parseInt(columnsSpec2.getINTEGER().toString()));
                }
            }
            return false;
        }

        @Override
        public boolean visit(conditionalSpec__identifier_WITH_identifier rule) {
            String conditionalFieldName = rule.getidentifier().toString();
            String conditionFieldName = rule.getidentifier3().toString();
            this.processConditionalSpec(conditionalFieldName, conditionFieldName, true);
            return false;
        }

        @Override
        public boolean visit(conditionalSpec__identifier_AGAINST_identifier rule) {
            String conditionalFieldName = rule.getidentifier().toString();
            String conditionFieldName = rule.getidentifier3().toString();
            this.processConditionalSpec(conditionalFieldName, conditionFieldName, false);
            return false;
        }

        private void processConditionalSpec(final String conditionalFieldName, final String conditionFieldName, boolean sense) {
            final FieldInfo[] conditionalFieldInfo = new FieldInfo[1];
            final FieldInfo[] conditionFieldInfo = new FieldInfo[1];
            new FieldVisitor(){

                public void visitField(FieldInfo fieldInfo) {
                    String nextName = fieldInfo.getName();
                    if (nextName.equals(conditionalFieldName)) {
                        conditionalFieldInfo[0] = fieldInfo;
                    } else if (nextName.equals(conditionFieldName)) {
                        conditionFieldInfo[0] = fieldInfo;
                    }
                }
            }.visit(PrefspecsCompiler.this.fCurPageInfo);
            if (conditionalFieldInfo[0] != null) {
                conditionalFieldInfo[0].setIsConditional(true);
                conditionalFieldInfo[0].setConditionalWith(sense);
                conditionalFieldInfo[0].setConditionField((BooleanFieldInfo)conditionFieldInfo[0]);
            }
        }
    }
}

