/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.compiler.codegen;

import org.eclipse.imp.prefspecs.compiler.codegen.FieldCodeGenerator;
import org.eclipse.imp.prefspecs.compiler.model.PageInfo;
import org.eclipse.imp.prefspecs.compiler.model.StringFieldInfo;

public class StringFieldCodeGenerator
extends FieldCodeGenerator {
    private final StringFieldInfo fStringFieldInfo;

    public StringFieldCodeGenerator(StringFieldInfo fieldInfo) {
        super(fieldInfo);
        this.fStringFieldInfo = fieldInfo;
    }

    public void genPreferenceInitializer(StringBuilder srcText, String prefKeysClassName) {
        srcText.append("\t\tservice.setStringPreference(IPreferencesService.DEFAULT_LEVEL, " + prefKeysClassName + "." + this.getPreferenceKey() + ", " + this.fStringFieldInfo.getDefaultValue() + ");\n");
    }

    public String getFieldEditorTypeName() {
        return "StringFieldEditor";
    }

    protected String getFactoryMethodName() {
        return "makeNewStringField";
    }

    public void genTextToCreateField(StringBuilder srcText, PageInfo pageInfo, String tabLevel, String parentComposite) {
        boolean editable = !tabLevel.equals("project");
        String label = this.fFieldInfo.getLabel() != null ? this.fFieldInfo.getLabel() : this.createLabelFor(this.fFieldInfo.getName());
        String toolTip = this.fFieldInfo.getToolTipText();
        srcText.append("\n");
        srcText.append("\t\t" + this.getFieldEditorTypeName() + " " + this.fFieldInfo.getName() + " = fPrefUtils." + this.getFactoryMethodName() + "(\n");
        srcText.append("\t\t\tpage, this, fPrefService,\n");
        srcText.append("\t\t\t\"" + tabLevel + "\", \"" + this.fFieldInfo.getName() + "\", \"" + label + "\",\n");
        srcText.append("\t\t\t\"" + (toolTip != null ? toolTip : "") + "\",\n");
        srcText.append("\t\t\t" + parentComposite + ",\n");
        srcText.append("\t\t\t" + editable + ", " + editable + ",\n");
        srcText.append("\t\t\t" + this.fStringFieldInfo.getEmptyValueAllowed() + ", \"" + this.stripQuotes(this.fStringFieldInfo.getEmptyValue()) + "\",\n");
        srcText.append("\t\t\t" + this.fFieldInfo.getIsRemovable() + ");\n");
        if (this.fStringFieldInfo.getValidatorQualClass() != null && this.fStringFieldInfo.getValidatorQualClass().length() > 0) {
            srcText.append("\t\t" + this.fFieldInfo.getName() + ".setValidator(new " + this.fStringFieldInfo.getValidatorQualClass() + "());\n");
        }
        srcText.append("\t\tfields.add(" + this.fFieldInfo.getName() + ");\n\n");
        if (!pageInfo.getNoDetails()) {
            String linkName = this.fFieldInfo.getName() + "DetailsLink";
            srcText.append("\t\tLink " + linkName + " = fPrefUtils.createDetailsLink(parent, " + this.fFieldInfo.getName() + ", " + this.fFieldInfo.getName() + ".getTextControl().getParent()" + ", \"Details ...\");\n\n");
            srcText.append("\t\t" + linkName + ".setEnabled(" + editable + ");\n");
            srcText.append("\t\tfDetailsLinks.add(" + linkName + ");\n\n");
        }
    }
}

